/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.tamino.db.api.common.TDatabase;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionImpl;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.TInvocationFactory;
import java.net.MalformedURLException;

public class TConnectionFactory {
    private static TConnectionFactory singleton = new TConnectionFactory();
    private String userIdDomainSeparator = TPreference.getInstance().getUserIdDomainSeparator();

    protected TConnectionFactory() {
    }

    public static TConnectionFactory getInstance() {
        return singleton;
    }

    public TConnection newConnection(String string) throws TServerNotAvailableException {
        try {
            return new TConnectionImpl(TInvocationFactory.getInstance().newInvocation(new TDatabase(string)));
        }
        catch (TInvocationException tInvocationException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)tInvocationException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)malformedURLException);
        }
    }

    public TConnection newConnection(String string, String string2, String string3) throws TServerNotAvailableException {
        try {
            if (this.isDomainSpecified(string2)) {
                return this.newConnection(string, this.getDomain(string2), this.getUserId(string2), string3);
            }
            return new TConnectionImpl(TInvocationFactory.getInstance().newInvocation(new TDatabase(string), string2, string3));
        }
        catch (TInvocationException tInvocationException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)tInvocationException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)malformedURLException);
        }
    }

    public TConnection newConnection(String string, String string2, String string3, String string4) throws TServerNotAvailableException {
        try {
            return new TConnectionImpl(TInvocationFactory.getInstance().newInvocation(new TDatabase(string), string2, string3, string4));
        }
        catch (TInvocationException tInvocationException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)tInvocationException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new TServerNotAvailableException(TConnectionMessages.TAJCNE0201, (Exception)malformedURLException);
        }
    }

    private boolean isDomainSpecified(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf(this.userIdDomainSeparator) != -1;
    }

    private String getUserId(String string) {
        return string.substring(string.indexOf(this.userIdDomainSeparator) + 1, string.length());
    }

    private String getDomain(String string) {
        return string.substring(0, string.indexOf(this.userIdDomainSeparator));
    }
}

