/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorFactory;
import com.softwareag.tamino.db.api.accessor.TAdministrationAccessor;
import com.softwareag.tamino.db.api.accessor.TGenericAccessor;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition2Accessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition3Accessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionCloseException;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TGlobalTransaction;
import com.softwareag.tamino.db.api.connection.TGlobalTransactionSpecifier;
import com.softwareag.tamino.db.api.connection.TIsolationDegree;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TTransaction;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocation;
import com.softwareag.tamino.db.api.invocation.TCommunicationException;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseBuilderFactory;

public class TConnectionImpl
implements TConnection {
    private TInvocation invocation = null;
    private TTransactionModeCoordinator transactionModeCoordinator = null;
    private TResponseBuilderFactory responseBuilderFactory = null;
    private TAccessorFactory accessorFactory = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TConnectionImpl == null ? (class$com$softwareag$tamino$db$api$connection$TConnectionImpl = TConnectionImpl.class$("com.softwareag.tamino.db.api.connection.TConnectionImpl")) : class$com$softwareag$tamino$db$api$connection$TConnectionImpl);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TConnectionImpl == null ? (class$com$softwareag$tamino$db$api$connection$TConnectionImpl = TConnectionImpl.class$("com.softwareag.tamino.db.api.connection.TConnectionImpl")) : class$com$softwareag$tamino$db$api$connection$TConnectionImpl);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.33 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$connection$TConnectionImpl;

    protected TConnectionImpl(TInvocation tInvocation) throws TCommunicationException {
        this.invocation = tInvocation;
        this.accessorFactory = TAccessorFactory.getInstance();
        this.responseBuilderFactory = TResponseBuilderFactory.getInstance();
        Object object = TPreference.getInstance().getDefaultObjectModel();
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(object);
        TAccessLocation tAccessLocation = TAccessLocation.newInstance("");
        TGenericAccessor tGenericAccessor = this.accessorFactory.newGenericAccessor(tAccessLocation, tInvocation, tResponseBuilder);
        this.transactionModeCoordinator = new TTransactionModeCoordinator(tGenericAccessor);
        tResponseBuilder.setHelperAccessor((TAbstractAccessor)((Object)tGenericAccessor));
        tInvocation.setTransactionModeCoordinator(this.transactionModeCoordinator);
        ((TAbstractInvocation)tInvocation).checkServerAvailabilityAndVersion();
    }

    public TStreamAccessor newStreamAccessor(TAccessLocation tAccessLocation) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.accessorFactory.newStreamAccessor(tAccessLocation, this.invocation);
    }

    public TNonXMLObjectAccessor newNonXMLObjectAccessor(TAccessLocation tAccessLocation) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(TPreference.getInstance().getDefaultObjectModel());
        TNonXMLObjectAccessor tNonXMLObjectAccessor = this.accessorFactory.newNonXMLObjectAccessor(tAccessLocation, this.invocation, tResponseBuilder);
        tResponseBuilder.setHelperAccessor((TAbstractAccessor)((Object)tNonXMLObjectAccessor));
        return tNonXMLObjectAccessor;
    }

    public TXMLObjectAccessor newXMLObjectAccessor(TAccessLocation tAccessLocation, Object object) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TStreamAccessor tStreamAccessor = this.newStreamAccessor(tAccessLocation);
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(object, (TAbstractAccessor)((Object)tStreamAccessor));
        return this.accessorFactory.newXMLObjectAccessor(tStreamAccessor, tResponseBuilder);
    }

    public TSchemaDefinition2Accessor newSchemaDefinition2Accessor(Object object) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TStreamAccessor tStreamAccessor = this.newStreamAccessor(TAccessLocation.newInstance("ino:collection"));
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(object, (TAbstractAccessor)((Object)tStreamAccessor));
        return this.accessorFactory.newSchemaDefinition2Accessor(tStreamAccessor, tResponseBuilder);
    }

    public TSchemaDefinition3Accessor newSchemaDefinition3Accessor(Object object) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TStreamAccessor tStreamAccessor = this.newStreamAccessor(TAccessLocation.newInstance("ino:collection"));
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(object, (TAbstractAccessor)((Object)tStreamAccessor));
        return this.accessorFactory.newSchemaDefinition3Accessor(tStreamAccessor, tResponseBuilder);
    }

    public TSystemAccessor newSystemAccessor() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(TPreference.getInstance().getDefaultObjectModel());
        TGenericAccessor tGenericAccessor = this.accessorFactory.newGenericAccessor(TAccessLocation.newInstance(""), this.invocation, tResponseBuilder);
        tResponseBuilder.setHelperAccessor((TAbstractAccessor)((Object)tGenericAccessor));
        return this.accessorFactory.newSystemAccessor(tGenericAccessor);
    }

    public TAdministrationAccessor newAdministrationAccessor() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        TStreamAccessor tStreamAccessor = this.newStreamAccessor(TAccessLocation.newInstance(""));
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(TPreference.getInstance().getDefaultObjectModel(), (TAbstractAccessor)((Object)tStreamAccessor));
        return this.accessorFactory.newAdministrationAccessor(tStreamAccessor, tResponseBuilder);
    }

    public void useAutoCommitMode() throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("useAutoCommitMode");
        }
        this.transactionModeCoordinator.useAutoCommitMode();
    }

    public boolean usesAutoCommitMode() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.usesAutoCommitMode();
    }

    public TLocalTransaction useLocalTransactionMode() throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("useLocalTransactionMode");
        }
        return this.transactionModeCoordinator.useLocalTransactionMode();
    }

    public boolean usesLocalTransactionMode() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.usesLocalTransactionMode();
    }

    public TGlobalTransaction useGlobalTransactionMode(TGlobalTransactionSpecifier tGlobalTransactionSpecifier) throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("useGlobalTransactionMode");
        }
        return this.transactionModeCoordinator.useGlobalTransactionMode(tGlobalTransactionSpecifier);
    }

    public boolean usesGlobalTransactionMode() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.usesGlobalTransactionMode();
    }

    public TTransaction getTransaction() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.getTransaction();
    }

    public void reset() throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        this.transactionModeCoordinator.useAutoCommitMode();
        this.transactionModeCoordinator.resetTransactionParameters();
    }

    public void setIsolationLevel(TIsolationLevel tIsolationLevel) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        this.transactionModeCoordinator.setIsolationLevel(tIsolationLevel);
    }

    public TIsolationLevel getIsolationLevel() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.getIsolationLevel();
    }

    public void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        this.transactionModeCoordinator.setLockwaitMode(tLockwaitMode);
    }

    public TLockwaitMode getLockwaitMode() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.getLockwaitMode();
    }

    public void setIsolationDegree(TIsolationDegree tIsolationDegree) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        this.transactionModeCoordinator.setIsolationDegree(tIsolationDegree);
    }

    public TIsolationDegree getIsolationDegree() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.getIsolationDegree();
    }

    public void setLockMode(TLockMode tLockMode) {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        this.transactionModeCoordinator.setLockMode(tLockMode);
    }

    public TLockMode getLockMode() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.getLockMode();
    }

    public void close() throws TConnectionCloseException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.transactionModeCoordinator;
        synchronized (tTransactionModeCoordinator) {
            Precondition.check(!this.isClosed(), "Connection is already closed!");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("close");
            }
            try {
                this.useAutoCommitMode();
                this.invocation.close();
            }
            catch (Exception exception) {
                throw new TConnectionCloseException(TConnectionMessages.TAJCNE0202, exception);
            }
        }
    }

    public boolean isClosed() {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.transactionModeCoordinator;
        synchronized (tTransactionModeCoordinator) {
            boolean bl = this.invocation.isClosed();
            return bl;
        }
    }

    public String getDatabaseURI() {
        Precondition.check(!this.isClosed(), "Connection is already closed!");
        return this.invocation.getDatabase().getDatabaseURI();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

