/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionCloseException;
import com.softwareag.tamino.db.api.connection.TConnectionException;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TConnectionNotAvailableException;
import com.softwareag.tamino.db.api.connection.TConnectionPool;
import com.softwareag.tamino.db.api.connection.TConnectionWrapper;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TConnectionPoolImpl
implements TConnectionPool {
    private String name = "";
    private String databaseURI = "";
    private String user = "";
    private String domain = "";
    private String password = "";
    private int initConnections = 0;
    private int maxConnections = 0;
    private int timeOut = 0;
    private Set checkedOutConnections = null;
    private ArrayList freeConnections = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TConnectionPoolImpl == null ? (class$com$softwareag$tamino$db$api$connection$TConnectionPoolImpl = TConnectionPoolImpl.class$("com.softwareag.tamino.db.api.connection.TConnectionPoolImpl")) : class$com$softwareag$tamino$db$api$connection$TConnectionPoolImpl);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TConnectionPoolImpl == null ? (class$com$softwareag$tamino$db$api$connection$TConnectionPoolImpl = TConnectionPoolImpl.class$("com.softwareag.tamino.db.api.connection.TConnectionPoolImpl")) : class$com$softwareag$tamino$db$api$connection$TConnectionPoolImpl);
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$connection$TConnectionPoolImpl;

    public TConnectionPoolImpl(String string, String string2, String string3, String string4, int n, int n2, int n3) {
        this(string, string2, null, string3, string4, n, n2, n3);
    }

    public TConnectionPoolImpl(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3) {
        this.verifyPreconditions(string, string2, n, n2, n3);
        this.name = string;
        this.databaseURI = string2;
        this.domain = string3;
        this.user = string4;
        this.password = string5;
        this.initConnections = n2;
        this.maxConnections = n;
        this.timeOut = n3 > 0 ? n3 : 5;
        this.initializePool();
    }

    public TConnectionPoolImpl(Element element) {
        this.name = element.getAttribute("name");
        String string = " when initializing connection pool " + this.name;
        Node node = element.getElementsByTagName("DatabaseURI").item(0);
        Precondition.check(node != null, "No DatabaseURI tag given" + string);
        this.databaseURI = node.getFirstChild().getNodeValue();
        node = element.getElementsByTagName("UserId").item(0);
        this.user = node != null ? node.getFirstChild().getNodeValue() : null;
        node = element.getElementsByTagName("Domain").item(0);
        this.domain = node != null ? node.getFirstChild().getNodeValue() : null;
        node = element.getElementsByTagName("Password").item(0);
        this.password = node != null ? node.getFirstChild().getNodeValue() : null;
        node = element.getElementsByTagName("InitConnections").item(0);
        Precondition.check(node != null, "No InitConnections tag given" + string);
        try {
            this.initConnections = Integer.parseInt(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        node = element.getElementsByTagName("MaxConnections").item(0);
        Precondition.check(node != null, "No MaxConnections tag given" + string);
        try {
            this.maxConnections = Integer.parseInt(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        node = element.getElementsByTagName("TimeOut").item(0);
        Precondition.check(node != null, "No TimeOut tag given" + string);
        try {
            this.timeOut = Integer.parseInt(node.getFirstChild().getNodeValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.verifyPreconditions(this.name, this.databaseURI, this.maxConnections, this.initConnections, this.timeOut);
        this.initializePool();
    }

    public TConnection getConnection() throws TConnectionNotAvailableException {
        TConnection tConnection = this.getConnection(this.timeOut * 1000);
        return new TConnectionWrapper(tConnection, this);
    }

    public synchronized void retainConnection(TConnection tConnection) {
        if (this.checkedOutConnections.contains(tConnection)) {
            this.checkedOutConnections.remove(tConnection);
            this.freeConnections.add(tConnection);
            this.notifyAll();
        } else {
            Precondition.check(false, "retainConnection() has been called with a connection from another pool.");
        }
    }

    public synchronized void release() {
        Iterator iterator = ((AbstractList)this.freeConnections).iterator();
        while (iterator.hasNext()) {
            TConnection tConnection = (TConnection)iterator.next();
            try {
                tConnection.close();
            }
            catch (TConnectionCloseException tConnectionCloseException) {
                // empty catch block
            }
        }
        this.freeConnections.clear();
        this.checkedOutConnections.clear();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Connection Pool:" + this.name + ", Total connections:" + (this.freeConnections.size() + this.checkedOutConnections.size()) + ", Available:" + this.freeConnections.size() + ", Checked-out:" + this.checkedOutConnections.size();
    }

    private void initializePool() {
        this.freeConnections = new ArrayList(this.maxConnections);
        this.checkedOutConnections = new HashSet(this.maxConnections);
        int n = 0;
        while (n < this.initConnections) {
            try {
                TConnection tConnection = this.newConnection();
                this.freeConnections.add(tConnection);
            }
            catch (TConnectionException tConnectionException) {
                // empty catch block
            }
            ++n;
        }
    }

    private synchronized TConnection getConnection(long l) throws TConnectionNotAvailableException {
        long l2 = System.currentTimeMillis();
        long l3 = l;
        TConnection tConnection = null;
        while ((tConnection = this.getPooledConnection()) == null) {
            try {
                this.wait(l3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l3 = l - (System.currentTimeMillis() - l2);
            if (l3 > 0L) continue;
            throw new TConnectionNotAvailableException(TConnectionMessages.TAJCNE0203);
        }
        if (!this.isConnectionOK(tConnection)) {
            return this.getConnection(l3);
        }
        this.checkedOutConnections.add(tConnection);
        return tConnection;
    }

    private boolean isConnectionOK(TConnection tConnection) {
        try {
            if (tConnection.isClosed()) {
                return false;
            }
            TSystemAccessor tSystemAccessor = tConnection.newSystemAccessor();
            String string = tSystemAccessor.getServerVersion();
        }
        catch (TAccessorException tAccessorException) {
            return false;
        }
        return true;
    }

    private TConnection getPooledConnection() throws TConnectionNotAvailableException {
        TConnection tConnection = null;
        if (this.freeConnections.size() > 0) {
            tConnection = (TConnection)this.freeConnections.get(0);
            this.freeConnections.remove(0);
        } else if (this.maxConnections == 0 || this.checkedOutConnections.size() < this.maxConnections) {
            tConnection = this.newConnection();
        }
        return tConnection;
    }

    private TConnection newConnection() throws TConnectionNotAvailableException {
        TConnectionFactory tConnectionFactory = TConnectionFactory.getInstance();
        TConnection tConnection = null;
        try {
            tConnection = this.user == null ? tConnectionFactory.newConnection(this.databaseURI) : (this.domain == null ? tConnectionFactory.newConnection(this.databaseURI, this.user, this.password) : tConnectionFactory.newConnection(this.databaseURI, this.domain, this.user, this.password));
        }
        catch (TServerNotAvailableException tServerNotAvailableException) {
            throw new TConnectionNotAvailableException(tServerNotAvailableException);
        }
        return tConnection;
    }

    private void verifyPreconditions(String string, String string2, int n, int n2, int n3) {
        Precondition.check(string != null && string.length() > 0, "No pool name given!");
        String string3 = " when initializing connection pool " + string;
        Precondition.check(string2 != null && string2.length() > 0, "No databaseURI given" + string3);
        Precondition.check(n > 0, "No appropiate value given for maxConnections!");
        Precondition.check(n2 > 0, "No appropiate value given for initConnections!");
        Precondition.check(n2 < n, "Maximum number of connections has to be greater then initialized number of connections.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

