/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionNotAvailableException;
import com.softwareag.tamino.db.api.connection.TConnectionPool;
import com.softwareag.tamino.db.api.connection.TConnectionPoolImpl;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TConnectionPoolManager {
    private static final String MANAGED_POOLS_RESOURCE = "ManagedConnectionPools.xml";
    private static TConnectionPoolManager singleton = null;
    private HashMap pools = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TConnectionPoolManager == null ? (class$com$softwareag$tamino$db$api$connection$TConnectionPoolManager = TConnectionPoolManager.class$("com.softwareag.tamino.db.api.connection.TConnectionPoolManager")) : class$com$softwareag$tamino$db$api$connection$TConnectionPoolManager);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TConnectionPoolManager == null ? (class$com$softwareag$tamino$db$api$connection$TConnectionPoolManager = TConnectionPoolManager.class$("com.softwareag.tamino.db.api.connection.TConnectionPoolManager")) : class$com$softwareag$tamino$db$api$connection$TConnectionPoolManager);
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$connection$TConnectionPoolManager;

    private TConnectionPoolManager() {
        this.initialize();
    }

    public static synchronized TConnectionPoolManager getInstance() {
        if (singleton == null) {
            singleton = new TConnectionPoolManager();
        }
        return singleton;
    }

    public TConnection getConnection(String string) throws TConnectionNotAvailableException {
        TConnection tConnection = null;
        TConnectionPool tConnectionPool = (TConnectionPool)this.pools.get(string);
        if (tConnectionPool != null) {
            tConnection = tConnectionPool.getConnection();
        } else {
            Precondition.check(false, "No pool has been found, thus no connection is available!");
        }
        return tConnection;
    }

    public synchronized void release() {
        Iterator iterator = this.pools.values().iterator();
        while (iterator.hasNext()) {
            TConnectionPool tConnectionPool = (TConnectionPool)iterator.next();
            tConnectionPool.release();
        }
        this.pools.clear();
    }

    public Iterator getPoolNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.pools.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((TConnectionPool)iterator.next()).getName());
        }
        return ((AbstractList)arrayList).iterator();
    }

    public boolean hasPool(String string) {
        return this.pools.containsKey(string);
    }

    public boolean addConnectionPool(String string, String string2, String string3, String string4, int n, int n2, int n3) {
        if (this.hasPool(string)) {
            return false;
        }
        TConnectionPoolImpl tConnectionPoolImpl = new TConnectionPoolImpl(string, string2, string3, string4, n, n2, n3);
        this.pools.put(tConnectionPoolImpl.getName(), tConnectionPoolImpl);
        return true;
    }

    public boolean addConnectionPool(String string, String string2, String string3, String string4, String string5, int n, int n2, int n3) {
        if (this.hasPool(string)) {
            return false;
        }
        TConnectionPoolImpl tConnectionPoolImpl = new TConnectionPoolImpl(string, string2, string3, string4, string5, n, n2, n3);
        this.pools.put(tConnectionPoolImpl.getName(), tConnectionPoolImpl);
        return true;
    }

    public void addConnectionPools(InputStream inputStream) {
        this.createPools(inputStream);
    }

    public boolean isEmpty() {
        return this.pools.isEmpty();
    }

    public String toString() {
        Iterator iterator = this.pools.values().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append(((TConnectionPool)iterator.next()).toString());
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    private void initialize() {
        this.pools = new HashMap();
        this.getClass().getClassLoader();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(MANAGED_POOLS_RESOURCE);
        if (inputStream != null) {
            this.createPools(inputStream);
        }
    }

    private void createPools(InputStream inputStream) {
        Object object;
        Document document = null;
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(inputStream);
        }
        catch (Exception exception) {
            return;
        }
        object = document.getElementsByTagName("ConnectionPool");
        int n = 0;
        while (n < object.getLength()) {
            Element element = (Element)object.item(n);
            if (!this.hasPool(element.getAttribute("name"))) {
                TConnectionPoolImpl tConnectionPoolImpl = new TConnectionPoolImpl(element);
                this.pools.put(tConnectionPoolImpl.getName(), tConnectionPoolImpl);
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

