/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAdministrationAccessor;
import com.softwareag.tamino.db.api.accessor.TInvalidatableAccessor;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition2Accessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition3Accessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionCloseException;
import com.softwareag.tamino.db.api.connection.TConnectionPool;
import com.softwareag.tamino.db.api.connection.TIsolationDegree;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TTransaction;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

class TConnectionWrapper
implements TConnection {
    TConnection wrappedConnection;
    private TConnectionPool pool;
    private ArrayList invalidatableAccessors = null;
    private boolean isClosed = false;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TConnectionWrapper == null ? (class$com$softwareag$tamino$db$api$connection$TConnectionWrapper = TConnectionWrapper.class$("com.softwareag.tamino.db.api.connection.TConnectionWrapper")) : class$com$softwareag$tamino$db$api$connection$TConnectionWrapper);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TConnectionWrapper == null ? (class$com$softwareag$tamino$db$api$connection$TConnectionWrapper = TConnectionWrapper.class$("com.softwareag.tamino.db.api.connection.TConnectionWrapper")) : class$com$softwareag$tamino$db$api$connection$TConnectionWrapper);
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$connection$TConnectionWrapper;

    public TConnectionWrapper(TConnection tConnection, TConnectionPool tConnectionPool) {
        this.wrappedConnection = tConnection;
        this.pool = tConnectionPool;
        this.invalidatableAccessors = new ArrayList();
    }

    public TNonXMLObjectAccessor newNonXMLObjectAccessor(TAccessLocation tAccessLocation) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TNonXMLObjectAccessor tNonXMLObjectAccessor = this.wrappedConnection.newNonXMLObjectAccessor(tAccessLocation);
        this.invalidatableAccessors.add((TInvalidatableAccessor)tNonXMLObjectAccessor);
        return tNonXMLObjectAccessor;
    }

    public TXMLObjectAccessor newXMLObjectAccessor(TAccessLocation tAccessLocation, Object object) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TXMLObjectAccessor tXMLObjectAccessor = this.wrappedConnection.newXMLObjectAccessor(tAccessLocation, object);
        this.invalidatableAccessors.add((TInvalidatableAccessor)tXMLObjectAccessor);
        return tXMLObjectAccessor;
    }

    public TStreamAccessor newStreamAccessor(TAccessLocation tAccessLocation) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TStreamAccessor tStreamAccessor = this.wrappedConnection.newStreamAccessor(tAccessLocation);
        this.invalidatableAccessors.add((TInvalidatableAccessor)tStreamAccessor);
        return tStreamAccessor;
    }

    public TSchemaDefinition2Accessor newSchemaDefinition2Accessor(Object object) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TSchemaDefinition2Accessor tSchemaDefinition2Accessor = this.wrappedConnection.newSchemaDefinition2Accessor(object);
        this.invalidatableAccessors.add((TInvalidatableAccessor)tSchemaDefinition2Accessor);
        return tSchemaDefinition2Accessor;
    }

    public TSchemaDefinition3Accessor newSchemaDefinition3Accessor(Object object) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TSchemaDefinition3Accessor tSchemaDefinition3Accessor = this.wrappedConnection.newSchemaDefinition3Accessor(object);
        this.invalidatableAccessors.add((TInvalidatableAccessor)tSchemaDefinition3Accessor);
        return tSchemaDefinition3Accessor;
    }

    public TSystemAccessor newSystemAccessor() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TSystemAccessor tSystemAccessor = this.wrappedConnection.newSystemAccessor();
        this.invalidatableAccessors.add((TInvalidatableAccessor)tSystemAccessor);
        return tSystemAccessor;
    }

    public TAdministrationAccessor newAdministrationAccessor() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        TAdministrationAccessor tAdministrationAccessor = this.wrappedConnection.newAdministrationAccessor();
        this.invalidatableAccessors.add((TInvalidatableAccessor)tAdministrationAccessor);
        return tAdministrationAccessor;
    }

    public void useAutoCommitMode() throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        this.wrappedConnection.useAutoCommitMode();
    }

    public boolean usesAutoCommitMode() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.usesAutoCommitMode();
    }

    public TLocalTransaction useLocalTransactionMode() throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.useLocalTransactionMode();
    }

    public boolean usesLocalTransactionMode() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.usesLocalTransactionMode();
    }

    public TTransaction getTransaction() {
        Precondition.check(!this.isClosed(), "Pooled Connection is already closed!");
        return this.wrappedConnection.getTransaction();
    }

    public void reset() throws TTransactionModeChangeException {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        this.wrappedConnection.reset();
    }

    public void setIsolationLevel(TIsolationLevel tIsolationLevel) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        this.wrappedConnection.setIsolationLevel(tIsolationLevel);
    }

    public TIsolationLevel getIsolationLevel() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.getIsolationLevel();
    }

    public void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        this.wrappedConnection.setLockwaitMode(tLockwaitMode);
    }

    public TLockwaitMode getLockwaitMode() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.getLockwaitMode();
    }

    public void setIsolationDegree(TIsolationDegree tIsolationDegree) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        this.wrappedConnection.setIsolationDegree(tIsolationDegree);
    }

    public TIsolationDegree getIsolationDegree() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.getIsolationDegree();
    }

    public void setLockMode(TLockMode tLockMode) {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        this.wrappedConnection.setLockMode(tLockMode);
    }

    public TLockMode getLockMode() {
        Precondition.check(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.getLockMode();
    }

    public void close() throws TConnectionCloseException {
        this.isClosed = true;
        try {
            this.wrappedConnection.useAutoCommitMode();
            Iterator iterator = ((AbstractList)this.invalidatableAccessors).iterator();
            while (iterator.hasNext()) {
                TInvalidatableAccessor tInvalidatableAccessor = (TInvalidatableAccessor)iterator.next();
                tInvalidatableAccessor.invalidate();
            }
            this.invalidatableAccessors.clear();
        }
        catch (TException tException) {
            // empty catch block
        }
        this.pool.retainConnection(this.wrappedConnection);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

