/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.connection.TGlobalTransaction;
import com.softwareag.tamino.db.api.connection.TGlobalTransactionSpecifier;
import com.softwareag.tamino.db.api.connection.TSessionStateUpdateException;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connection.TTransactionMode;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.io.TStreamHeader;

public class TGlobalTransactionMode
extends TTransactionMode
implements TGlobalTransaction {
    private boolean firstCommandInTransaction = false;
    private TGlobalTransactionSpecifier globalTransactionSpecifier = null;

    public TGlobalTransactionMode(TTransactionModeCoordinator tTransactionModeCoordinator) {
        super(tTransactionModeCoordinator);
    }

    public void setGlobalTransactionSpecifier(TGlobalTransactionSpecifier tGlobalTransactionSpecifier) {
        this.globalTransactionSpecifier = tGlobalTransactionSpecifier;
    }

    public void writeTo(TCommandStatement tCommandStatement) {
        TCommand tCommand;
        if (this.needsSessionState(tCommandStatement.getCommand())) {
            this.getSessionState().writeTo(tCommandStatement);
        }
        if ((tCommand = tCommandStatement.getCommand()) == TCommand.CONNECT || tCommand == TCommand.ENLIST_2PC || this.firstCommandInTransaction) {
            this.getTransactionParameters().writeTo(tCommandStatement);
        }
        this.firstCommandInTransaction = tCommand == TCommand.CONNECT || tCommand == TCommand.ENLIST_2PC;
    }

    public boolean supports(TCommand tCommand) {
        return true;
    }

    public boolean needsSessionState(TCommand tCommand) {
        return tCommand != TCommand.DIAGNOSE;
    }

    public synchronized void begin() throws TAccessorException {
        Precondition.check(this.globalTransactionSpecifier != null, "No global transaction specifier given.");
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CONNECT, new TCommandValue("*"));
        this.globalTransactionSpecifier.writeTo(tCommandStatement);
        this.getGenericAccessor().execute(tCommandStatement);
        this.use();
    }

    public synchronized void end() throws TAccessorException {
        this.globalTransactionSpecifier = null;
        this.release();
    }

    public synchronized void enlist(TGlobalTransactionSpecifier tGlobalTransactionSpecifier) throws TTransactionException {
        this.globalTransactionSpecifier = tGlobalTransactionSpecifier;
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.ENLIST_2PC, new TCommandValue("*"));
        tGlobalTransactionSpecifier.writeTo(tCommandStatement);
        try {
            this.getGenericAccessor().execute(tCommandStatement);
        }
        catch (TAccessorException tAccessorException) {
            throw new TTransactionException(tAccessorException);
        }
    }

    protected void doUpdate(TStreamHeader tStreamHeader) throws TSessionStateUpdateException {
        this.getSessionState().update(tStreamHeader);
    }

    public String toString() {
        String string = this.globalTransactionSpecifier != null ? this.globalTransactionSpecifier.toString() : "null";
        return "Global Transaction Mode: " + this.getSessionState().toString() + ", " + string;
    }
}

