/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TSessionStateUpdateException;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connection.TTransactionMode;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.response.TResponse;

public class TLocalTransactionMode
extends TTransactionMode
implements TLocalTransaction {
    private boolean firstCommandInTransaction = false;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode == null ? (class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode = TLocalTransactionMode.class$("com.softwareag.tamino.db.api.connection.TLocalTransactionMode")) : class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode == null ? (class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode = TLocalTransactionMode.class$("com.softwareag.tamino.db.api.connection.TLocalTransactionMode")) : class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.18 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode;

    public TLocalTransactionMode(TTransactionModeCoordinator tTransactionModeCoordinator) {
        super(tTransactionModeCoordinator);
    }

    public synchronized void begin() throws TAccessorException {
        String string = TPreference.getInstance().getLocalTransactionConnectMode();
        string = string == null ? "*" : string;
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CONNECT, new TCommandValue(string));
        this.getGenericAccessor().execute(tCommandStatement);
        this.use();
    }

    public synchronized void end() throws TAccessorException {
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DISCONNECT, new TCommandValue("*"));
        this.getGenericAccessor().execute(tCommandStatement);
        this.release();
    }

    public synchronized void commit() throws TTransactionException {
        Precondition.check(!this.isReleased(), "Precondition Violation. Local transaction has already been released!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("commit");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.COMMIT, new TCommandValue("*"));
        try {
            TResponse tResponse = this.getGenericAccessor().execute(tCommandStatement);
        }
        catch (TAccessorException tAccessorException) {
            throw new TTransactionException(TConnectionMessages.TAJCNE0204, (Exception)tAccessorException);
        }
    }

    public synchronized void rollback() throws TTransactionException {
        Precondition.check(!this.isReleased(), "Precondition Violation. Local transaction has already been released!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("rollback");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.ROLLBACK, new TCommandValue("*"));
        try {
            TResponse tResponse = this.getGenericAccessor().execute(tCommandStatement);
        }
        catch (TAccessorException tAccessorException) {
            throw new TTransactionException(TConnectionMessages.TAJCNE0205, (Exception)tAccessorException);
        }
    }

    public void writeTo(TCommandStatement tCommandStatement) {
        TCommand tCommand;
        if (this.needsSessionState(tCommandStatement.getCommand())) {
            this.getSessionState().writeTo(tCommandStatement);
        }
        if ((tCommand = tCommandStatement.getCommand()) == TCommand.CONNECT || this.firstCommandInTransaction) {
            this.getTransactionParameters().writeTo(tCommandStatement);
        }
        this.firstCommandInTransaction = tCommand == TCommand.CONNECT || tCommand == TCommand.COMMIT || tCommand == TCommand.ROLLBACK;
    }

    public boolean supports(TCommand tCommand) {
        return tCommand != TCommand.CONNECT;
    }

    public boolean needsSessionState(TCommand tCommand) {
        return tCommand != TCommand.DIAGNOSE;
    }

    protected void doUpdate(TStreamHeader tStreamHeader) throws TSessionStateUpdateException {
        this.getSessionState().update(tStreamHeader);
    }

    public String toString() {
        return "Local Transaction Mode.\n" + this.getSessionState().toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

