/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TSessionStateUpdateException;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.message.TResourceId;

public class TSessionState {
    private String sessionId = "";
    private String sessionKey = "";
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.19 $");
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode == null ? (class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode = TSessionState.class$("com.softwareag.tamino.db.api.connection.TLocalTransactionMode")) : class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode == null ? (class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode = TSessionState.class$("com.softwareag.tamino.db.api.connection.TLocalTransactionMode")) : class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode);
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$connection$TLocalTransactionMode;

    protected TSessionState() {
    }

    protected void writeTo(TCommandStatement tCommandStatement) {
        if (this.isGiven()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing session state to TCommandStatement, sessionId:" + this.getSessionId() + ", sessionKey:" + this.getSessionKey());
            }
            tCommandStatement.addCommandParameter(TCommandParameter.SESSION_ID, new TCommandParameterValue(this.getSessionId()));
            tCommandStatement.addCommandParameter(TCommandParameter.SESSION_KEY, new TCommandParameterValue(this.getSessionKey()));
        }
    }

    protected void writeTo(TStreamHeader tStreamHeader) {
        if (this.isGiven()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing session state to TStreamHeader, sessionId:" + this.getSessionId() + ", sessionKey:" + this.getSessionKey());
            }
            tStreamHeader.put("X-INO-Sessionid", this.getSessionId());
            tStreamHeader.put("X-INO-Sessionkey", this.getSessionKey());
        }
    }

    protected void update(TStreamHeader tStreamHeader) throws TSessionStateUpdateException {
        String string = "";
        String string2 = "";
        if (tStreamHeader != null) {
            string = tStreamHeader.getValue("X-INO-Sessionid", "");
            string2 = tStreamHeader.getValue("X-INO-Sessionkey", "");
        }
        this.update(string, string2);
    }

    public void update(String string, String string2) throws TSessionStateUpdateException {
        Precondition.check(string != null && string2 != null, "Precondition Violation. Both newSessionId and newSessionKey must not be null.");
        if (this.isGiven()) {
            if (string.equals(this.getSessionId()) && !string2.equals(this.getSessionKey())) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("SessionState UPDATED ( " + this.sessionId + ", " + this.sessionKey + "->" + string2 + " )");
                }
                this.setSessionKey(string2);
                return;
            }
            if (string.length() == 0 && string2.length() == 0 && logger.isLoggable(Level.SEVERE)) {
                logger.severe("SessionState LOST ( " + this.sessionId + ", " + this.sessionKey + " ), maybe because of a db timeout.");
            }
            if (string.equals(this.getSessionId()) && string2.equals(this.getSessionKey()) && logger.isLoggable(Level.SEVERE)) {
                logger.severe("SessionState DOUBLED ( " + this.sessionId + ", " + this.sessionKey + " )");
            }
            TResourceId tResourceId = TConnectionMessages.TAJCNE0206;
            String string3 = this.sessionId + "->" + string + ", " + this.sessionKey + "->" + string2;
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("SessionState FAILED ( " + string3 + " )");
            }
            tResourceId.setParams(new Object[]{string3});
            throw new TSessionStateUpdateException(tResourceId);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("SessionState STARTED ( " + string + ", " + string2 + " )");
        }
        this.setSessionId(string);
        this.setSessionKey(string2);
    }

    public void reset() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("SessionState RESETED ( " + this.sessionId + ", " + this.sessionKey + " ) ");
        }
        this.sessionId = "";
        this.sessionKey = "";
    }

    protected void setSessionId(String string) {
        this.sessionId = TString.stringize(string);
    }

    protected void setSessionKey(String string) {
        this.sessionKey = TString.stringize(string);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public boolean isGiven() {
        return !TString.isEmpty(this.sessionId) && !TString.isEmpty(this.sessionKey);
    }

    public String toString() {
        return "TSessionState:" + " sessionId: " + this.sessionId + ", sessionKey:" + this.sessionKey;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

