/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TGenericAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TAccessFailureException;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TSessionState;
import com.softwareag.tamino.db.api.connection.TSessionStateUpdateException;
import com.softwareag.tamino.db.api.connection.TTransaction;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.connection.TTransactionModeUpdateException;
import com.softwareag.tamino.db.api.connection.TTransactionParameters;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;

public abstract class TTransactionMode
implements TTransaction {
    private TTransactionParameters transactionParameters = null;
    private TSessionState sessionState = null;
    private boolean isReleased = false;
    private TTransactionModeCoordinator transactionModeCoordinator = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TTransactionMode == null ? (class$com$softwareag$tamino$db$api$connection$TTransactionMode = TTransactionMode.class$("com.softwareag.tamino.db.api.connection.TTransactionMode")) : class$com$softwareag$tamino$db$api$connection$TTransactionMode);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TTransactionMode == null ? (class$com$softwareag$tamino$db$api$connection$TTransactionMode = TTransactionMode.class$("com.softwareag.tamino.db.api.connection.TTransactionMode")) : class$com$softwareag$tamino$db$api$connection$TTransactionMode);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.25 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$connection$TTransactionMode;

    public TTransactionMode(TTransactionModeCoordinator tTransactionModeCoordinator) {
        this.transactionModeCoordinator = tTransactionModeCoordinator;
    }

    public void update(TInputStream tInputStream) throws TTransactionModeUpdateException {
        try {
            this.doUpdate(tInputStream.getHeader());
        }
        catch (TSessionStateUpdateException tSessionStateUpdateException) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Transaction mode cannot be updated." + tSessionStateUpdateException);
            }
            if (tInputStream.isGiven()) {
                TAccessFailureException tAccessFailureException = new TAccessFailureException(tInputStream);
                throw new TTransactionModeUpdateException(TConnectionMessages.TAJCNE0208, (Exception)tAccessFailureException);
            }
            throw new TTransactionModeUpdateException(TConnectionMessages.TAJCNE0210, (Exception)tSessionStateUpdateException);
        }
    }

    protected abstract void doUpdate(TStreamHeader var1) throws TSessionStateUpdateException;

    public abstract void writeTo(TCommandStatement var1);

    public abstract boolean supports(TCommand var1);

    public abstract boolean needsSessionState(TCommand var1);

    public abstract void begin() throws TAccessorException;

    public abstract void end() throws TAccessorException;

    public TTransactionParameters getTransactionParameters() {
        return this.transactionModeCoordinator.getTransactionParameters();
    }

    public TSessionState getSessionState() {
        return this.transactionModeCoordinator.getSessionState();
    }

    protected TGenericAccessor getGenericAccessor() {
        return this.transactionModeCoordinator.getGenericAccessor();
    }

    protected void use() {
        this.isReleased = false;
    }

    protected void release() {
        this.isReleased = true;
    }

    protected boolean isReleased() {
        return this.isReleased;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

