/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TGenericAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.connection.TAutoCommitTransactionMode;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TGlobalTransaction;
import com.softwareag.tamino.db.api.connection.TGlobalTransactionMode;
import com.softwareag.tamino.db.api.connection.TGlobalTransactionSpecifier;
import com.softwareag.tamino.db.api.connection.TIsolationDegree;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLocalTransactionMode;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TSessionState;
import com.softwareag.tamino.db.api.connection.TTransaction;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connection.TTransactionMode;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.connection.TTransactionModeUpdateException;
import com.softwareag.tamino.db.api.connection.TTransactionParameters;
import com.softwareag.tamino.db.api.io.TInputStream;
import java.util.HashMap;

public class TTransactionModeCoordinator {
    private static final String AUTOCOMMIT_TRANSACTION_MODE = "AutoCommitTransactionMode";
    private static final String LOCAL_TRANSACTION_MODE = "LocalTransactionMode";
    private static final String GLOBAL_TRANSACTION_MODE = "GlobalTransactionMode";
    private TGenericAccessor genericAccessor = null;
    private TSessionState sessionState = null;
    private TTransactionParameters transactionParameters = null;
    private HashMap transactionModeMap = null;
    private TTransactionMode transactionMode = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TTransactionModeCoordinator == null ? (class$com$softwareag$tamino$db$api$connection$TTransactionModeCoordinator = TTransactionModeCoordinator.class$("com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator")) : class$com$softwareag$tamino$db$api$connection$TTransactionModeCoordinator);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$connection$TTransactionModeCoordinator == null ? (class$com$softwareag$tamino$db$api$connection$TTransactionModeCoordinator = TTransactionModeCoordinator.class$("com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator")) : class$com$softwareag$tamino$db$api$connection$TTransactionModeCoordinator);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.19 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$connection$TTransactionModeCoordinator;

    public TTransactionModeCoordinator(TGenericAccessor tGenericAccessor) {
        this.initialize(tGenericAccessor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void useAutoCommitMode() throws TTransactionModeChangeException {
        try {
            block10: {
                if (this.usesAutoCommitMode()) {
                    this.releaseAutoCommitTransactionMode();
                    break block10;
                }
                if (this.usesLocalTransactionMode()) {
                    this.releaseLocalTransactionMode();
                    break block10;
                }
                if (this.usesGlobalTransactionMode()) {
                    this.releaseGlobalTransactionMode();
                }
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.transactionMode = (TTransactionMode)this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
            try {
                this.transactionMode.begin();
                throw throwable;
            }
            catch (TAccessorException tAccessorException) {
                throw new TTransactionModeChangeException(tAccessorException.getAccessFailureMessage().toString(), (Exception)tAccessorException);
            }
        }
        this.transactionMode = (TTransactionMode)this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
        try {}
        catch (TAccessorException tAccessorException) {
            throw new TTransactionModeChangeException(tAccessorException.getAccessFailureMessage().toString(), (Exception)tAccessorException);
        }
        this.transactionMode.begin();
    }

    public synchronized boolean usesAutoCommitMode() {
        return this.transactionMode == this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
    }

    public synchronized TLocalTransaction useLocalTransactionMode() throws TTransactionModeChangeException {
        Precondition.check(this.usesAutoCommitMode(), "Currently no autocommit mode given. Local transaction mode cannot be initiated!");
        try {
            this.releaseAutoCommitTransactionMode();
            TLocalTransactionMode tLocalTransactionMode = (TLocalTransactionMode)this.transactionModeMap.get(LOCAL_TRANSACTION_MODE);
            this.transactionMode = tLocalTransactionMode;
            tLocalTransactionMode.begin();
            return tLocalTransactionMode;
        }
        catch (TAccessorException tAccessorException) {
            this.transactionMode = (TTransactionMode)this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
            this.useAutoCommitMode();
            throw new TTransactionModeChangeException(TConnectionMessages.TAJCNE0211, (Exception)tAccessorException);
        }
    }

    public synchronized boolean usesLocalTransactionMode() {
        return this.transactionMode == this.transactionModeMap.get(LOCAL_TRANSACTION_MODE);
    }

    public synchronized TGlobalTransaction useGlobalTransactionMode(TGlobalTransactionSpecifier tGlobalTransactionSpecifier) throws TTransactionModeChangeException {
        Precondition.check(this.usesAutoCommitMode() || this.usesGlobalTransactionMode(), "Currently no autocommit mode or global transaction mode given. Global transaction mode cannot be initiated!");
        TGlobalTransactionMode tGlobalTransactionMode = null;
        if (this.usesAutoCommitMode()) {
            try {
                this.releaseAutoCommitTransactionMode();
                tGlobalTransactionMode = (TGlobalTransactionMode)this.transactionModeMap.get(GLOBAL_TRANSACTION_MODE);
                tGlobalTransactionMode.setGlobalTransactionSpecifier(tGlobalTransactionSpecifier);
                this.transactionMode = tGlobalTransactionMode;
                tGlobalTransactionMode.begin();
            }
            catch (TAccessorException tAccessorException) {
                this.transactionMode = (TTransactionMode)this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
                this.useAutoCommitMode();
                throw new TTransactionModeChangeException(TConnectionMessages.TAJCNE0213, (Exception)tAccessorException);
            }
        }
        if (this.usesGlobalTransactionMode()) {
            try {
                tGlobalTransactionMode = (TGlobalTransactionMode)this.transactionModeMap.get(GLOBAL_TRANSACTION_MODE);
                tGlobalTransactionMode.enlist(tGlobalTransactionSpecifier);
            }
            catch (TTransactionException tTransactionException) {
                throw new TTransactionModeChangeException(TConnectionMessages.TAJCNE0214, (Exception)tTransactionException);
            }
        }
        return tGlobalTransactionMode;
    }

    public synchronized boolean usesGlobalTransactionMode() {
        return this.transactionMode == this.transactionModeMap.get(GLOBAL_TRANSACTION_MODE);
    }

    public synchronized TTransaction getTransaction() {
        return this.transactionMode;
    }

    public synchronized void resetTransactionParameters() {
        this.transactionParameters.reset();
    }

    public synchronized void resetSessionState() {
        this.sessionState.reset();
    }

    public synchronized void setIsolationLevel(TIsolationLevel tIsolationLevel) {
        this.transactionParameters.setIsolationLevel(tIsolationLevel);
    }

    public synchronized TIsolationLevel getIsolationLevel() {
        return this.transactionParameters.getIsolationLevel();
    }

    public synchronized void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        this.transactionParameters.setLockwaitMode(tLockwaitMode);
    }

    public synchronized TLockwaitMode getLockwaitMode() {
        return this.transactionParameters.getLockwaitMode();
    }

    public synchronized void setIsolationDegree(TIsolationDegree tIsolationDegree) {
        this.transactionParameters.setIsolationDegree(tIsolationDegree);
    }

    public synchronized TIsolationDegree getIsolationDegree() {
        return this.transactionParameters.getIsolationDegree();
    }

    public synchronized void setLockMode(TLockMode tLockMode) {
        this.transactionParameters.setLockMode(tLockMode);
    }

    public synchronized TLockMode getLockMode() {
        return this.transactionParameters.getLockMode();
    }

    public synchronized void writeModeTo(TCommandStatement tCommandStatement) {
        this.transactionMode.writeTo(tCommandStatement);
    }

    public synchronized void updateModeFrom(TInputStream tInputStream) throws TTransactionModeUpdateException {
        this.transactionMode.update(tInputStream);
    }

    public synchronized boolean supports(TCommand tCommand) {
        return this.transactionMode.supports(tCommand);
    }

    public boolean needsSessionState(TCommand tCommand) {
        return this.transactionMode.needsSessionState(tCommand);
    }

    TGenericAccessor getGenericAccessor() {
        return this.genericAccessor;
    }

    TSessionState getSessionState() {
        return this.sessionState;
    }

    TTransactionParameters getTransactionParameters() {
        return this.transactionParameters;
    }

    private synchronized void releaseAutoCommitTransactionMode() throws TTransactionModeChangeException {
        TAutoCommitTransactionMode tAutoCommitTransactionMode = (TAutoCommitTransactionMode)this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
        this.release(tAutoCommitTransactionMode);
    }

    private synchronized void releaseLocalTransactionMode() throws TTransactionModeChangeException {
        Precondition.check(this.usesLocalTransactionMode() && !this.transactionMode.isReleased(), "Local transaction can only be released within active local transaction mode!");
        TLocalTransactionMode tLocalTransactionMode = (TLocalTransactionMode)this.transactionModeMap.get(LOCAL_TRANSACTION_MODE);
        this.release(tLocalTransactionMode);
    }

    private synchronized void releaseGlobalTransactionMode() throws TTransactionModeChangeException {
        Precondition.check(this.usesGlobalTransactionMode() && !this.transactionMode.isReleased(), "Global transaction can only be released within active global transaction mode!");
        TGlobalTransactionMode tGlobalTransactionMode = (TGlobalTransactionMode)this.transactionModeMap.get(GLOBAL_TRANSACTION_MODE);
        this.release(tGlobalTransactionMode);
    }

    private synchronized void release(TTransactionMode tTransactionMode) throws TTransactionModeChangeException {
        try {
            try {
                tTransactionMode.end();
            }
            catch (TAccessorException tAccessorException) {
                throw new TTransactionModeChangeException(TConnectionMessages.TAJCNE0212, (Exception)tAccessorException);
            }
            Object var4_2 = null;
            this.sessionState.reset();
            tTransactionMode.release();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.sessionState.reset();
            tTransactionMode.release();
            throw throwable;
        }
    }

    private void initialize(TGenericAccessor tGenericAccessor) {
        this.genericAccessor = tGenericAccessor;
        this.sessionState = new TSessionState();
        this.transactionParameters = new TTransactionParameters();
        this.transactionModeMap = new HashMap();
        this.transactionModeMap.put(AUTOCOMMIT_TRANSACTION_MODE, new TAutoCommitTransactionMode(this));
        this.transactionModeMap.put(LOCAL_TRANSACTION_MODE, new TLocalTransactionMode(this));
        this.transactionModeMap.put(GLOBAL_TRANSACTION_MODE, new TGlobalTransactionMode(this));
        this.transactionMode = (TTransactionMode)this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
    }

    public String toString() {
        return "TTransactionModeCoordinator( " + this.sessionState.toString() + ", " + this.transactionParameters.toString() + " )";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

