/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.connection.TIsolationDegree;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.io.TStreamHeader;

public class TTransactionParameters {
    private TIsolationLevel isolationLevel = null;
    private TLockwaitMode lockwaitMode = null;
    private TIsolationDegree isolationDegree = null;
    private TLockMode lockMode = null;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.5 $");

    public TTransactionParameters() {
        this.reset();
    }

    public synchronized void writeTo(TCommandStatement tCommandStatement) {
        if (tCommandStatement != null) {
            if (this.isolationLevel != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Writing transactional parameters to CommandStatement, isolationLevel:" + this.getIsolationLevel());
                }
                tCommandStatement.addCommandParameter(TCommandParameter.ISOLATION_LEVEL, new TCommandParameterValue(this.getIsolationLevel().toString()));
            }
            if (this.lockwaitMode != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Writing transactional parameters to CommandStatement, lockwaitMode:" + this.getLockwaitMode());
                }
                tCommandStatement.addCommandParameter(TCommandParameter.LOCKWAIT_MODE, new TCommandParameterValue(this.getLockwaitMode().toString()));
            }
            if (this.isolationDegree != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Writing transactional parameters to CommandStatement, isolationDegree:" + this.getIsolationDegree());
                }
                tCommandStatement.addCommandParameter(TCommandParameter.ISOLATION_DEGREE, new TCommandParameterValue(this.getIsolationDegree().toString()));
            }
            if (this.lockMode != null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Writing transactional parameters to CommandStatement, lockMode:" + this.getLockMode());
                }
                tCommandStatement.addCommandParameter(TCommandParameter.LOCK_MODE, new TCommandParameterValue(this.getLockMode().toString()));
            }
        }
    }

    protected synchronized void writeTo(TStreamHeader tStreamHeader) {
        if (this.isolationLevel != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing transactional parameters to StreamHeader, isolationLevel:" + this.getIsolationLevel());
            }
            tStreamHeader.put(TCommandParameter.ISOLATION_LEVEL.toString(), this.getIsolationLevel().toString());
        }
        if (this.lockwaitMode != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing transactional parameters to StreamHeader, lockwaitMode:" + this.getLockwaitMode());
            }
            tStreamHeader.put(TCommandParameter.LOCKWAIT_MODE.toString(), this.getLockwaitMode().toString());
        }
        if (this.isolationDegree != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing transactional parameters to StreamHeader, isolationDegree:" + this.getIsolationDegree());
            }
            tStreamHeader.put(TCommandParameter.ISOLATION_DEGREE.toString(), this.getIsolationDegree().toString());
        }
        if (this.lockMode != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Writing transactional parameters to StreamHeader, lockMode:" + this.getLockMode());
            }
            tStreamHeader.put(TCommandParameter.LOCK_MODE.toString(), this.getLockMode().toString());
        }
    }

    public synchronized void setIsolationLevel(TIsolationLevel tIsolationLevel) {
        this.isolationLevel = tIsolationLevel;
    }

    public synchronized TIsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public synchronized void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        this.lockwaitMode = tLockwaitMode;
    }

    public synchronized TLockwaitMode getLockwaitMode() {
        return this.lockwaitMode;
    }

    public synchronized void setIsolationDegree(TIsolationDegree tIsolationDegree) {
        this.isolationDegree = tIsolationDegree;
    }

    public synchronized TIsolationDegree getIsolationDegree() {
        return this.isolationDegree;
    }

    public synchronized void setLockMode(TLockMode tLockMode) {
        this.lockMode = tLockMode;
    }

    public synchronized TLockMode getLockMode() {
        return this.lockMode;
    }

    public synchronized boolean isGiven() {
        return this.lockwaitMode != null && this.isolationLevel != null && this.lockMode != null && this.isolationDegree != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TransactionParameters:");
        stringBuffer.append(" IsolationLevel=" + this.isolationLevel);
        stringBuffer.append(" LockwaitMode=" + this.lockwaitMode);
        stringBuffer.append(" IsolationDegree=" + this.isolationDegree);
        stringBuffer.append(" LockMode=" + this.lockMode);
        return stringBuffer.toString();
    }

    public synchronized void reset() {
        this.isolationLevel = null;
        this.lockwaitMode = null;
        this.isolationDegree = null;
        this.lockMode = null;
    }
}

