/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.ejb.datasource;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.ejb.datasource.TConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class TDriver
implements Driver {
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.11 $");
    static final int majorVersion = 1;
    static final int minorVersion = 0;
    String taminoURL;
    String driverName;
    Connection currentConnection;
    private boolean verbose = true;
    private DriverPropertyInfo[] driverPropertyInfo;

    public Connection connect(String string, Properties properties) throws SQLException {
        String string2;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        this.taminoURL = string;
        if (properties != null) {
            string3 = properties.getProperty("user");
            string4 = properties.getProperty("password");
            string5 = properties.getProperty("opt");
        }
        if ((string2 = string).toLowerCase().startsWith("http://") || string2.toLowerCase().startsWith("jdbc:http://")) {
            String string6;
            int n = string2.lastIndexOf(47);
            this.driverName = string6 = string2.substring(0, n);
            if (string2.toLowerCase().startsWith("jdbc:http://")) {
                this.taminoURL = string.substring(5);
            }
            this.trace("connect to taminoUrl: " + this.taminoURL);
            this.currentConnection = new TConnection(this.taminoURL, this, string3, string4, string5);
            return this.currentConnection;
        }
        return null;
    }

    public boolean acceptsURL(String string) throws SQLException {
        this.trace("acceptsURL called: " + string);
        String string2 = string;
        if (string2.toLowerCase().startsWith("http://") || string2.toLowerCase().startsWith("jdbc:http://")) {
            this.trace("URL starts correctly with [jdbc:]http://");
            return true;
        }
        this.trace(string + " not accepted. It Must start with jdbc:http:// or http://");
        return false;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        this.trace("DriverPropertyInfo called: ");
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[3];
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo("user", "");
        driverPropertyInfo.required = false;
        driverPropertyInfo.description = "Getting a connection to Tamino DB may require user and password";
        driverPropertyInfoArray[0] = driverPropertyInfo;
        DriverPropertyInfo driverPropertyInfo2 = new DriverPropertyInfo("password", "");
        driverPropertyInfo2.required = false;
        driverPropertyInfo2.description = "Getting a connection to Tamino DB may require user and password";
        driverPropertyInfoArray[1] = driverPropertyInfo2;
        return driverPropertyInfoArray;
    }

    public int getMajorVersion() {
        this.trace("getMajorVersion called: return 1");
        return 1;
    }

    public int getMinorVersion() {
        this.trace("getMinorVersion called: return 0");
        return 0;
    }

    public boolean jdbcCompliant() {
        this.trace("jdbcCompliant called: return false");
        return false;
    }

    public String getDriverName() {
        this.trace("getDriverName called: return " + this.driverName);
        return this.driverName;
    }

    private void trace(String string) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning(string);
        }
    }

    private static void strace(String string) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning(string);
        }
    }

    static {
        TDriver.strace("!!! in static initializer !!!");
        try {
            DriverManager.registerDriver(new TDriver());
        }
        catch (SQLException sQLException) {
            System.out.println("Unable to register Tamino datasource driver!");
            sQLException.printStackTrace();
        }
        TDriver.strace("!!! leave static initializer !!!");
    }
}

