/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.ejb.datasource;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAdministrationAccessor;
import com.softwareag.tamino.db.api.accessor.TInvalidatableAccessor;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition2Accessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition3Accessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.ejb.TEJBConnection;
import com.softwareag.tamino.db.api.ejb.TEJBConnectionException;
import com.softwareag.tamino.db.api.ejb.TEJBTransactionException;
import com.softwareag.tamino.db.api.ejb.common.ErrorHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class TEJBConnectionImpl
implements TEJBConnection {
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.18 $");
    private boolean verbose = false;
    private String taminoUrl;
    private boolean autoCommit = false;
    private boolean transactionTerminated = true;
    private boolean opt = false;
    private TConnection tConnection;
    private TLocalTransaction tTransaction;
    private Connection sqlConnection;
    private ArrayList accessorList = null;

    public TEJBConnectionImpl(String string, String string2, String string3, String string4) throws TEJBConnectionException {
        this.taminoUrl = string;
        if (string4 != null && string4.equals("on")) {
            this.opt = true;
        }
        this.trace("taminoUrl =" + string);
        this.trace("user      =" + string2);
        this.trace("opt       =" + string4);
        try {
            TConnectionFactory tConnectionFactory = TConnectionFactory.getInstance();
            this.trace("connection instantiated:" + tConnectionFactory.toString());
            this.tConnection = tConnectionFactory.newConnection(string, string2, string3);
        }
        catch (TServerNotAvailableException tServerNotAvailableException) {
            this.trace("exception when instantiating connection");
            throw new TEJBConnectionException(ErrorHandler.getMessage("XTTEAE0011"), (Exception)tServerNotAvailableException);
        }
        this.trace("connection established");
    }

    public TNonXMLObjectAccessor newNonXMLObjectAccessor(TAccessLocation tAccessLocation) throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("XTTEAE0007"));
        }
        TNonXMLObjectAccessor tNonXMLObjectAccessor = this.tConnection.newNonXMLObjectAccessor(tAccessLocation);
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tNonXMLObjectAccessor);
        return tNonXMLObjectAccessor;
    }

    public TXMLObjectAccessor newXMLObjectAccessor(TAccessLocation tAccessLocation, Object object) throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("XTTEAE0007"));
        }
        TXMLObjectAccessor tXMLObjectAccessor = this.tConnection.newXMLObjectAccessor(tAccessLocation, object);
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tXMLObjectAccessor);
        return tXMLObjectAccessor;
    }

    public TSchemaDefinition2Accessor newSchemaDefinition2Accessor(Object object) throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("XTTEAE0007"));
        }
        TSchemaDefinition2Accessor tSchemaDefinition2Accessor = this.tConnection.newSchemaDefinition2Accessor(object);
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tSchemaDefinition2Accessor);
        return tSchemaDefinition2Accessor;
    }

    public TSchemaDefinition3Accessor newSchemaDefinition3Accessor(Object object) throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("XTTEAE0007"));
        }
        TSchemaDefinition3Accessor tSchemaDefinition3Accessor = this.tConnection.newSchemaDefinition3Accessor(object);
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tSchemaDefinition3Accessor);
        return tSchemaDefinition3Accessor;
    }

    public TStreamAccessor newStreamAccessor(TAccessLocation tAccessLocation) throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("XTTEAE0007"));
        }
        TStreamAccessor tStreamAccessor = this.tConnection.newStreamAccessor(tAccessLocation);
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tStreamAccessor);
        return tStreamAccessor;
    }

    public TSystemAccessor newSystemAccessor() throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("XTTEAE0007"));
        }
        TSystemAccessor tSystemAccessor = this.tConnection.newSystemAccessor();
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tSystemAccessor);
        return tSystemAccessor;
    }

    public TAdministrationAccessor newAdministrationAccessor() throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("XTTEAE0007"));
        }
        TAdministrationAccessor tAdministrationAccessor = this.tConnection.newAdministrationAccessor();
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tAdministrationAccessor);
        return tAdministrationAccessor;
    }

    public TIsolationLevel getIsolationLevel() {
        return this.tConnection.getIsolationLevel();
    }

    public TLockwaitMode getLockwaitMode() {
        return this.tConnection.getLockwaitMode();
    }

    public void close() throws TEJBTransactionException {
        this.trace("close called");
        try {
            if (this.sqlConnection != null) {
                this.sqlConnection.close();
            } else {
                this.trace("sqlConnection is null, anybody has closed before, just continue");
            }
        }
        catch (SQLException sQLException) {
            this.trace("exception when close");
            throw new TEJBTransactionException(ErrorHandler.getMessage("XTTEAE0008"), (Exception)sQLException);
        }
        this.trace("close passed");
        this.sqlConnection = null;
    }

    protected void startSession(Connection connection, TLockwaitMode tLockwaitMode, TIsolationLevel tIsolationLevel) throws TTransactionModeChangeException {
        this.sqlConnection = connection;
        this.trace("in startSession");
        this.trace("init ArrayList for invalidation");
        this.accessorList = new ArrayList();
        if (!this.tConnection.usesLocalTransactionMode()) {
            this.trace("LocalTransaction mode is false, so set to true");
            if (tLockwaitMode != null) {
                this.trace("set lockwaitMode to " + tLockwaitMode.toString());
                this.tConnection.setLockwaitMode(tLockwaitMode);
            }
            if (tIsolationLevel != null) {
                this.trace("set isolationLevel to " + tIsolationLevel.toString());
                this.tConnection.setIsolationLevel(tIsolationLevel);
            }
            this.tTransaction = this.tConnection.useLocalTransactionMode();
            this.trace("got tamino transaction ");
        } else {
            this.trace("a subsequent connection attempted.");
            this.trace("current isolationlevel: " + this.tConnection.getIsolationLevel() + ", new isolationlevel: " + tIsolationLevel);
            this.trace("current lockwaitmode:   " + this.tConnection.getLockwaitMode() + ", new lockwaitmode:   " + tLockwaitMode);
            if (this.transactionTerminated) {
                this.trace("existing connection is clean!");
                boolean bl = true;
                if (tIsolationLevel == null && this.tConnection.getIsolationLevel() != null) {
                    bl = false;
                }
                if (tIsolationLevel != null && !this.tConnection.getIsolationLevel().equals(tIsolationLevel)) {
                    bl = false;
                }
                if (tLockwaitMode == null && this.tConnection.getLockwaitMode() != null) {
                    bl = false;
                }
                if (tLockwaitMode != null && !this.tConnection.getLockwaitMode().equals(tLockwaitMode)) {
                    bl = false;
                }
                if (!bl) {
                    this.trace("existing connection does NOT have identical properties");
                    this.tConnection.useAutoCommitMode();
                    if (tLockwaitMode != null) {
                        this.tConnection.setLockwaitMode(tLockwaitMode);
                    }
                    if (tIsolationLevel != null) {
                        this.tConnection.setIsolationLevel(tIsolationLevel);
                    }
                    this.trace("open session, new connect issued, because isolation level and/or lockwaitmode changed.");
                    this.tTransaction = this.tConnection.useLocalTransactionMode();
                } else {
                    this.trace("open session, keep on using it, isolation level and lockwaitmode not changed.");
                }
            } else {
                this.trace("existing connection is not clean, we only accept identical isolation level/lockwait mode.");
                if (tIsolationLevel == null && this.tConnection.getIsolationLevel() != null) {
                    throw new TTransactionModeChangeException("Default isolation level requested for already acquired connection.");
                }
                if (tIsolationLevel != null && !this.tConnection.getIsolationLevel().equals(tIsolationLevel)) {
                    throw new TTransactionModeChangeException("Different isolation level requested for already acquired connection.");
                }
                if (tLockwaitMode == null && this.tConnection.getLockwaitMode() != null) {
                    throw new TTransactionModeChangeException("Default lock wait mode requested for already acquired connection.");
                }
                if (tLockwaitMode != null && !this.tConnection.getLockwaitMode().equals(tLockwaitMode)) {
                    throw new TTransactionModeChangeException("Different lock wait mode requested for already acquired connection.");
                }
                this.trace("session already running, keep on using it, isolation level and lockwaitmode not changed.");
            }
        }
        this.transactionTerminated = false;
    }

    protected void closeByContainer() throws TTransactionException, TTransactionModeChangeException {
        if (this.tConnection.usesLocalTransactionMode()) {
            this.tTransaction.rollback();
            this.tConnection.useAutoCommitMode();
        }
    }

    protected void commit() throws TTransactionException, TEJBTransactionException, TTransactionModeChangeException {
        this.trace("in taminoEjbApi commit");
        if (!this.transactionTerminated) {
            this.trace("call taminoApi commit");
            this.tTransaction.commit();
            this.trace("call invalidate");
            this.invalidateAccessor();
            if (!this.opt) {
                this.trace("and disconnect");
                this.tConnection.useAutoCommitMode();
            }
        } else {
            throw new TEJBTransactionException(ErrorHandler.getMessage("XTTEAE0007"));
        }
        this.transactionTerminated = true;
    }

    protected void rollback() throws TTransactionException, TEJBTransactionException, TTransactionModeChangeException {
        if (!this.transactionTerminated) {
            this.tTransaction.rollback();
            this.invalidateAccessor();
            if (!this.opt) {
                this.tConnection.useAutoCommitMode();
            }
        } else {
            throw new TEJBTransactionException(ErrorHandler.getMessage("XTTEAE0007"));
        }
        this.transactionTerminated = true;
    }

    private void invalidateAccessor() {
        this.trace("invalidate() the accessor");
        Object object = null;
        int n = 0;
        while (n < this.accessorList.size()) {
            this.trace("index in ArrayList is: " + n);
            Object e = this.accessorList.get(n);
            object = e;
            if (e != null) {
                this.trace("at position " + n + " invalidate() accessor:" + object.toString());
                ((TInvalidatableAccessor)object).invalidate();
            }
            ++n;
        }
        this.trace("invalidate() the accessor done");
    }

    private void rememberAccessor(Object object) {
        this.trace("remember accessor");
        this.accessorList.add((TInvalidatableAccessor)object);
        this.trace("remember accessor done");
    }

    private void trace(String string) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning(string);
        }
    }
}

