/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.ejb.datasource;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.ejb.common.ErrorHandler;
import com.softwareag.tamino.db.api.ejb.datasource.TConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class TPooledConnection
implements PooledConnection {
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.9 $");
    private Vector listeners;
    private String databaseName;
    private String user = null;
    private String password = null;
    private String opt = null;
    private Properties info;
    private TConnection tConnection = null;
    private static final String CLASS_NAME = "TPooledConnection";

    public TPooledConnection(String string, Properties properties) throws SQLException {
        this.trace("TPooledConnection: new instance for " + string);
        this.listeners = new Vector();
        this.databaseName = string;
        if (!string.toLowerCase().startsWith("http://")) {
            throw new SQLException(ErrorHandler.getMessage("XTTEAE0015"));
        }
        if (properties != null) {
            this.info = properties;
            this.user = this.info.getProperty("user");
            this.password = this.info.getProperty("password");
            this.opt = this.info.getProperty("opt");
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.trace("TPooledConnection: addConnectionEventListener called");
        this.listeners.addElement(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.trace("TPooledConnection: removeConnectionEventListener called");
        this.listeners.removeElement(connectionEventListener);
    }

    public void close() throws SQLException {
        this.trace("TPooledConnection: close called");
        if (!this.tConnection.isClosed()) {
            this.tConnection.close();
        }
    }

    public Connection getConnection() throws SQLException {
        this.trace("TPooledConnection: getConnection called to " + this.databaseName);
        try {
            this.tConnection = new TConnection(this.databaseName, this, this.user, this.password, this.opt);
        }
        catch (SQLException sQLException) {
            this.notifyListener(sQLException);
            throw sQLException;
        }
        return this.tConnection;
    }

    protected void notifyListener() {
        this.trace("TPooledConnection: notifyListener called");
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        int n = 0;
        while (n < this.listeners.size()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.get(n);
            connectionEventListener.connectionClosed(connectionEvent);
            ++n;
        }
    }

    private void notifyListener(SQLException sQLException) {
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        int n = 0;
        while (n < this.listeners.size()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.listeners.get(n);
            connectionEventListener.connectionErrorOccurred(connectionEvent);
            ++n;
        }
    }

    private void trace(String string) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.warning(string);
        }
    }
}

