/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.contract.ViolatedPostcondition;
import com.softwareag.common.instrumentation.contract.ViolatedPrecondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TDatabase;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.connection.TTransactionModeUpdateException;
import com.softwareag.tamino.db.api.invocation.TCommunicationException;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.TInvocationMessages;
import com.softwareag.tamino.db.api.invocation.TInvocationRetryHandler;
import com.softwareag.tamino.db.api.invocation.TInvocationRetryHandlerException;
import com.softwareag.tamino.db.api.invocation.TRetryInvocation;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.message.TResourceId;
import java.io.IOException;
import java.util.ArrayList;

public abstract class TAbstractInvocation
implements TInvocation,
TRetryInvocation {
    private TDatabase thisDatabase = null;
    private String thisUserId = "";
    private String thisPassword = "";
    private String thisDomain = "";
    private TTransactionModeCoordinator thisTransactionModeCoordinator = null;
    private boolean thisIsClosed = false;
    private ArrayList retryHandlerList = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$invocation$TAbstractInvocation == null ? (class$com$softwareag$tamino$db$api$invocation$TAbstractInvocation = TAbstractInvocation.class$("com.softwareag.tamino.db.api.invocation.TAbstractInvocation")) : class$com$softwareag$tamino$db$api$invocation$TAbstractInvocation);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$invocation$TAbstractInvocation == null ? (class$com$softwareag$tamino$db$api$invocation$TAbstractInvocation = TAbstractInvocation.class$("com.softwareag.tamino.db.api.invocation.TAbstractInvocation")) : class$com$softwareag$tamino$db$api$invocation$TAbstractInvocation);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.30 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$invocation$TAbstractInvocation;

    public TAbstractInvocation(TDatabase tDatabase, String string, String string2) throws TInvocationException {
        this.thisDatabase = tDatabase;
        this.thisUserId = TString.stringize(string);
        this.thisPassword = TString.stringize(string2);
    }

    public TAbstractInvocation(TDatabase tDatabase, String string, String string2, String string3) throws TInvocationException {
        this.thisDatabase = tDatabase;
        this.thisDomain = TString.stringize(string);
        this.thisUserId = TString.stringize(string2);
        this.thisPassword = TString.stringize(string3);
    }

    public TAbstractInvocation(TDatabase tDatabase) throws TInvocationException {
        this.thisDatabase = tDatabase;
    }

    public TInputStream invoke(TCommandStatement tCommandStatement) throws TInvocationException {
        return this.doTemplateInvoke(tCommandStatement, null, null, null);
    }

    public TInputStream invoke(TCommandStatement tCommandStatement, String string) throws TInvocationException {
        return this.doTemplateInvoke(tCommandStatement, string, null, null);
    }

    public TInputStream invoke(TCommandStatement tCommandStatement, String string, String string2, String string3) throws TInvocationException {
        return this.doTemplateInvoke(tCommandStatement, string, string2, string3);
    }

    public boolean supports(TCommand tCommand) {
        if (tCommand == TCommand.CURSOR) {
            return this.thisTransactionModeCoordinator != null && this.thisTransactionModeCoordinator.supports(tCommand);
        }
        return true;
    }

    public void setTransactionModeCoordinator(TTransactionModeCoordinator tTransactionModeCoordinator) {
        this.thisTransactionModeCoordinator = tTransactionModeCoordinator;
    }

    public void close() throws TInvocationException {
        this.doClose();
        this.thisIsClosed = true;
    }

    public boolean isClosed() {
        return this.thisIsClosed;
    }

    protected String getUserId() {
        return this.thisUserId;
    }

    protected String getPassword() {
        return this.thisPassword;
    }

    protected String getDomain() {
        return this.thisDomain;
    }

    protected void setDatabaseVersion(String string) {
        this.thisDatabase.setVersion(string);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Working on Tamino version " + string);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkServerAvailabilityAndVersion() throws TCommunicationException {
        TInputStream tInputStream;
        block8: {
            tInputStream = null;
            TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DIAGNOSE, TCommandValue.PING);
            tInputStream = this.invoke(tCommandStatement, null, null, null);
            String string = tInputStream.getHeader().getValue("X-INO-Version");
            if (string != null) {
                this.setDatabaseVersion(string);
                break block8;
            }
            if (!logger.isLoggable(Level.SEVERE)) break block8;
            logger.severe("Did not get X-INO-Version header from Tamino.");
        }
        Object var5_6 = null;
        if (tInputStream == null) return;
        try {
            tInputStream.close();
            return;
        }
        catch (IOException iOException) {
            if (!logger.isLoggable(Level.SEVERE)) return;
            logger.severe("Closing version response inputStream failed with IOException: " + iOException);
        }
        return;
        {
            catch (TInvocationException tInvocationException) {
                TResourceId tResourceId = TInvocationMessages.TAJIVE0309;
                tResourceId.setParams(new Object[]{this.getDatabase()});
                throw new TCommunicationException(TInvocationMessages.TAJIVE0309, (Exception)tInvocationException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (tInputStream == null) throw throwable;
            try {
                tInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.SEVERE)) throw throwable;
                logger.severe("Closing version response inputStream failed with IOException: " + iOException);
            }
            throw throwable;
        }
    }

    public TDatabase getDatabase() {
        return this.thisDatabase;
    }

    public abstract TInputStream doInvoke(TCommandStatement var1, String var2, String var3, String var4, boolean var5) throws TInvocationException;

    protected abstract void doClose() throws TInvocationException;

    public TTransactionModeCoordinator getTransactionModeCoordinator() {
        return this.thisTransactionModeCoordinator;
    }

    private synchronized TInputStream doTemplateInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3) throws TInvocationException {
        Precondition.check(tCommandStatement != null, "There is no command statement!");
        Precondition.check(this.thisTransactionModeCoordinator != null, "There is no transaction mode coordinator!");
        boolean bl = this.thisTransactionModeCoordinator.needsSessionState(tCommandStatement.getCommand());
        this.prepare(tCommandStatement, string, string2, string3, bl);
        this.thisTransactionModeCoordinator.writeModeTo(tCommandStatement);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("TransactionState BEFORE: " + this.thisTransactionModeCoordinator.toString());
        }
        TInputStream tInputStream = null;
        try {
            tInputStream = this.doInvoke(tCommandStatement, string, string2, string3, bl);
        }
        catch (TInvocationException tInvocationException) {
            tInputStream = this.retryAfterInvoke(tCommandStatement, tInputStream, tInvocationException);
        }
        this.wrapUpAfterInvoke(tCommandStatement);
        try {
            if (bl && tInputStream != null) {
                this.thisTransactionModeCoordinator.updateModeFrom(tInputStream);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("TransactionState AFTER: " + this.thisTransactionModeCoordinator.toString());
                }
            }
        }
        catch (TTransactionModeUpdateException tTransactionModeUpdateException) {
            tInputStream = this.retryAfterSessionModeUpdate(tCommandStatement, tInputStream, tTransactionModeUpdateException);
        }
        if (tInputStream.hasFailureException()) {
            throw new TInvocationException(TInvocationMessages.TAJIVE0301, tInputStream.getFailureException());
        }
        this.wrapUpAfterSessionModeUpdate(tCommandStatement);
        return tInputStream;
    }

    private void prepare(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) {
        if (this.retryHandlerList != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("RetryHandlers: prepare!");
            }
            int n = 0;
            while (n < this.retryHandlerList.size()) {
                ((TInvocationRetryHandler)this.retryHandlerList.get(n)).prepare(this, tCommandStatement, string, string2, string3, bl);
                ++n;
            }
        }
    }

    private TInputStream retryAfterInvoke(TCommandStatement tCommandStatement, TInputStream tInputStream, TInvocationException tInvocationException) throws TInvocationRetryHandlerException {
        if (this.retryHandlerList != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("RetryHandlers: retryAfterInvoke!");
            }
            TInputStream tInputStream2 = null;
            int n = 0;
            while (n < this.retryHandlerList.size()) {
                try {
                    tInputStream2 = ((TInvocationRetryHandler)this.retryHandlerList.get(n)).retryAfterInvoke(this, tCommandStatement, tInputStream, tInvocationException);
                }
                catch (ViolatedPrecondition violatedPrecondition) {
                    throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0317, (Exception)tInvocationException);
                }
                catch (ViolatedPostcondition violatedPostcondition) {
                    throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0317, (Exception)tInvocationException);
                }
                if (tInputStream2 != null) {
                    return tInputStream2;
                }
                ++n;
            }
            throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0310, (Exception)tInvocationException);
        }
        throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0314, (Exception)tInvocationException);
    }

    private void wrapUpAfterInvoke(TCommandStatement tCommandStatement) {
        if (this.retryHandlerList != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("RetryHandlers: wrapUpAfterInvoke!");
            }
            int n = 0;
            while (n < this.retryHandlerList.size()) {
                ((TInvocationRetryHandler)this.retryHandlerList.get(n)).wrapUpAfterInvoke(this, tCommandStatement);
                ++n;
            }
        }
    }

    private TInputStream retryAfterSessionModeUpdate(TCommandStatement tCommandStatement, TInputStream tInputStream, TTransactionModeUpdateException tTransactionModeUpdateException) throws TInvocationRetryHandlerException {
        if (this.retryHandlerList != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("RetryHandlers: retryAfterSessionModeUpdate!");
            }
            TInputStream tInputStream2 = null;
            int n = 0;
            while (n < this.retryHandlerList.size()) {
                try {
                    tInputStream2 = ((TInvocationRetryHandler)this.retryHandlerList.get(n)).retryAfterSessionModeUpdate(this, tCommandStatement, tInputStream, tTransactionModeUpdateException);
                }
                catch (ViolatedPrecondition violatedPrecondition) {
                    throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0318, (Exception)tTransactionModeUpdateException);
                }
                catch (ViolatedPostcondition violatedPostcondition) {
                    throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0318, (Exception)tTransactionModeUpdateException);
                }
                if (tInputStream2 != null) {
                    return tInputStream2;
                }
                ++n;
            }
            throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0311, (Exception)tTransactionModeUpdateException);
        }
        throw new TInvocationRetryHandlerException(TInvocationMessages.TAJIVE0314, (Exception)tTransactionModeUpdateException);
    }

    private void wrapUpAfterSessionModeUpdate(TCommandStatement tCommandStatement) {
        if (this.retryHandlerList != null) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("RetryHandlers: wrapUpAfterSessionModeUpdate!");
            }
            int n = 0;
            while (n < this.retryHandlerList.size()) {
                ((TInvocationRetryHandler)this.retryHandlerList.get(n)).wrapUpAfterSessionModeUpdate(this, tCommandStatement);
                ++n;
            }
        }
    }

    public synchronized void addRetryHandler(TInvocationRetryHandler tInvocationRetryHandler) {
        if (this.retryHandlerList == null) {
            this.retryHandlerList = new ArrayList();
        }
        this.retryHandlerList.add(tInvocationRetryHandler);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

