/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation;

import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.invocation.TEncodingStrategy;

public class TBase64EncodingStrategy
implements TEncodingStrategy {
    private static final byte[] BASE64_ENCODING_MAP;
    private static final byte[] BASE64_DECODING_MAP;
    private static TBase64EncodingStrategy singleton;

    protected TBase64EncodingStrategy() {
    }

    public static synchronized TBase64EncodingStrategy getInstance() {
        if (singleton == null) {
            singleton = new TBase64EncodingStrategy();
        }
        return singleton;
    }

    public String encode(String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = string.getBytes(TPreference.getInstance().getEncoding());
            return new String(this.encode(byArray), TPreference.getInstance().getEncoding());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[(byArray.length + 2) / 3 * 4];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length - 2) {
            byArray2[n2++] = BASE64_ENCODING_MAP[byArray[n] >>> 2 & 0x3F];
            byArray2[n2++] = BASE64_ENCODING_MAP[byArray[n + 1] >>> 4 & 0xF | byArray[n] << 4 & 0x3F];
            byArray2[n2++] = BASE64_ENCODING_MAP[byArray[n + 2] >>> 6 & 3 | byArray[n + 1] << 2 & 0x3F];
            byArray2[n2++] = BASE64_ENCODING_MAP[byArray[n + 2] & 0x3F];
            n += 3;
        }
        if (n < byArray.length) {
            byArray2[n2++] = BASE64_ENCODING_MAP[byArray[n] >>> 2 & 0x3F];
            if (n < byArray.length - 1) {
                byArray2[n2++] = BASE64_ENCODING_MAP[byArray[n + 1] >>> 4 & 0xF | byArray[n] << 4 & 0x3F];
                byArray2[n2++] = BASE64_ENCODING_MAP[byArray[n + 1] << 2 & 0x3F];
            } else {
                byArray2[n2++] = BASE64_ENCODING_MAP[byArray[n] << 4 & 0x3F];
            }
        }
        while (n2 < byArray2.length) {
            byArray2[n2] = 61;
            ++n2;
        }
        return byArray2;
    }

    public String decode(String string) {
        if (string == null) {
            return null;
        }
        try {
            byte[] byArray = string.getBytes(TPreference.getInstance().getEncoding());
            return new String(this.decode(byArray), TPreference.getInstance().getEncoding());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] decode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        while (byArray[n - 1] == 61) {
            --n;
        }
        byte[] byArray2 = new byte[n - byArray.length / 4];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = BASE64_DECODING_MAP[byArray[n2]];
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray2.length - 2) {
            byArray2[n4] = (byte)(byArray[n3] << 2 & 0xFF | byArray[n3 + 1] >>> 4 & 3);
            byArray2[n4 + 1] = (byte)(byArray[n3 + 1] << 4 & 0xFF | byArray[n3 + 2] >>> 2 & 0xF);
            byArray2[n4 + 2] = (byte)(byArray[n3 + 2] << 6 & 0xFF | byArray[n3 + 3] & 0x3F);
            n3 += 4;
            n4 += 3;
        }
        if (n4 < byArray2.length) {
            byArray2[n4] = (byte)(byArray[n3] << 2 & 0xFF | byArray[n3 + 1] >>> 4 & 3);
        }
        if (++n4 < byArray2.length) {
            byArray2[n4] = (byte)(byArray[n3 + 1] << 4 & 0xFF | byArray[n3 + 2] >>> 2 & 0xF);
        }
        return byArray2;
    }

    static {
        byte[] byArray = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        BASE64_ENCODING_MAP = byArray;
        BASE64_DECODING_MAP = new byte[128];
        int n = 0;
        while (n < BASE64_ENCODING_MAP.length) {
            TBase64EncodingStrategy.BASE64_DECODING_MAP[TBase64EncodingStrategy.BASE64_ENCODING_MAP[n]] = (byte)n;
            ++n;
        }
        singleton = null;
    }
}

