/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation;

import com.softwareag.tamino.db.api.common.TDatabase;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.TInvocationMessages;
import com.softwareag.tamino.db.api.invocation.TInvocationRetryOnConnectionTimeoutHandler;
import com.softwareag.tamino.db.api.invocation.TInvocationRetryOnNoConnectionHandler;
import com.softwareag.tamino.db.api.message.TResourceId;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class TInvocationFactory {
    private static TInvocationFactory singleton = null;
    private TInvocationHandlerRegistry invocationHandlerRegistry = new TInvocationHandlerRegistry();
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$common$TDatabase;
    static /* synthetic */ Class class$java$lang$String;

    protected TInvocationFactory() {
    }

    public TInvocation newInvocation(TDatabase tDatabase) throws TInvocationException {
        Class clazz = this.getInvocationClass(tDatabase, TPreference.getInstance().getInvocationModifier());
        TAbstractInvocation tAbstractInvocation = this.newInvocation(clazz, new Class[]{class$com$softwareag$tamino$db$api$common$TDatabase == null ? (class$com$softwareag$tamino$db$api$common$TDatabase = TInvocationFactory.class$("com.softwareag.tamino.db.api.common.TDatabase")) : class$com$softwareag$tamino$db$api$common$TDatabase}, new Object[]{tDatabase});
        this.initialize(tAbstractInvocation);
        return tAbstractInvocation;
    }

    public TInvocation newInvocation(TDatabase tDatabase, String string, String string2) throws TInvocationException {
        Class clazz = this.getInvocationClass(tDatabase, TPreference.getInstance().getInvocationModifier());
        TAbstractInvocation tAbstractInvocation = this.newInvocation(clazz, new Class[]{class$com$softwareag$tamino$db$api$common$TDatabase == null ? (class$com$softwareag$tamino$db$api$common$TDatabase = TInvocationFactory.class$("com.softwareag.tamino.db.api.common.TDatabase")) : class$com$softwareag$tamino$db$api$common$TDatabase, class$java$lang$String == null ? (class$java$lang$String = TInvocationFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TInvocationFactory.class$("java.lang.String")) : class$java$lang$String}, new Object[]{tDatabase, string, string2});
        this.initialize(tAbstractInvocation);
        return tAbstractInvocation;
    }

    public TInvocation newInvocation(TDatabase tDatabase, String string, String string2, String string3) throws TInvocationException {
        Class clazz = this.getInvocationClass(tDatabase, TPreference.getInstance().getInvocationModifier());
        TAbstractInvocation tAbstractInvocation = this.newInvocation(clazz, new Class[]{class$com$softwareag$tamino$db$api$common$TDatabase == null ? (class$com$softwareag$tamino$db$api$common$TDatabase = TInvocationFactory.class$("com.softwareag.tamino.db.api.common.TDatabase")) : class$com$softwareag$tamino$db$api$common$TDatabase, class$java$lang$String == null ? (class$java$lang$String = TInvocationFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TInvocationFactory.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = TInvocationFactory.class$("java.lang.String")) : class$java$lang$String}, new Object[]{tDatabase, string, string2, string3});
        this.initialize(tAbstractInvocation);
        return tAbstractInvocation;
    }

    public static synchronized TInvocationFactory getInstance() {
        if (singleton == null) {
            singleton = new TInvocationFactory();
        }
        return singleton;
    }

    private TAbstractInvocation newInvocation(Class clazz, Class[] classArray, Object[] objectArray) throws TInvocationException {
        try {
            Constructor constructor = clazz.getConstructor(classArray);
            return (TAbstractInvocation)constructor.newInstance(objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new TInvocationException(TInvocationMessages.TAJIVE0303, (Exception)noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof TInvocationException) {
                throw (TInvocationException)throwable;
            }
            throw new TInvocationException(TInvocationMessages.TAJIVE0304, (Exception)invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TInvocationException(TInvocationMessages.TAJIVE0305, (Exception)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new TInvocationException(TInvocationMessages.TAJIVE0306, (Exception)instantiationException);
        }
    }

    private Class getInvocationClass(TDatabase tDatabase, String string) throws TInvocationException {
        Class clazz = this.invocationHandlerRegistry.get(tDatabase.getProtocol(), string);
        if (clazz == null) {
            TResourceId tResourceId = TInvocationMessages.TAJIVE0307;
            tResourceId.setParams(new Object[]{tDatabase.getProtocol()});
            throw new TInvocationException(TInvocationMessages.TAJIVE0307);
        }
        return clazz;
    }

    private void initialize(TAbstractInvocation tAbstractInvocation) throws TInvocationException {
        this.addRetryHandlers(tAbstractInvocation);
    }

    private void addRetryHandlers(TAbstractInvocation tAbstractInvocation) {
        if (TPreference.getInstance().useRetryHandler()) {
            tAbstractInvocation.addRetryHandler(new TInvocationRetryOnConnectionTimeoutHandler());
            tAbstractInvocation.addRetryHandler(new TInvocationRetryOnNoConnectionHandler());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TInvocationSpecifier {
        private String protocol;
        private String modifier;

        public TInvocationSpecifier(String string, String string2) {
            this.protocol = string == null ? "" : string;
            this.modifier = string2 == null ? "" : string2;
        }

        public int hashCode() {
            return this.protocol.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof TInvocationSpecifier) {
                TInvocationSpecifier tInvocationSpecifier = (TInvocationSpecifier)object;
                return this.protocol.equals(tInvocationSpecifier.protocol) && this.modifier.equals(tInvocationSpecifier.modifier);
            }
            return false;
        }
    }

    private static class TInvocationHandlerRegistry {
        private HashMap invocationHandlerMap = new HashMap();

        public TInvocationHandlerRegistry() {
            this.add("http", "", "com.softwareag.tamino.db.api.invocation.http.THTTPInvocation");
            this.add("https", "", "com.softwareag.tamino.db.api.invocation.http.THTTPInvocation");
            this.add("wsl", "", "com.softwareag.tamino.db.api.invocation.wsl.TWSLInvocation");
            this.add("mock", "", "com.softwareag.tamino.db.api.invocation.mock.TMockInvocation");
        }

        public void add(String string, String string2, String string3) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string3);
            }
            catch (Exception exception) {
                clazz = null;
            }
            this.invocationHandlerMap.put(new TInvocationSpecifier(string, string2), clazz);
        }

        public Class get(String string, String string2) {
            return (Class)this.invocationHandlerMap.get(new TInvocationSpecifier(string, string2));
        }
    }
}

