/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.connection.TTransactionModeUpdateException;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocationRetryHandler;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.TInvocationMessages;
import com.softwareag.tamino.db.api.invocation.TRetryInvocation;
import com.softwareag.tamino.db.api.io.TInputStream;

public class TInvocationRetryOnConnectionTimeoutHandler
extends TAbstractInvocationRetryHandler {
    private String thisCollection = null;
    private String thisDoctype = null;
    private String thisDocname = null;
    private boolean thisUseTransactionMode = false;
    private TCommandStatement thisCommandStatement = null;
    private TCommandStatement connectCommandStatement = null;
    boolean connectClean = false;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.8 $");

    public void prepare(TRetryInvocation tRetryInvocation, TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("prepare called for session timeout retry handler");
        }
        this.thisCommandStatement = tCommandStatement != null ? (TCommandStatement)tCommandStatement.clone() : null;
        this.thisCollection = string;
        this.thisDoctype = string2;
        this.thisDocname = string3;
        this.thisUseTransactionMode = bl;
    }

    public TInputStream retryAfterSessionModeUpdate(TRetryInvocation tRetryInvocation, TCommandStatement tCommandStatement, TInputStream tInputStream, TTransactionModeUpdateException tTransactionModeUpdateException) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Retry after session timeout!");
        }
        TInputStream tInputStream2 = null;
        if (this.connectClean) {
            try {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("We recognized a re-connect situation");
                }
                if (this.connectCommandStatement == null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("no previous connect command available to attempt re-connect");
                    }
                    throw new TInvocationException(TInvocationMessages.TAJIVE0315, (Exception)tTransactionModeUpdateException);
                }
                if (this.thisCommandStatement.getCommand().equals(TCommand.DISCONNECT)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("current command is a disconnect, no need to re-connect");
                    }
                    throw new TInvocationException(TInvocationMessages.TAJIVE0316, (Exception)tTransactionModeUpdateException);
                }
                tRetryInvocation.getTransactionModeCoordinator().resetSessionState();
                tInputStream2 = tRetryInvocation.doInvoke(this.connectCommandStatement, this.thisCollection, this.thisDoctype, this.thisDocname, this.thisUseTransactionMode);
                try {
                    tRetryInvocation.getTransactionModeCoordinator().updateModeFrom(tInputStream2);
                }
                catch (TException tException) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("shouldn't happen: Exception after re-connect");
                    }
                    throw new TInvocationException(TInvocationMessages.TAJIVE0312, (Exception)tException);
                }
                tCommandStatement = this.thisCommandStatement;
                tRetryInvocation.getTransactionModeCoordinator().writeModeTo(tCommandStatement);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("We are about to re-invoke the original command");
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("  the command is: " + tCommandStatement.toString());
                }
                tInputStream2 = tRetryInvocation.doInvoke(tCommandStatement, this.thisCollection, this.thisDoctype, this.thisDocname, this.thisUseTransactionMode);
                try {
                    tRetryInvocation.getTransactionModeCoordinator().updateModeFrom(tInputStream2);
                }
                catch (TException tException) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("shouldn't happen: Exception after re-invocation");
                    }
                    throw new TInvocationException(TInvocationMessages.TAJIVE0313, (Exception)tException);
                }
            }
            catch (TInvocationException tInvocationException) {
                return null;
            }
        }
        return tInputStream2;
    }

    public void wrapUpAfterSessionModeUpdate(TRetryInvocation tRetryInvocation, TCommandStatement tCommandStatement) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("wrap-up called for session timeout retry handler");
        }
        this.connectClean = false;
        if (tCommandStatement != null) {
            TCommand tCommand = tCommandStatement.getCommand();
            if (tCommand == TCommand.CONNECT) {
                this.connectCommandStatement = this.thisCommandStatement;
            }
            if (tCommand == TCommand.COMMIT || tCommand == TCommand.ROLLBACK || tCommand == TCommand.CONNECT) {
                this.connectClean = true;
            }
        }
    }
}

