/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.http;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.invocation.TBase64EncodingStrategy;
import com.softwareag.tamino.db.api.invocation.TEncodingStrategy;
import com.softwareag.tamino.db.api.invocation.http.THTTPAuthorizationResult;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;

public class THTTPAuthorization {
    public static final String BASIC_SCHEME = "Basic";
    public static final String DIGEST_SCHEME = "Digest";
    private HashMap encodingStrategyMap = new HashMap();
    private TEncodingStrategy defaultEncodingStrategy;
    private static THTTPAuthorization singleton = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$invocation$http$THTTPAuthorization == null ? (class$com$softwareag$tamino$db$api$invocation$http$THTTPAuthorization = THTTPAuthorization.class$("com.softwareag.tamino.db.api.invocation.http.THTTPAuthorization")) : class$com$softwareag$tamino$db$api$invocation$http$THTTPAuthorization);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$invocation$http$THTTPAuthorization == null ? (class$com$softwareag$tamino$db$api$invocation$http$THTTPAuthorization = THTTPAuthorization.class$("com.softwareag.tamino.db.api.invocation.http.THTTPAuthorization")) : class$com$softwareag$tamino$db$api$invocation$http$THTTPAuthorization);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.12 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$invocation$http$THTTPAuthorization;

    public THTTPAuthorization() {
        this.encodingStrategyMap.put(BASIC_SCHEME, TBase64EncodingStrategy.getInstance());
        this.defaultEncodingStrategy = (TEncodingStrategy)this.encodingStrategyMap.get(BASIC_SCHEME);
    }

    public static synchronized THTTPAuthorization getInstance() {
        if (singleton == null) {
            singleton = new THTTPAuthorization();
        }
        return singleton;
    }

    public THTTPAuthorizationResult authorize(URLConnection uRLConnection, String string, String string2) {
        return this.authorize(BASIC_SCHEME, uRLConnection, "", string, string2);
    }

    public THTTPAuthorizationResult authorize(URLConnection uRLConnection, String string, String string2, String string3) {
        return this.authorize(BASIC_SCHEME, uRLConnection, string, string2, string3);
    }

    public THTTPAuthorizationResult authorize(String string, URLConnection uRLConnection, String string2, String string3) {
        return this.authorize(string, uRLConnection, "", string2, string3);
    }

    private boolean requiresAuthorization(String string, String string2, String string3) {
        return string2.length() > 0 || string3.length() > 0 || string.length() > 0;
    }

    public THTTPAuthorizationResult authorize(String string, URLConnection uRLConnection, String string2, String string3, String string4) {
        Precondition.check(this.supportsScheme(string), "Authorization with requested scheme " + string + " not supported!");
        TEncodingStrategy tEncodingStrategy = (TEncodingStrategy)this.encodingStrategyMap.get(string);
        if (this.requiresAuthorization(string2, string3, string4)) {
            String string5 = string2 != "" ? string + " " + tEncodingStrategy.encode(string2 + TPreference.getInstance().getUserIdDomainSeparator() + string3 + ":" + string4) : string + " " + tEncodingStrategy.encode(string3 + ":" + string4);
            uRLConnection.setRequestProperty("Authorization", string5);
            uRLConnection.setRequestProperty("User", string3);
            uRLConnection.setRequestProperty("X-INO-Authentication", string3);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Authorization performed");
            }
        }
        return new THTTPAuthorizationResult(uRLConnection, string2, string3, string4, string);
    }

    public boolean supportsScheme(String string) {
        Iterator iterator = this.encodingStrategyMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            return true;
        }
        return this.encodingStrategyMap.get(string.toUpperCase()) != null;
    }

    public void registerEncodingStrategy(String string, TEncodingStrategy tEncodingStrategy) {
        this.encodingStrategyMap.put(string, tEncodingStrategy);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

