/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.http;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TAccessFailureException;
import com.softwareag.tamino.db.api.common.TDatabase;
import com.softwareag.tamino.db.api.common.TIdentity;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocation;
import com.softwareag.tamino.db.api.invocation.TAuthorizationException;
import com.softwareag.tamino.db.api.invocation.TCommunicationException;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.http.THTTPAuthorization;
import com.softwareag.tamino.db.api.invocation.http.THTTPAuthorizationResult;
import com.softwareag.tamino.db.api.invocation.http.THTTPCommunicationException;
import com.softwareag.tamino.db.api.invocation.http.THTTPInvocationMessages;
import com.softwareag.tamino.db.api.invocation.http.THTTPInvocationRequestWriter;
import com.softwareag.tamino.db.api.invocation.http.TURLPathEncoder;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TInputStreamCloseListener;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.message.TResourceId;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class THTTPInvocation
extends TAbstractInvocation {
    private static final int HTTP_MASTER_CODE_INFORMATIONAL = 1;
    private static final int HTTP_MASTER_CODE_SUCCESSFUL = 2;
    private static final int HTTP_MASTER_CODE_REDIRECTION = 3;
    private static final int HTTP_MASTER_CODE_CLIENT_ERROR = 4;
    private static final int HTTP_MASTER_CODE_SERVER_ERROR = 5;
    private static final String INVOCATION_TYPE = "HTTP ge 1.3.1_04";
    private static final String USER_AGENT_KEY = "User-Agent";
    private THTTPInvocationRequestWriter invocationRequestWriter = new THTTPInvocationRequestWriter();
    private THTTPAuthorization authorization = new THTTPAuthorization();
    private TURLPathEncoder urlPathEncoder = TURLPathEncoder.getInstance();
    private String userAgentValue = null;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.48 $");
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$invocation$http$THTTPInvocation == null ? (class$com$softwareag$tamino$db$api$invocation$http$THTTPInvocation = THTTPInvocation.class$("com.softwareag.tamino.db.api.invocation.http.THTTPInvocation")) : class$com$softwareag$tamino$db$api$invocation$http$THTTPInvocation);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$invocation$http$THTTPInvocation == null ? (class$com$softwareag$tamino$db$api$invocation$http$THTTPInvocation = THTTPInvocation.class$("com.softwareag.tamino.db.api.invocation.http.THTTPInvocation")) : class$com$softwareag$tamino$db$api$invocation$http$THTTPInvocation);
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$invocation$http$THTTPInvocation;

    public THTTPInvocation(TDatabase tDatabase, String string, String string2, String string3) throws TInvocationException {
        super(tDatabase, string, string2, string3);
    }

    public THTTPInvocation(TDatabase tDatabase, String string, String string2) throws TInvocationException {
        this(tDatabase, "", string, string2);
    }

    public THTTPInvocation(TDatabase tDatabase) throws TInvocationException {
        this(tDatabase, "", "", "");
    }

    public TInputStream doInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        Precondition.check(!this.isClosed(), "Connection with Tamino is closed. Commands cannot be invoked on Tamino anymore!");
        if (this.workaroundIsRequiredFor(tCommandStatement.getCommand())) {
            return this.doGetInvoke(tCommandStatement, string, string2, string3, bl);
        }
        Precondition.check(tCommandStatement != null && !tCommandStatement.toString().equals(""), "No TCommandStatement instance given!");
        try {
            Object object;
            String string4 = this.getURL(this.getDatabase(), string, string2, string3);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("POST for url: " + string4);
                logger.info("On collection: " + string + " doctype: " + string2 + " docname: " + string3);
                logger.info("Command Statement: " + tCommandStatement.toString());
            }
            TInputStream tInputStream = null;
            String string5 = "Basic";
            while (string5.length() > 0) {
                object = this.getHttpURLConnection(string4);
                this.setUserAgentProperty((HttpURLConnection)object);
                THTTPAuthorizationResult tHTTPAuthorizationResult = this.authorize(string5, (URLConnection)object, this.getDomain(), this.getUserId(), this.getPassword());
                this.invocationRequestWriter.setConnection((HttpURLConnection)object);
                this.invocationRequestWriter.write(tCommandStatement);
                tInputStream = this.getInputStream((HttpURLConnection)object);
                string5 = this.verifyAuthorizationResult(tHTTPAuthorizationResult);
            }
            object = tInputStream.getHeader();
            ((TStreamHeader)object).put("X-API-Collection", string);
            ((TStreamHeader)object).put("X-API-Doctype", string2);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Stream Header: " + object);
            }
            return tInputStream;
        }
        catch (TInvocationException tInvocationException) {
            throw tInvocationException;
        }
        catch (Exception exception) {
            throw new TCommunicationException(exception);
        }
    }

    protected void doClose() {
    }

    private TInputStream doGetInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Perform a workaround invocation with HTTP GET.");
        }
        try {
            Object object;
            String string4 = this.getURL(this.getDatabase(), string, string2, string3);
            if (tCommandStatement != null) {
                string4 = string4 + "?" + tCommandStatement.toString();
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("GET for url: " + string4);
                logger.info("On collection: " + string + " doctype: " + string2 + " docname: " + string3);
                logger.info("Command Statement: " + tCommandStatement.toString());
            }
            TInputStream tInputStream = null;
            String string5 = "Basic";
            while (string5.length() > 0) {
                object = this.getHttpURLConnection(string4);
                THTTPAuthorizationResult tHTTPAuthorizationResult = this.authorize(string5, (URLConnection)object, this.getDomain(), this.getUserId(), this.getPassword());
                ((HttpURLConnection)object).setRequestMethod("GET");
                this.setUserAgentProperty((HttpURLConnection)object);
                ((URLConnection)object).setRequestProperty("Accept-Charset", TPreference.getInstance().getEncoding());
                tInputStream = this.getInputStream((HttpURLConnection)object);
                string5 = this.verifyAuthorizationResult(tHTTPAuthorizationResult);
            }
            object = tInputStream.getHeader();
            ((TStreamHeader)object).put("X-API-Collection", string);
            ((TStreamHeader)object).put("X-API-Doctype", string2);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Stream Header: " + object);
            }
            return tInputStream;
        }
        catch (TInvocationException tInvocationException) {
            throw tInvocationException;
        }
        catch (IOException iOException) {
            throw new TCommunicationException(iOException);
        }
    }

    private TInputStream getInputStream(final HttpURLConnection httpURLConnection) throws TInvocationException {
        int n = -1;
        String string = null;
        try {
            TInputStream tInputStream = null;
            TInputStreamCloseListener tInputStreamCloseListener = null;
            n = httpURLConnection.getResponseCode();
            string = httpURLConnection.getResponseMessage();
            if (TPreference.getInstance().getAutoDisconnectHttpUrlConnection()) {
                tInputStreamCloseListener = new TInputStreamCloseListener(){

                    public void closed(TInputStream tInputStream) {
                        httpURLConnection.disconnect();
                        if (logger.isLoggable(Level.INFO)) {
                            logger.info("HttpURLConnection has been disconnected!");
                        }
                    }
                };
            }
            switch (this.getMasterCode(n)) {
                case 1: {
                    throw new THTTPCommunicationException(n, string);
                }
                case 2: {
                    tInputStream = new TInputStream(this.getTracedInputStream(httpURLConnection.getInputStream()), this.getStreamHeader(httpURLConnection));
                    if (tInputStreamCloseListener != null) {
                        tInputStream.addCloseListener(tInputStreamCloseListener);
                    }
                    return tInputStream;
                }
                case 3: {
                    throw new THTTPCommunicationException(n, string);
                }
                case 4: {
                    if (n == 401) {
                        tInputStream = new TInputStream(this.getTracedInputStream(httpURLConnection.getErrorStream()), this.getStreamHeader(httpURLConnection));
                        if (tInputStreamCloseListener != null) {
                            tInputStream.addCloseListener(tInputStreamCloseListener);
                        }
                        return tInputStream;
                    }
                    if (n == 404) {
                        return new TInputStream(new THTTPCommunicationException(n, string), this.getStreamHeader(httpURLConnection));
                    }
                    throw new THTTPCommunicationException(n, string);
                }
                case 5: {
                    if (n == 503) {
                        throw new THTTPCommunicationException(n, string).setRetryPossible();
                    }
                    if (n == 502) {
                        TAccessFailureException tAccessFailureException = new TAccessFailureException(this.getTracedInputStream(httpURLConnection.getErrorStream()));
                        throw new THTTPCommunicationException(n, string, tAccessFailureException);
                    }
                    throw new THTTPCommunicationException(n, string);
                }
            }
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Http protocol failure. Unknown HTTP ResponseCode=" + n + " ResponseMessage=" + string + " !");
            }
            throw new THTTPCommunicationException(n, string);
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("IOException while retrieving HttpConnection.getInputStream()");
            }
            throw new THTTPCommunicationException(n, string, iOException);
        }
    }

    private InputStream getTracedInputStream(InputStream inputStream) throws IOException {
        if (!logger.isLoggable(Level.INFO)) {
            return inputStream;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, TPreference.getInstance().getDefaultBufferSize());
        bufferedInputStream.mark(TPreference.getInstance().getDefaultBufferSize());
        byte[] byArray = new byte[TPreference.getInstance().getDefaultBufferSize()];
        int n = bufferedInputStream.read(byArray);
        logger.info("Stream Contents: " + new String(byArray));
        bufferedInputStream.reset();
        return bufferedInputStream;
    }

    private TStreamHeader getStreamHeader(URLConnection uRLConnection) {
        String string;
        TStreamHeader tStreamHeader = new TStreamHeader();
        int n = 1;
        while (uRLConnection.getHeaderFieldKey(n) != null) {
            string = uRLConnection.getHeaderFieldKey(n);
            String string2 = uRLConnection.getHeaderField(n);
            tStreamHeader.put(string, string2);
            ++n;
        }
        string = uRLConnection.getHeaderField("Last-Modified");
        if (string != null && string.length() > 0) {
            tStreamHeader.put("X-API-LastModified", string);
        }
        return tStreamHeader;
    }

    private String getURL(TDatabase tDatabase, String string, String string2, String string3) {
        String string4 = null;
        string4 = string == null || string.equals("") ? tDatabase.getDatabaseURI() + "/" : (string2 == null || string2.equals("") ? tDatabase.getDatabaseURI() + "/" + string + "/" : (string3 == null || string3.equals("") ? tDatabase.getDatabaseURI() + "/" + string + "/" + string2 + "/" : tDatabase.getDatabaseURI() + "/" + string + "/" + string2 + "/" + string3));
        return this.urlPathEncoder.encode(string4);
    }

    private HttpURLConnection getHttpURLConnection(String string) throws TCommunicationException {
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            return httpURLConnection;
        }
        catch (MalformedURLException malformedURLException) {
            TResourceId tResourceId = THTTPInvocationMessages.TAJHTE0402;
            tResourceId.setParams(new Object[]{string});
            throw new TCommunicationException(THTTPInvocationMessages.TAJHTE0402, (Exception)malformedURLException);
        }
        catch (IOException iOException) {
            TResourceId tResourceId = THTTPInvocationMessages.TAJHTE0403;
            tResourceId.setParams(new Object[]{new String("(" + iOException.getMessage() + ")")});
            throw new TCommunicationException(THTTPInvocationMessages.TAJHTE0403, (Exception)iOException);
        }
    }

    private boolean workaroundIsRequiredFor(TCommand tCommand) {
        return tCommand == TCommand.DIAGNOSE || tCommand == TCommand.RETRIEVE;
    }

    private THTTPAuthorizationResult authorize(String string, URLConnection uRLConnection, String string2, String string3, String string4) {
        return this.authorization.authorize(string, uRLConnection, this.getDomain(), this.getUserId(), this.getPassword());
    }

    private String verifyAuthorizationResult(THTTPAuthorizationResult tHTTPAuthorizationResult) throws TAuthorizationException {
        String string = "";
        if (tHTTPAuthorizationResult != null && !tHTTPAuthorizationResult.isSuccessfull()) {
            if (!this.authorization.supportsScheme(tHTTPAuthorizationResult.getAuthenticationScheme())) {
                throw new TAuthorizationException(THTTPInvocationMessages.TAJHTE0404);
            }
            if (tHTTPAuthorizationResult.getScheme().equals(tHTTPAuthorizationResult.getAuthenticationScheme())) {
                throw new TAuthorizationException(THTTPInvocationMessages.TAJHTE0405);
            }
            string = tHTTPAuthorizationResult.getAuthenticationScheme();
        }
        return string;
    }

    private void setUserAgentProperty(HttpURLConnection httpURLConnection) {
        if (this.userAgentValue == null) {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(TIdentity.getInstance().getProductCode());
            stringBuffer.append('/');
            stringBuffer.append(TIdentity.getInstance().getCVSTagName());
            stringBuffer.append('/');
            stringBuffer.append(INVOCATION_TYPE);
            stringBuffer.append('/');
            stringBuffer.append(TIdentity.getInstance().getOSNameAndVersion());
            stringBuffer.append('/');
            stringBuffer.append("Java");
            stringBuffer.append('/');
            stringBuffer.append(TIdentity.getInstance().getJavaVersion());
            this.userAgentValue = stringBuffer.toString();
        }
        httpURLConnection.setRequestProperty(USER_AGENT_KEY, this.userAgentValue);
    }

    private int getMasterCode(int n) {
        return n / 100;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

