/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.http;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.invocation.TInvocationRequestNotWritableException;
import com.softwareag.tamino.db.api.invocation.TInvocationRequestWriter;
import com.softwareag.tamino.db.api.invocation.http.THTTPInvocationMessages;
import com.softwareag.tamino.db.api.io.TOutputStreamWriter;
import com.softwareag.tamino.db.api.io.TStreamable;
import java.io.IOException;
import java.net.HttpURLConnection;

public class THTTPInvocationRequestWriter
extends TInvocationRequestWriter {
    private static final String BOUNDARY = "---------------------------7d16151062e";
    private static final String START_BOUNDARY = "--" + BOUNDARY;
    private static final String END_BOUNDARY = START_BOUNDARY + "--";
    private static final String LINE_SEPARATOR = "\r\n";
    private HttpURLConnection httpConnection = null;
    private TOutputStreamWriter outputStreamWriter = null;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.8 $");

    public THTTPInvocationRequestWriter() {
    }

    public THTTPInvocationRequestWriter(HttpURLConnection httpURLConnection) throws TInvocationRequestNotWritableException {
        try {
            this.initialize(httpURLConnection);
        }
        catch (IOException iOException) {
            throw new TInvocationRequestNotWritableException(iOException);
        }
    }

    public void setConnection(HttpURLConnection httpURLConnection) throws TInvocationRequestNotWritableException {
        try {
            this.initialize(httpURLConnection);
        }
        catch (IOException iOException) {
            throw new TInvocationRequestNotWritableException(iOException);
        }
    }

    protected void write(String string, String string2) throws TInvocationRequestNotWritableException {
        try {
            this.outputStreamWriter.write(START_BOUNDARY);
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(this.getContentDispositionHeader(string));
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(string2);
            this.outputStreamWriter.write(LINE_SEPARATOR);
        }
        catch (Exception exception) {
            this.close();
            throw new TInvocationRequestNotWritableException(THTTPInvocationMessages.TAJHTE0406, exception);
        }
    }

    protected void write(String string, TStreamable tStreamable) throws TInvocationRequestNotWritableException {
        try {
            this.outputStreamWriter.write(START_BOUNDARY);
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(this.getContentDispositionHeader(string));
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(this.getContentTypeHeader(tStreamable.getContentType()));
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(LINE_SEPARATOR);
            this.outputStreamWriter.write(tStreamable);
            this.outputStreamWriter.write(LINE_SEPARATOR);
        }
        catch (Exception exception) {
            this.close();
            throw new TInvocationRequestNotWritableException(THTTPInvocationMessages.TAJHTE0406, exception);
        }
    }

    protected void close() throws TInvocationRequestNotWritableException {
        try {
            this.outputStreamWriter.write(END_BOUNDARY);
            this.outputStreamWriter.flush();
            this.outputStreamWriter.close();
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Invoking Multipart/Form-Data HTTP request:\n" + this.outputStreamWriter.getRecordedWriting());
            }
        }
        catch (Exception exception) {
            throw new TInvocationRequestNotWritableException(THTTPInvocationMessages.TAJHTE0407, exception);
        }
    }

    protected boolean isClosed() {
        return this.outputStreamWriter.isClosed();
    }

    private String getContentDispositionHeader(String string) {
        return "Content-disposition: form-data; name=\"" + string + "\"";
    }

    private String getContentTypeHeader(String string) {
        return "Content-Type: " + string;
    }

    private void initialize(HttpURLConnection httpURLConnection) throws IOException {
        this.httpConnection = httpURLConnection;
        this.httpConnection.setRequestMethod("POST");
        this.httpConnection.setDoOutput(true);
        this.httpConnection.setRequestProperty("Accept-Charset", TPreference.getInstance().getEncoding());
        this.httpConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
        this.outputStreamWriter = new TOutputStreamWriter(httpURLConnection.getOutputStream(), TPreference.getInstance().getEncoding());
        this.outputStreamWriter.useRecordWriting(logger.isLoggable(Level.INFO));
    }
}

