/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.http;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TURLPathEncoder {
    private static final char[] HEX_TAB = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static TURLPathEncoder singleton = null;

    protected TURLPathEncoder() {
    }

    public static synchronized TURLPathEncoder getInstance() {
        if (singleton == null) {
            singleton = new TURLPathEncoder();
        }
        return singleton;
    }

    public String encode(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length() * 2);
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
            dataOutputStream.writeUTF(string);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n = 2;
            while (n < byArray.length) {
                char c = (char)byArray[n];
                if (c == ' ' || c == '<' || c == '>' || c == '#' || c == '%' || c == '\"' || c == '?' || c >= '\u007f') {
                    stringBuffer.append(this.toHexString(c));
                } else {
                    stringBuffer.append(c);
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    private String toHexString(char c) {
        char c2 = c;
        char[] cArray = new char[]{'%', '0', '0'};
        cArray[1] = HEX_TAB[c2 >> 4 & 0xF];
        cArray[2] = HEX_TAB[c2 & 0xF];
        return new String(cArray);
    }
}

