/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.wsl;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TDatabase;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocation;
import com.softwareag.tamino.db.api.invocation.TAuthorizationException;
import com.softwareag.tamino.db.api.invocation.TCommunicationException;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.http.THTTPCommunicationException;
import com.softwareag.tamino.db.api.invocation.http.THTTPInvocationMessages;
import com.softwareag.tamino.db.api.invocation.wsl.TWSLInvocationRequestWriter;
import com.softwareag.tamino.db.api.invocation.wsl.WSL;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import java.io.ByteArrayInputStream;

public class TWSLInvocation
extends TAbstractInvocation {
    private WSL wsl = new WSL();
    private TWSLInvocationRequestWriter invocationRequestWriter = new TWSLInvocationRequestWriter();
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.7 $");
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$invocation$wsl$TWSLInvocation == null ? (class$com$softwareag$tamino$db$api$invocation$wsl$TWSLInvocation = TWSLInvocation.class$("com.softwareag.tamino.db.api.invocation.wsl.TWSLInvocation")) : class$com$softwareag$tamino$db$api$invocation$wsl$TWSLInvocation);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$invocation$wsl$TWSLInvocation == null ? (class$com$softwareag$tamino$db$api$invocation$wsl$TWSLInvocation = TWSLInvocation.class$("com.softwareag.tamino.db.api.invocation.wsl.TWSLInvocation")) : class$com$softwareag$tamino$db$api$invocation$wsl$TWSLInvocation);
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$invocation$wsl$TWSLInvocation;

    public TWSLInvocation(TDatabase tDatabase, String string, String string2, String string3) throws TInvocationException {
        super(tDatabase, string, string2, string3);
        this.wsl.begin();
        this.wsl.setUserId(string2);
        this.wsl.setPassword(string3);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("TWSLInvocation called with 4 arguments");
        }
    }

    public TWSLInvocation(TDatabase tDatabase, String string, String string2) throws TInvocationException {
        this(tDatabase, "", string, string2);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("TWSLInvocation called with 3 argument");
        }
    }

    public TWSLInvocation(TDatabase tDatabase) throws TInvocationException {
        this(tDatabase, "", "", "");
        if (logger.isLoggable(Level.INFO)) {
            logger.info("TWSLInvocation called with 1 argument");
        }
    }

    protected void doClose() throws TInvocationException {
        this.wsl.end();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("doClose() called");
        }
    }

    public TInputStream doInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("- doInvoke called: " + tCommandStatement);
        }
        if (this.workaroundIsRequiredFor(tCommandStatement.getCommand())) {
            return this.doGetInvoke(tCommandStatement, string, string2, string3, bl);
        }
        Precondition.check(tCommandStatement != null && !tCommandStatement.toString().equals(""), "No TCommandStatement instance given!");
        Precondition.check(!this.isClosed(), "Connection with Tamino is closed. Commands cannot be invoked on Tamino anymore!");
        try {
            String string4 = this.getURL(this.getDatabase(), string, string2, string3);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Invoke for url: " + string4);
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("On collection: " + string + " doctype: " + string2 + " docname: " + string3);
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Command Statement: " + tCommandStatement.toString());
            }
            TInputStream tInputStream = null;
            this.wsl.setUri(string4);
            this.invocationRequestWriter.setConnection(this.wsl);
            this.invocationRequestWriter.write(tCommandStatement);
            this.wsl.submit();
            this.wsl.setUri(null);
            this.wsl.setRequestMethod(null);
            this.wsl.setAcceptCharset(null);
            this.wsl.setContentType(null);
            this.wsl.setBody(null, 0L);
            tInputStream = this.getInputStream(this.wsl);
            TStreamHeader tStreamHeader = tInputStream.getHeader();
            tStreamHeader.put("X-API-Collection", string);
            tStreamHeader.put("X-API-Doctype", string2);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Stream Header: " + tStreamHeader);
            }
            return tInputStream;
        }
        catch (TAuthorizationException tAuthorizationException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("TAuthorizationException thrown");
            }
            throw tAuthorizationException;
        }
        catch (Exception exception) {
            throw new TCommunicationException(exception);
        }
    }

    private TInputStream doGetInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        Precondition.check(!this.isClosed(), "Connection with Tamino is closed. Commands cannot be invoked on Tamino anymore!");
        if (logger.isLoggable(Level.INFO)) {
            logger.info("- doGetInvoke called: " + tCommandStatement);
        }
        try {
            String string4 = this.getURL(this.getDatabase(), string, string2, string3);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Invoke for url: " + string4);
            }
            TInputStream tInputStream = null;
            this.wsl.setRequestMethod("GET");
            if (tCommandStatement != null) {
                this.wsl.setQueryString(tCommandStatement.toString());
            }
            this.wsl.setUri(string4);
            this.wsl.setAcceptCharset(TPreference.getInstance().getEncoding());
            if (this.getTransactionModeCoordinator() != null && !this.getTransactionModeCoordinator().usesAutoCommitMode()) {
                this.wsl.setXIno("x-ino");
                this.wsl.submit();
                this.wsl.setXIno(null);
            } else {
                this.wsl.submit();
            }
            this.wsl.setRequestMethod(null);
            if (tCommandStatement != null) {
                this.wsl.setQueryString(null);
            }
            this.wsl.setUri(null);
            this.wsl.setAcceptCharset(null);
            tInputStream = this.getInputStream(this.wsl);
            TStreamHeader tStreamHeader = tInputStream.getHeader();
            tStreamHeader.put("X-API-Collection", string);
            tStreamHeader.put("X-API-Doctype", string2);
            if (logger.isLoggable(Level.INFO)) {
                logger.info(tStreamHeader.toString());
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Stream Header: " + tStreamHeader);
            }
            return tInputStream;
        }
        catch (TInvocationException tInvocationException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("TInvocationException thrown");
            }
            throw tInvocationException;
        }
        catch (Exception exception) {
            throw new TCommunicationException(exception);
        }
    }

    private TInputStream getInputStream(WSL wSL) throws TCommunicationException, TAuthorizationException {
        String string;
        Integer n;
        Integer n2;
        int n3 = wSL.getNumProperty("status_code");
        String string2 = null;
        TStreamHeader tStreamHeader = new TStreamHeader();
        if (n3 == 404) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("File not found while retrieving!");
            }
            return new TInputStream(new THTTPCommunicationException(n3, string2), tStreamHeader);
        }
        if (n3 == 401) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("Authorization failed. Invalid userId and password!");
            }
            throw new TAuthorizationException(THTTPInvocationMessages.TAJHTE0405);
        }
        if (n3 != 200 && n3 != 401) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("TCommunicationException thrown");
            }
            throw new TCommunicationException("HTTP failure.", (Exception)new THTTPCommunicationException(n3, string2));
        }
        int n4 = wSL.getNumProperty("response_length");
        if (logger.isLoggable(Level.INFO)) {
            logger.info("GetContentLength()=" + n4);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        byteArrayInputStream = n4 == -1 || n4 > 0 ? new ByteArrayInputStream(wSL.getResponse(), 0, n4) : new ByteArrayInputStream(new byte[0]);
        tStreamHeader.put("Content-Length", new Integer(n4).toString());
        String string3 = wSL.getTextProperty("response_encoding");
        if (string3 != null && string3.length() > 0) {
            tStreamHeader.put("Content-Type", wSL.getTextProperty("response_type") + "; charset=" + wSL.getTextProperty("response_encoding"));
        } else {
            tStreamHeader.put("Content-Type", wSL.getTextProperty("response_type"));
        }
        String string4 = wSL.getTextProperty("x-ino-version");
        if (string4 != null) {
            tStreamHeader.put("X-INO-Version", string4);
        }
        if ((n2 = new Integer(wSL.getNumProperty("x-ino-sessionkey"))) > 0) {
            tStreamHeader.put("X-INO-Sessionkey", n2.toString());
        }
        if ((n = new Integer(wSL.getNumProperty("x-ino-sessionid"))) > 0) {
            tStreamHeader.put("X-INO-Sessionid", n.toString());
        }
        if ((string = wSL.getTextProperty("last-modified")) != null && string.length() > 0) {
            tStreamHeader.put("X-API-LastModified", string);
        }
        return new TInputStream(byteArrayInputStream, tStreamHeader);
    }

    private String getURL(TDatabase tDatabase, String string, String string2, String string3) {
        String string4 = null;
        int n = tDatabase.getDatabaseURI().indexOf(":", 0);
        if (n >= 0) {
            string4 = tDatabase.getDatabaseURI().substring(n + 2);
        }
        string4 = string == null || string.equals("") ? string4 + "/" : (string2 == null || string2.equals("") ? string4 + "/" + string + "/" : (string3 == null || string3.equals("") ? string4 + "/" + string + "/" + string2 + "/" : string4 + "/" + string + "/" + string2 + "/" + string3));
        return string4;
    }

    private boolean workaroundIsRequiredFor(TCommand tCommand) {
        return tCommand == TCommand.DIAGNOSE || tCommand == TCommand.RETRIEVE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

