/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.wsl;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.invocation.TInvocationException;

public class WSL {
    private static boolean loaded = false;
    static boolean needsStartup = true;
    private int handle = -1;
    private String uri = null;
    private String requestMethod = null;
    private String acceptCharset = null;
    private String contentType = null;
    private String queryString = null;
    private String userId = "";
    private String password = "";
    private String xIno = null;
    private byte[] bodyContent = null;
    private long bodyLength = 0L;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.5 $");

    private native void startup();

    private native void init();

    public native void end();

    private native void cleanup();

    public native int submit();

    public native void setNumProperty(String var1, int var2);

    public native int getNumProperty(String var1);

    public native String getTextProperty(String var1);

    public native byte[] getResponse();

    private native int diagnose(String var1, String var2);

    private native int xql(String var1, String var2, String var3);

    public WSL() throws TInvocationException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!loaded) {
                try {
                    System.loadLibrary("modwsl");
                    loaded = true;
                }
                catch (Error error) {
                    throw new TInvocationException(error.getMessage());
                }
            }
        }
    }

    public void begin() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (needsStartup) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("starting WSL");
                }
                this.startup();
                needsStartup = false;
            }
        }
        this.init();
    }

    public void close() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("stopping WSL");
            }
            this.cleanup();
            needsStartup = true;
        }
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public String getUri() {
        return this.uri;
    }

    public void setRequestMethod(String string) {
        this.requestMethod = string;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setAcceptCharset(String string) {
        this.acceptCharset = string;
    }

    public String getAcceptCharset() {
        return this.acceptCharset;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setXIno(String string) {
        this.xIno = string;
    }

    public String getXIno() {
        return this.xIno;
    }

    public void setBody(byte[] byArray, long l) {
        this.bodyContent = byArray;
        this.bodyLength = l;
    }
}

