/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.io;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.io.TInputStreamCloseListener;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TInputStream
extends FilterInputStream {
    private TStreamHeader header = null;
    private InputStream inputStream = null;
    private Exception failureException = null;
    private TInputStreamCloseListener closeListener = null;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.10 $");

    public TInputStream(InputStream inputStream, TStreamHeader tStreamHeader) {
        super(inputStream);
        this.inputStream = inputStream;
        this.header = tStreamHeader;
        this.failureException = null;
    }

    public TInputStream(Exception exception, TStreamHeader tStreamHeader) {
        super(null);
        this.inputStream = null;
        this.header = tStreamHeader;
        this.failureException = exception;
    }

    public TStreamHeader getHeader() {
        return this.header;
    }

    public Exception getFailureException() {
        return this.failureException;
    }

    public boolean isGiven() {
        return this.inputStream != null;
    }

    public boolean hasFailureException() {
        return this.failureException != null;
    }

    public void close() throws IOException {
        try {
            super.close();
            Object var3_1 = null;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("TInputStream has been closed!");
            }
            if (this.closeListener != null) {
                this.closeListener.closed(this);
                this.closeListener = null;
            }
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (logger.isLoggable(Level.INFO)) {
                logger.info("TInputStream has been closed!");
            }
            if (this.closeListener != null) {
                this.closeListener.closed(this);
                this.closeListener = null;
            }
            throw throwable;
        }
    }

    public void addCloseListener(TInputStreamCloseListener tInputStreamCloseListener) {
        this.closeListener = tInputStreamCloseListener;
    }
}

