/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.io.TXMLStreamable;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectFactory;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;

public abstract class TXMLObject
extends TDataObject
implements TXMLStreamable {
    private static TXMLObjectFactory factory = TXMLObjectFactory.getInstance();
    private String docname = "";
    private String id = "";
    private String systemId = "";
    private String defaultEncoding = "";
    private static final String VALIDATOR_STRING = "CheckMe";
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$TXMLObject == null ? (class$com$softwareag$tamino$db$api$objectModel$TXMLObject = TXMLObject.class$("com.softwareag.tamino.db.api.objectModel.TXMLObject")) : class$com$softwareag$tamino$db$api$objectModel$TXMLObject);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$TXMLObject == null ? (class$com$softwareag$tamino$db$api$objectModel$TXMLObject = TXMLObject.class$("com.softwareag.tamino.db.api.objectModel.TXMLObject")) : class$com$softwareag$tamino$db$api$objectModel$TXMLObject);
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$objectModel$TXMLObject;

    protected TXMLObject() {
        this("", "");
    }

    protected TXMLObject(String string, String string2) {
        super(string, string2, "text/xml");
        this.setEncoding(null);
    }

    public static TXMLObject newInstance(TXMLObjectModel tXMLObjectModel) {
        return factory.newXMLObject(tXMLObjectModel);
    }

    public static TXMLObject newInstance(Object object) {
        if (factory == null) {
            factory = TXMLObjectFactory.getInstance();
        }
        return factory.newXMLObject(object);
    }

    public static TXMLObject newInstance(InputStream inputStream) {
        if (factory == null) {
            factory = TXMLObjectFactory.getInstance();
        }
        return factory.newXMLObject(inputStream);
    }

    public static TXMLObject newInstance(InputStream inputStream, String string) {
        if (factory == null) {
            factory = TXMLObjectFactory.getInstance();
        }
        return factory.newXMLObject(inputStream, string);
    }

    public static TXMLObject newInstance(Reader reader) {
        if (factory == null) {
            factory = TXMLObjectFactory.getInstance();
        }
        return factory.newXMLObject(reader);
    }

    public static TXMLObject newInstance(Reader reader, String string) {
        if (factory == null) {
            factory = TXMLObjectFactory.getInstance();
        }
        return factory.newXMLObject(reader);
    }

    public static TXMLObject newInstance(String string) {
        return TXMLObject.newInstance(new StringReader(string));
    }

    public static TXMLObject newInstance(String string, String string2) {
        return TXMLObject.newInstance(new StringReader(string), string2);
    }

    public static TXMLObject newInstance(URL uRL) {
        TXMLObject tXMLObject = null;
        try {
            tXMLObject = TXMLObject.newInstance(uRL.openStream());
        }
        catch (IOException iOException) {
            Precondition.check(false, "Problem opening the url stream!");
        }
        return tXMLObject;
    }

    public static TXMLObject newInstance(URL uRL, String string) {
        TXMLObject tXMLObject = null;
        try {
            tXMLObject = TXMLObject.newInstance(uRL.openStream(), string);
        }
        catch (IOException iOException) {
            Precondition.check(false, "Problem opening the url stream!");
        }
        return tXMLObject;
    }

    public static TXMLObject newInstance(File file) {
        TXMLObject tXMLObject = null;
        try {
            tXMLObject = TXMLObject.newInstance(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Precondition.check(false, "File not found!");
        }
        return tXMLObject;
    }

    public static TXMLObject newInstance(File file, String string) {
        TXMLObject tXMLObject = null;
        try {
            tXMLObject = TXMLObject.newInstance(new FileInputStream(file), string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Precondition.check(false, "File not found!");
        }
        return tXMLObject;
    }

    public abstract Object getDocument();

    public abstract Object getElement();

    public void setDocname(String string) {
        this.docname = TString.stringize(string);
    }

    public void setId(String string) {
        this.id = TString.stringize(string);
    }

    public void setContentType(String string) {
        if (string.equals("text/xml")) {
            super.setContentType(string);
        }
    }

    public String getDocname() {
        return this.docname;
    }

    public String getId() {
        return this.id;
    }

    public void setSystemId(String string) {
        this.systemId = TString.stringize(string);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setEncoding(String string) {
        this.defaultEncoding = TString.isEmpty(string) ? TPreference.getInstance().getEncoding() : TString.stringize(string);
    }

    public String getEncoding() {
        return this.defaultEncoding;
    }

    public void writeTo(OutputStream outputStream) throws TStreamWriteException {
        this.writeTo(outputStream, this.getEncoding());
    }

    public void writeTo(Writer writer) throws TStreamWriteException {
        this.writeTo(writer, this.getEncoding());
    }

    public void writeTo(OutputStream outputStream, String string) throws TStreamWriteException {
        Precondition.check(false, "The TXMLObject.writeTo( OutputStream outputStream, String encoding ) method needs to be overloaded by " + this.getClass().getName());
    }

    public void writeTo(Writer writer, String string) throws TStreamWriteException {
        Precondition.check(false, "The TXMLObject.writeTo( Writer writer, String encoding ) method needs to be overloaded by " + this.getClass().getName());
    }

    protected void setProperty(String string, Object object) {
    }

    public abstract void readFrom(Reader var1, String var2) throws TStreamReadException;

    public abstract void readFrom(InputStream var1, String var2) throws TStreamReadException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

