/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMObjectModel;
import com.softwareag.tamino.db.api.objectModel.jdom.TJDOMObjectModel;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamAdapter;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamObjectModel;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.xml.sax.InputSource;

public final class TXMLObjectFactory {
    private static TXMLObjectFactory singleton = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$TXMLObjectFactory == null ? (class$com$softwareag$tamino$db$api$objectModel$TXMLObjectFactory = TXMLObjectFactory.class$("com.softwareag.tamino.db.api.objectModel.TXMLObjectFactory")) : class$com$softwareag$tamino$db$api$objectModel$TXMLObjectFactory);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$TXMLObjectFactory == null ? (class$com$softwareag$tamino$db$api$objectModel$TXMLObjectFactory = TXMLObjectFactory.class$("com.softwareag.tamino.db.api.objectModel.TXMLObjectFactory")) : class$com$softwareag$tamino$db$api$objectModel$TXMLObjectFactory);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.19 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$objectModel$TXMLObjectFactory;

    protected TXMLObjectFactory() {
        TXMLObjectModel.register(TJDOMObjectModel.getInstance());
        TXMLObjectModel.register(TDOMObjectModel.getInstance());
        TXMLObjectModel.register(TStreamObjectModel.getInstance());
    }

    public static synchronized TXMLObjectFactory getInstance() {
        if (singleton == null) {
            singleton = new TXMLObjectFactory();
        }
        return singleton;
    }

    public TXMLObject newXMLObject(TXMLObjectModel tXMLObjectModel) {
        Precondition.check(tXMLObjectModel != null, "No TXMLObjectModel given. TXMLObject cannot be instantiated!");
        TXMLObject tXMLObject = null;
        try {
            Class clazz = tXMLObjectModel.getAdapterClass();
            tXMLObject = (TXMLObject)clazz.newInstance();
            this.addProperties(tXMLObject, tXMLObjectModel);
        }
        catch (Exception exception) {
            Precondition.check(false, "TXMLObject adapter class does not provide default constructor");
        }
        return tXMLObject;
    }

    public TXMLObject newXMLObject(Object object) {
        if (object instanceof Reader) {
            object = new InputSource((Reader)object);
        } else if (object instanceof InputStream) {
            object = new InputSource((InputStream)object);
        }
        TXMLObjectModel tXMLObjectModel = TXMLObjectModel.getRegisteredModel(object);
        Precondition.check(tXMLObjectModel != null, "No TXMLObjectModel registered for given class " + object.getClass().getName() + ".");
        TXMLObject tXMLObject = null;
        try {
            Constructor constructor = tXMLObjectModel.getAdapterConstructor(object);
            Object[] objectArray = new Object[]{object};
            tXMLObject = (TXMLObject)constructor.newInstance(objectArray);
            this.addProperties(tXMLObject, tXMLObjectModel);
        }
        catch (Exception exception) {
            Precondition.check(false, "TXMLObject adapter class does not provide appropiate constructor");
        }
        return tXMLObject;
    }

    public TXMLObject newXMLObject(InputStream inputStream) {
        return new TStreamAdapter(inputStream);
    }

    public TXMLObject newXMLObject(InputStream inputStream, String string) {
        return new TStreamAdapter(inputStream, string);
    }

    public TXMLObject newXMLObject(Reader reader) {
        return new TStreamAdapter(reader);
    }

    public TXMLObject newXMLObject(Reader reader, String string) {
        return new TStreamAdapter(reader, string);
    }

    private void addProperties(TXMLObject tXMLObject, TXMLObjectModel tXMLObjectModel) {
        Iterator iterator = tXMLObjectModel.getPropertyKeyIterator();
        Iterator iterator2 = tXMLObjectModel.getPropertyIterator();
        while (iterator.hasNext()) {
            tXMLObject.setProperty((String)iterator.next(), iterator2.next());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

