/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.dom;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TString;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TDOMReader {
    private static final String APACHE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$dom$TDOMReader == null ? (class$com$softwareag$tamino$db$api$objectModel$dom$TDOMReader = TDOMReader.class$("com.softwareag.tamino.db.api.objectModel.dom.TDOMReader")) : class$com$softwareag$tamino$db$api$objectModel$dom$TDOMReader);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$dom$TDOMReader == null ? (class$com$softwareag$tamino$db$api$objectModel$dom$TDOMReader = TDOMReader.class$("com.softwareag.tamino.db.api.objectModel.dom.TDOMReader")) : class$com$softwareag$tamino$db$api$objectModel$dom$TDOMReader);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.9 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$objectModel$dom$TDOMReader;

    public Document read(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        return this.read(reader, null);
    }

    public Document read(Reader reader, String string) throws IOException, SAXException, ParserConfigurationException {
        Precondition.check(reader != null, "No Reader given.");
        InputSource inputSource = new InputSource(reader);
        return this.read(inputSource, string);
    }

    public Document read(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        return this.read(inputStream, null);
    }

    public Document read(InputStream inputStream, String string) throws IOException, SAXException, ParserConfigurationException {
        Precondition.check(inputStream != null, "No InputStream given.");
        InputSource inputSource = new InputSource(inputStream);
        return this.read(inputSource, string);
    }

    protected Document read(InputSource inputSource, String string) throws IOException, SAXException, ParserConfigurationException {
        if (!TString.isEmpty(string)) {
            inputSource.setSystemId(string);
        }
        return this.getDocumentBuilder().parse(inputSource);
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory;
        block3: {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            if (!TPreference.getInstance().useApacheLoadExternalDTD()) {
                try {
                    documentBuilderFactory.setAttribute(APACHE_LOAD_EXTERNAL_DTD, Boolean.FALSE);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!logger.isLoggable(Level.WARNING)) break block3;
                    logger.warning("Could not set the parser feature:http://apache.org/xml/features/nonvalidating/load-external-dtd");
                }
            }
        }
        return documentBuilderFactory.newDocumentBuilder();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

