/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.dom;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.common.TString;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;

public class TDOMWriter {
    private String encoding = null;
    private boolean expandEmptyElements = false;
    private Writer out;
    private String eol = System.getProperty("line.separator", "\n");
    private HashMap nodeTypeMap;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.14 $");
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$dom$TDOMWriter == null ? (class$com$softwareag$tamino$db$api$objectModel$dom$TDOMWriter = TDOMWriter.class$("com.softwareag.tamino.db.api.objectModel.dom.TDOMWriter")) : class$com$softwareag$tamino$db$api$objectModel$dom$TDOMWriter);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$dom$TDOMWriter == null ? (class$com$softwareag$tamino$db$api$objectModel$dom$TDOMWriter = TDOMWriter.class$("com.softwareag.tamino.db.api.objectModel.dom.TDOMWriter")) : class$com$softwareag$tamino$db$api$objectModel$dom$TDOMWriter);
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$objectModel$dom$TDOMWriter;

    public TDOMWriter() {
        this.setExpandEmptyElements(false);
        this.nodeTypeMap = new HashMap();
        this.nodeTypeMap.put(new Integer(2), new TAttrNodeWriter());
        this.nodeTypeMap.put(new Integer(4), new TCDataSectionNodeWriter());
        this.nodeTypeMap.put(new Integer(8), new TCommentNodeWriter());
        this.nodeTypeMap.put(new Integer(9), new TDocumentNodeWriter());
        this.nodeTypeMap.put(new Integer(10), new TDocumentTypeNodeWriter());
        this.nodeTypeMap.put(new Integer(1), new TElementNodeWriter());
        this.nodeTypeMap.put(new Integer(12), new TNotationNodeWriter());
        this.nodeTypeMap.put(new Integer(7), new TProcessingInstructionNodeWriter());
        this.nodeTypeMap.put(new Integer(3), new TTextNodeWriter());
    }

    public void setEncodingAttribute(String string) {
        this.encoding = string;
    }

    public String getEncodingAttribute() {
        return this.encoding;
    }

    public void setExpandEmptyElements(boolean bl) {
        this.expandEmptyElements = bl;
    }

    public boolean getExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public synchronized void write(Node node, Writer writer) throws IOException {
        Precondition.check(node != null, "No DOM node given.");
        Precondition.check(writer != null, "No Writer given.");
        this.out = writer;
        this.writeNode(node);
        this.out.flush();
        this.out = null;
    }

    private void writeNode(Node node) throws IOException {
        Precondition.check(node != null, "No DOM node given.");
        TNodeWriter tNodeWriter = (TNodeWriter)this.nodeTypeMap.get(new Integer(node.getNodeType()));
        if (tNodeWriter != null) {
            tNodeWriter.write(node);
        } else if (logger.isLoggable(Level.SEVERE)) {
            logger.severe("Unsuported DOM node type: " + node.getNodeType());
        }
    }

    private void writeChildNodes(Node node) throws IOException {
        this.writeNodeList(node.getChildNodes());
    }

    private void writeNodeList(NodeList nodeList) throws IOException {
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = 0;
            while (n < nodeList.getLength()) {
                this.writeNode(nodeList.item(n));
                ++n;
            }
        }
    }

    private void writeNamedNodeMap(NamedNodeMap namedNodeMap) throws IOException {
        if (namedNodeMap != null && namedNodeMap.getLength() > 0) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                this.writeNode(namedNodeMap.item(n));
                ++n;
            }
        }
    }

    private final void writeRaw(String string) throws IOException {
        this.out.write(string);
    }

    private final void writeRawWithPredefinedEntities(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < '\"' || c > '>') {
                this.writeRaw(c);
            } else if (c == '\"') {
                this.writeRaw("&quot;");
            } else if (c == '\'') {
                this.writeRaw("&apos;");
            } else if (c == '&') {
                this.writeRaw("&amp;");
            } else if (c == '<') {
                this.writeRaw("&lt;");
            } else if (c == '>') {
                this.writeRaw("&gt;");
            } else {
                this.writeRaw(c);
            }
            ++n2;
        }
    }

    private final void writeRaw(char c) throws IOException {
        this.out.write(c);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TCommentNodeWriter
    implements TNodeWriter {
        private TCommentNodeWriter() {
        }

        public void write(Node node) throws IOException {
            TDOMWriter.this.writeRaw("<!--" + node.getNodeValue() + "-->" + TDOMWriter.this.eol);
        }
    }

    private class TProcessingInstructionNodeWriter
    implements TNodeWriter {
        private TProcessingInstructionNodeWriter() {
        }

        public void write(Node node) throws IOException {
            String string = node.getNodeName();
            String string2 = node.getNodeValue();
            TDOMWriter.this.writeRaw("<?" + string);
            if (string2 != null && string2.length() > 0) {
                TDOMWriter.this.writeRaw(" " + string2);
            }
            TDOMWriter.this.writeRaw("?>");
        }
    }

    private class TNotationNodeWriter
    implements TNodeWriter {
        private TNotationNodeWriter() {
        }

        public void write(Node node) throws IOException {
            Notation notation = (Notation)node;
            TDOMWriter.this.writeRaw("<!NOTATION " + notation.getNodeName());
            String string = notation.getSystemId();
            if (!TString.isEmpty(string)) {
                TDOMWriter.this.writeRaw(" SYSTEM \"" + string + "\"");
            } else {
                String string2 = notation.getPublicId();
                if (!TString.isEmpty(string2)) {
                    TDOMWriter.this.writeRaw(" PUBLIC \"" + string2 + "\"");
                }
            }
            TDOMWriter.this.writeRaw("!>");
        }
    }

    private class TDocumentTypeNodeWriter
    implements TNodeWriter {
        private TDocumentTypeNodeWriter() {
        }

        public void write(Node node) throws IOException {
            String string;
            DocumentType documentType = (DocumentType)node;
            TDOMWriter.this.writeRaw("<!DOCTYPE " + documentType.getNodeName());
            String string2 = documentType.getSystemId();
            if (!TString.isEmpty(string2)) {
                TDOMWriter.this.writeRaw(" SYSTEM \"" + string2 + "\"");
            } else {
                string = documentType.getPublicId();
                if (!TString.isEmpty(string)) {
                    TDOMWriter.this.writeRaw(" PUBLIC \"" + string + "\"");
                }
            }
            TDOMWriter.this.writeNamedNodeMap(documentType.getNotations());
            string = documentType.getInternalSubset();
            if (!TString.isEmpty(string)) {
                TDOMWriter.this.writeRaw("[" + string + "]");
            }
            TDOMWriter.this.writeRaw(">" + TDOMWriter.this.eol);
        }
    }

    private class TCDataSectionNodeWriter
    implements TNodeWriter {
        private TCDataSectionNodeWriter() {
        }

        public void write(Node node) throws IOException {
            TDOMWriter.this.writeRaw("<![CDATA[" + node.getNodeValue() + "]]>");
        }
    }

    private class TTextNodeWriter
    implements TNodeWriter {
        private TTextNodeWriter() {
        }

        public void write(Node node) throws IOException {
            TDOMWriter.this.writeRawWithPredefinedEntities(node.getNodeValue());
        }
    }

    private class TAttrNodeWriter
    implements TNodeWriter {
        private TAttrNodeWriter() {
        }

        public void write(Node node) throws IOException {
            TDOMWriter.this.writeRaw(" " + node.getNodeName() + "=\"");
            TDOMWriter.this.writeRawWithPredefinedEntities(node.getNodeValue());
            TDOMWriter.this.writeRaw('\"');
        }
    }

    private class TElementNodeWriter
    implements TNodeWriter {
        private TElementNodeWriter() {
        }

        public void write(Node node) throws IOException {
            String string = node.getNodeName();
            TDOMWriter.this.writeRaw("<" + string);
            TDOMWriter.this.writeNamedNodeMap(node.getAttributes());
            if (node.hasChildNodes() || TDOMWriter.this.expandEmptyElements) {
                TDOMWriter.this.writeRaw('>');
                TDOMWriter.this.writeChildNodes(node);
                TDOMWriter.this.writeRaw("</" + string + ">");
            } else {
                TDOMWriter.this.writeRaw("/>");
            }
        }
    }

    private class TDocumentNodeWriter
    implements TNodeWriter {
        private TDocumentNodeWriter() {
        }

        public void write(Node node) throws IOException {
            TDOMWriter.this.writeRaw("<?xml version=\"1.0\"");
            if (!TString.isEmpty(TDOMWriter.this.encoding)) {
                TDOMWriter.this.writeRaw(" encoding=\"" + TDOMWriter.this.encoding + "\"");
            }
            TDOMWriter.this.writeRaw("?>" + TDOMWriter.this.eol);
            if (node.hasChildNodes()) {
                TDOMWriter.this.writeChildNodes(node);
            }
        }
    }

    private static interface TNodeWriter {
        public void write(Node var1) throws IOException;
    }
}

