/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.jdom;

import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.objectModel.jdom.TJDOMNamespaceStack;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.output.XMLOutputter;

class TJDOMXMLOutputter
implements Cloneable {
    protected static final String STANDARD_INDENT = "  ";
    private boolean suppressDeclaration = false;
    private String encoding = "UTF8";
    private boolean omitEncoding = false;
    private String indent = null;
    private int indentLevel = 0;
    private boolean expandEmptyElements = false;
    private boolean newlines = false;
    private String lineSeparator = "\r\n";
    private boolean trimText = false;
    private boolean padText = false;
    protected String padTextString = " ";
    static /* synthetic */ Class class$org$jdom$Comment;
    static /* synthetic */ Class class$org$jdom$Element;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jdom$Text;
    static /* synthetic */ Class class$org$jdom$EntityRef;
    static /* synthetic */ Class class$org$jdom$ProcessingInstruction;
    static /* synthetic */ Class class$org$jdom$CDATA;

    public TJDOMXMLOutputter() {
    }

    public TJDOMXMLOutputter(String string) {
        this.indent = string;
    }

    public TJDOMXMLOutputter(String string, boolean bl) {
        this.indent = string;
        this.newlines = bl;
    }

    public TJDOMXMLOutputter(String string, boolean bl, String string2) {
        this.indent = string;
        this.newlines = bl;
        this.encoding = string2;
    }

    public TJDOMXMLOutputter(TJDOMXMLOutputter tJDOMXMLOutputter) {
        this.suppressDeclaration = tJDOMXMLOutputter.suppressDeclaration;
        this.omitEncoding = tJDOMXMLOutputter.omitEncoding;
        this.indent = tJDOMXMLOutputter.indent;
        this.indentLevel = tJDOMXMLOutputter.indentLevel;
        this.expandEmptyElements = tJDOMXMLOutputter.expandEmptyElements;
        this.newlines = tJDOMXMLOutputter.newlines;
        this.encoding = tJDOMXMLOutputter.encoding;
        this.lineSeparator = tJDOMXMLOutputter.lineSeparator;
        this.trimText = tJDOMXMLOutputter.trimText;
        this.padText = tJDOMXMLOutputter.padText;
    }

    public void setLineSeparator(String string) {
        this.lineSeparator = string;
    }

    public void setNewlines(boolean bl) {
        this.newlines = bl;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setOmitEncoding(boolean bl) {
        this.omitEncoding = bl;
    }

    public void setSuppressDeclaration(boolean bl) {
        this.suppressDeclaration = bl;
    }

    public void setExpandEmptyElements(boolean bl) {
        this.expandEmptyElements = bl;
    }

    public void setTrimText(boolean bl) {
        this.trimText = bl;
    }

    public void setPadText(boolean bl) {
        this.padText = bl;
    }

    public void setIndent(String string) {
        if ("".equals(string)) {
            string = null;
        }
        this.indent = string;
    }

    public void setIndent(boolean bl) {
        this.indent = bl ? STANDARD_INDENT : null;
    }

    public void setIndentLevel(int n) {
        this.indentLevel = n;
    }

    public void setIndentSize(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        this.indent = stringBuffer.toString();
    }

    protected void indent(Writer writer, int n) throws IOException {
        if (this.indent != null && !this.indent.equals("")) {
            int n2 = 0;
            while (n2 < n) {
                writer.write(this.indent);
                ++n2;
            }
        }
    }

    protected void maybePrintln(Writer writer) throws IOException {
        if (this.newlines) {
            writer.write(this.lineSeparator);
        }
    }

    protected Writer makeWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), this.encoding);
        return outputStreamWriter;
    }

    protected Writer makeWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), string);
        return outputStreamWriter;
    }

    public void output(Document document, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(document, writer);
        writer.flush();
    }

    public void output(Document document, Writer writer) throws IOException {
        if (this.indentLevel > 0) {
            this.indent(writer, this.indentLevel);
        }
        this.printDeclaration(document, writer, this.encoding);
        if (document.getDocType() != null) {
            if (this.indentLevel > 0) {
                this.indent(writer, this.indentLevel);
            }
            this.printDocType(document.getDocType(), writer);
        }
        Iterator iterator = document.getContent().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof Element) {
                this.output(document.getRootElement(), writer);
                continue;
            }
            if (e instanceof Comment) {
                this.printComment((Comment)e, writer, this.indentLevel);
                continue;
            }
            if (e instanceof ProcessingInstruction) {
                this.printProcessingInstruction((ProcessingInstruction)e, writer, this.indentLevel);
                continue;
            }
            if (!(e instanceof CDATA)) continue;
            this.printCDATASection((CDATA)e, writer, this.indentLevel);
        }
        writer.write(this.lineSeparator);
    }

    public void output(Element element, Writer writer) throws IOException {
        Element element2;
        TJDOMNamespaceStack tJDOMNamespaceStack = new TJDOMNamespaceStack();
        Document document = element.getDocument();
        Element element3 = element2 = document != null ? document.getRootElement() : null;
        if (element != element2 || !element2.getNamespacePrefix().equals("ino")) {
            Namespace namespace = Namespace.getNamespace((String)TInoNamespace.getInstance().getPrefix(), (String)TInoNamespace.getInstance().getUri());
            tJDOMNamespaceStack.push(namespace);
        }
        tJDOMNamespaceStack = this.getParentNamespaces(element.getParent(), tJDOMNamespaceStack);
        this.printElement(element, writer, this.indentLevel, tJDOMNamespaceStack);
    }

    public void output(Element element, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(element, writer);
        writer.flush();
    }

    public void outputElementContent(Element element, Writer writer) throws IOException {
        List list = element.getContent();
        this.printElementContent(element, writer, this.indentLevel, new TJDOMNamespaceStack(), list);
    }

    public void output(CDATA cDATA, Writer writer) throws IOException {
        this.printCDATASection(cDATA, writer, this.indentLevel);
    }

    public void output(CDATA cDATA, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(cDATA, writer);
        writer.flush();
    }

    public void output(Comment comment, Writer writer) throws IOException {
        this.printComment(comment, writer, this.indentLevel);
    }

    public void output(Comment comment, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(comment, writer);
        writer.flush();
    }

    public void output(String string, Writer writer) throws IOException {
        this.printString(string, writer);
    }

    public void output(String string, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.printString(string, writer);
        writer.flush();
    }

    public void output(EntityRef entityRef, Writer writer) throws IOException {
        this.printEntity(entityRef, writer);
    }

    public void output(EntityRef entityRef, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.printEntity(entityRef, writer);
        writer.flush();
    }

    public void output(ProcessingInstruction processingInstruction, Writer writer) throws IOException {
        this.printProcessingInstruction(processingInstruction, writer, this.indentLevel);
    }

    public void output(ProcessingInstruction processingInstruction, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(processingInstruction, writer);
        writer.flush();
    }

    public String outputString(Document document) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.output(document, (Writer)stringWriter);
        stringWriter.flush();
        return stringWriter.toString();
    }

    public String outputString(Element element) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.output(element, (Writer)stringWriter);
        stringWriter.flush();
        return stringWriter.toString();
    }

    protected void printDeclaration(Document document, Writer writer, String string) throws IOException {
        if (!this.suppressDeclaration) {
            if (string.equals("UTF8")) {
                writer.write("<?xml version=\"1.0\"");
                if (!this.omitEncoding) {
                    writer.write(" encoding=\"UTF-8\"");
                }
                writer.write("?>");
            } else {
                writer.write("<?xml version=\"1.0\"");
                if (!this.omitEncoding) {
                    writer.write(" encoding=\"" + string + "\"");
                }
                writer.write("?>");
            }
            writer.write(this.lineSeparator);
        }
    }

    protected void printDocType(DocType docType, Writer writer) throws IOException {
        if (docType == null) {
            return;
        }
        String string = docType.getPublicID();
        String string2 = docType.getSystemID();
        boolean bl = false;
        writer.write("<!DOCTYPE ");
        writer.write(docType.getElementName());
        if (string != null && !string.equals("")) {
            writer.write(" PUBLIC \"");
            writer.write(string);
            writer.write("\"");
            bl = true;
        }
        if (string2 != null && !string2.equals("")) {
            if (!bl) {
                writer.write(" SYSTEM");
            }
            writer.write(" \"");
            writer.write(string2);
            writer.write("\"");
        }
        writer.write(">");
        this.maybePrintln(writer);
    }

    protected void printComment(Comment comment, Writer writer, int n) throws IOException {
        this.indent(writer, n);
        XMLOutputter xMLOutputter = new XMLOutputter();
        writer.write(xMLOutputter.outputString(comment));
        this.maybePrintln(writer);
    }

    protected void printProcessingInstruction(ProcessingInstruction processingInstruction, Writer writer, int n) throws IOException {
        this.indent(writer, n);
        XMLOutputter xMLOutputter = new XMLOutputter();
        writer.write(xMLOutputter.outputString(processingInstruction));
        this.maybePrintln(writer);
    }

    protected void printCDATASection(CDATA cDATA, Writer writer, int n) throws IOException {
        this.indent(writer, n);
        XMLOutputter xMLOutputter = new XMLOutputter();
        writer.write(xMLOutputter.outputString(cDATA));
        this.maybePrintln(writer);
    }

    protected void printElement(Element element, Writer writer, int n, TJDOMNamespaceStack tJDOMNamespaceStack) throws IOException {
        String string;
        Object object;
        List list = element.getContent();
        boolean bl = list.size() == 0;
        boolean bl2 = !bl && list.size() == 1 && list.get(0) instanceof String;
        this.indent(writer, n);
        writer.write("<");
        writer.write(element.getQualifiedName());
        int n2 = tJDOMNamespaceStack.size();
        Namespace namespace = element.getNamespace();
        if (namespace != Namespace.XML_NAMESPACE && (namespace != Namespace.NO_NAMESPACE || tJDOMNamespaceStack.getURI("") != null)) {
            object = namespace.getPrefix();
            string = tJDOMNamespaceStack.getURI((String)object);
            if (!namespace.getURI().equals(string)) {
                tJDOMNamespaceStack.push(namespace);
                this.printNamespace(namespace, writer);
            }
        }
        if ((object = element.getAdditionalNamespaces()) != null) {
            int n3 = 0;
            while (n3 < object.size()) {
                Namespace namespace2 = (Namespace)object.get(n3);
                String string2 = namespace2.getPrefix();
                String string3 = tJDOMNamespaceStack.getURI(string2);
                if (!namespace2.getURI().equals(string3)) {
                    tJDOMNamespaceStack.push(namespace2);
                    this.printNamespace(namespace2, writer);
                }
                ++n3;
            }
        }
        this.printAttributes(element.getAttributes(), element, writer, tJDOMNamespaceStack);
        if (bl2) {
            String string4 = string = this.trimText ? element.getTextTrim() : element.getText();
            if (string == null || string.equals("")) {
                bl = true;
            }
        }
        if (bl) {
            if (!this.expandEmptyElements) {
                writer.write(" />");
            } else {
                writer.write("></");
                writer.write(element.getQualifiedName());
                writer.write(">");
            }
            this.maybePrintln(writer);
        } else {
            writer.write(">");
            if (bl2) {
                this.printElementContent(element, writer, n, tJDOMNamespaceStack, list);
            } else {
                this.maybePrintln(writer);
                this.printElementContent(element, writer, n, tJDOMNamespaceStack, list);
                this.indent(writer, n);
            }
            writer.write("</");
            writer.write(element.getQualifiedName());
            writer.write(">");
            this.maybePrintln(writer);
        }
        while (tJDOMNamespaceStack.size() > n2) {
            tJDOMNamespaceStack.pop();
        }
    }

    protected void printElementContent(Element element, Writer writer, int n, TJDOMNamespaceStack tJDOMNamespaceStack, List list) throws IOException {
        boolean bl;
        boolean bl2 = list.size() == 0;
        boolean bl3 = bl = !bl2 && list.size() == 1 && list.get(0) instanceof String;
        if (bl) {
            String string = this.trimText ? element.getTextTrim() : element.getText();
            writer.write(this.escapeElementEntities(string));
        } else {
            Object var8_9 = null;
            Class clazz = null;
            int n2 = 0;
            int n3 = list.size();
            while (n2 < n3) {
                var8_9 = list.get(n2);
                if (var8_9 instanceof Comment) {
                    this.printComment(var8_9, writer, n + 1);
                    clazz = class$org$jdom$Comment == null ? TJDOMXMLOutputter.class$("org.jdom.Comment") : class$org$jdom$Comment;
                } else if (var8_9 instanceof String) {
                    if (this.padText && clazz == (class$org$jdom$Element == null ? TJDOMXMLOutputter.class$("org.jdom.Element") : class$org$jdom$Element)) {
                        writer.write(this.padTextString);
                    }
                    this.printString(var8_9, writer);
                    clazz = class$java$lang$String == null ? TJDOMXMLOutputter.class$("java.lang.String") : class$java$lang$String;
                } else if (var8_9 instanceof Text) {
                    if (this.padText && clazz == (class$org$jdom$Text == null ? TJDOMXMLOutputter.class$("org.jdom.Text") : class$org$jdom$Text)) {
                        writer.write(this.padTextString);
                    }
                    this.printString(((Text)var8_9).getText(), writer);
                    clazz = class$org$jdom$Text == null ? TJDOMXMLOutputter.class$("org.jdom.Text") : class$org$jdom$Text;
                } else if (var8_9 instanceof Element) {
                    if (this.padText && clazz == (class$java$lang$String == null ? TJDOMXMLOutputter.class$("java.lang.String") : class$java$lang$String)) {
                        writer.write(this.padTextString);
                    }
                    this.printElement(var8_9, writer, n + 1, tJDOMNamespaceStack);
                    clazz = class$org$jdom$Element == null ? TJDOMXMLOutputter.class$("org.jdom.Element") : class$org$jdom$Element;
                } else if (var8_9 instanceof EntityRef) {
                    this.printEntity(var8_9, writer);
                    clazz = class$org$jdom$EntityRef == null ? TJDOMXMLOutputter.class$("org.jdom.EntityRef") : class$org$jdom$EntityRef;
                } else if (var8_9 instanceof ProcessingInstruction) {
                    this.printProcessingInstruction(var8_9, writer, n + 1);
                    clazz = class$org$jdom$ProcessingInstruction == null ? TJDOMXMLOutputter.class$("org.jdom.ProcessingInstruction") : class$org$jdom$ProcessingInstruction;
                } else if (var8_9 instanceof CDATA) {
                    this.printCDATASection(var8_9, writer, n + 1);
                    clazz = class$org$jdom$CDATA == null ? TJDOMXMLOutputter.class$("org.jdom.CDATA") : class$org$jdom$CDATA;
                }
                ++n2;
            }
        }
    }

    protected void printString(String string, Writer writer) throws IOException {
        string = this.escapeElementEntities(string);
        if (this.trimText) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                writer.write(string2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                writer.write(" ");
            }
        } else {
            writer.write(string);
        }
    }

    protected void printEntity(EntityRef entityRef, Writer writer) throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter();
        writer.write(xMLOutputter.outputString(entityRef));
    }

    protected void printNamespace(Namespace namespace, Writer writer) throws IOException {
        writer.write(" xmlns");
        String string = namespace.getPrefix();
        if (!string.equals("")) {
            writer.write(":");
            writer.write(string);
        }
        writer.write("=\"");
        writer.write(namespace.getURI());
        writer.write("\"");
    }

    protected void printAttributes(List list, Element element, Writer writer, TJDOMNamespaceStack tJDOMNamespaceStack) throws IOException {
        HashSet hashSet = new HashSet();
        int n = 0;
        int n2 = list.size();
        while (n < n2) {
            Attribute attribute = (Attribute)list.get(n);
            Namespace namespace = attribute.getNamespace();
            if (namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE) {
                String string = namespace.getPrefix();
                String string2 = tJDOMNamespaceStack.getURI(string);
                if (!namespace.getURI().equals(string2)) {
                    this.printNamespace(namespace, writer);
                    tJDOMNamespaceStack.push(namespace);
                }
            }
            writer.write(" ");
            writer.write(attribute.getQualifiedName());
            writer.write("=");
            writer.write("\"");
            writer.write(this.escapeAttributeEntities(attribute.getValue()));
            writer.write("\"");
            ++n;
        }
    }

    protected String escapeAttributeEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        String string2 = null;
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\'': {
                    string2 = "&apos;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
            }
            if (string2 != null) {
                stringBuffer.append(cArray, n2, n - n2);
                stringBuffer.append(string2);
                string2 = null;
                n2 = n + 1;
            }
            ++n;
        }
        if (n2 < cArray.length) {
            stringBuffer.append(cArray, n2, n - n2);
        }
        return stringBuffer.toString();
    }

    protected String escapeElementEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        String string2 = null;
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
            }
            if (string2 != null) {
                stringBuffer.append(cArray, n2, n - n2);
                stringBuffer.append(string2);
                string2 = null;
                n2 = n + 1;
            }
            ++n;
        }
        if (n2 < cArray.length) {
            stringBuffer.append(cArray, n2, n - n2);
        }
        return stringBuffer.toString();
    }

    public int parseArgs(String[] stringArray, int n) {
        while (n < stringArray.length) {
            if (stringArray[n].equals("-suppressDeclaration")) {
                this.setSuppressDeclaration(true);
            } else if (stringArray[n].equals("-omitEncoding")) {
                this.setOmitEncoding(true);
            } else if (stringArray[n].equals("-indent")) {
                this.setIndent(stringArray[++n]);
            } else if (stringArray[n].equals("-indentSize")) {
                this.setIndentSize(Integer.parseInt(stringArray[++n]));
            } else if (stringArray[n].equals("-indentLevel")) {
                this.setIndentLevel(Integer.parseInt(stringArray[++n]));
            } else if (stringArray[n].startsWith("-expandEmpty")) {
                this.setExpandEmptyElements(true);
            } else if (stringArray[n].equals("-encoding")) {
                this.setEncoding(stringArray[++n]);
            } else if (stringArray[n].equals("-newlines")) {
                this.setNewlines(true);
            } else if (stringArray[n].equals("-lineSeparator")) {
                this.setLineSeparator(stringArray[++n]);
            } else if (stringArray[n].equals("-trimText")) {
                this.setTrimText(true);
            } else if (stringArray[n].equals("-padText")) {
                this.setPadText(true);
            } else {
                return n;
            }
            ++n;
        }
        return n;
    }

    private TJDOMNamespaceStack getParentNamespaces(Element element, TJDOMNamespaceStack tJDOMNamespaceStack) {
        Object object;
        Namespace namespace;
        if (element == null) {
            return tJDOMNamespaceStack;
        }
        if (element.getParent() != null) {
            tJDOMNamespaceStack = this.getParentNamespaces(element.getParent(), tJDOMNamespaceStack);
        }
        if ((namespace = element.getNamespace()) != Namespace.XML_NAMESPACE && (namespace != Namespace.NO_NAMESPACE || tJDOMNamespaceStack.getURI("") != null)) {
            object = namespace.getPrefix();
            String string = tJDOMNamespaceStack.getURI((String)object);
            if (!namespace.getURI().equals(string)) {
                tJDOMNamespaceStack.push(namespace);
            }
        }
        if ((object = element.getAdditionalNamespaces()) != null) {
            int n = 0;
            while (n < object.size()) {
                Namespace namespace2 = (Namespace)object.get(n);
                String string = namespace2.getPrefix();
                String string2 = tJDOMNamespaceStack.getURI(string);
                if (!namespace2.getURI().equals(string2)) {
                    tJDOMNamespaceStack.push(namespace2);
                }
                ++n;
            }
        }
        return tJDOMNamespaceStack;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

