/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.sax;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXDocument;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXDocumentDefaultHandler;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElement;
import com.softwareag.tamino.db.api.objectModel.sax.TSaxMessages;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TSAXAdapter
extends TXMLObject {
    private boolean isBuildFromDocument = false;
    private TSAXDocument document = null;
    private TSAXElement element = null;
    private TSAXDocumentDefaultHandler defaultHandler = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$sax$TSAXAdapter == null ? (class$com$softwareag$tamino$db$api$objectModel$sax$TSAXAdapter = TSAXAdapter.class$("com.softwareag.tamino.db.api.objectModel.sax.TSAXAdapter")) : class$com$softwareag$tamino$db$api$objectModel$sax$TSAXAdapter);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$sax$TSAXAdapter == null ? (class$com$softwareag$tamino$db$api$objectModel$sax$TSAXAdapter = TSAXAdapter.class$("com.softwareag.tamino.db.api.objectModel.sax.TSAXAdapter")) : class$com$softwareag$tamino$db$api$objectModel$sax$TSAXAdapter);
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$objectModel$sax$TSAXDocumentDefaultHandler;
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$objectModel$sax$TSAXAdapter;

    public TSAXAdapter() {
        this((TSAXElement)null);
    }

    public TSAXAdapter(TSAXDocument tSAXDocument) {
        this(tSAXDocument != null ? tSAXDocument.getRootElement() : (TSAXElement)null);
        this.document = tSAXDocument;
        this.isBuildFromDocument = true;
    }

    public TSAXAdapter(TSAXElement tSAXElement) {
        this.element = tSAXElement;
    }

    public void setDocname(String string) {
        if (this.element != null) {
            this.element.setDocname(string);
        } else {
            super.setDocname(string);
        }
    }

    public void setId(String string) {
        if (this.element != null) {
            this.element.setId(string);
        } else {
            super.setId(string);
        }
    }

    public String getDocname() {
        String string = "";
        string = this.element != null ? this.element.getDocname() : super.getDocname();
        return string;
    }

    public String getId() {
        String string = "";
        string = this.element != null ? ((string = this.element.getId()) != null ? string : "") : super.getId();
        return string;
    }

    public String getDoctype() {
        String string = super.getDoctype();
        if (string.equals("") && this.element != null) {
            string = this.element.getDoctype();
        }
        return string;
    }

    public Object getDocument() {
        return this.document;
    }

    public Object getElement() {
        return this.element;
    }

    public void readFrom(InputStream inputStream) throws TStreamReadException {
        this.readFrom(inputStream, this.getSystemId());
    }

    public void readFrom(InputStream inputStream, String string) throws TStreamReadException {
        Precondition.check(this.providesSAXHandler(), "Reading from byte input stream not possible. No SAX handler given!");
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            InputSource inputSource = new InputSource(inputStream);
            if (!TString.isEmpty(string)) {
                inputSource.setSystemId(string);
            }
            sAXParser.parse(inputSource, (DefaultHandler)this.defaultHandler);
            this.document = this.defaultHandler.getDocument();
            if (this.element == null) {
                super.setDocname(null);
                super.setId(null);
            }
            this.element = this.document.getRootElement();
            this.isBuildFromDocument = true;
        }
        catch (Exception exception) {
            throw new TStreamReadException(TSaxMessages.TAJSXE0901, exception);
        }
    }

    public void readFrom(Reader reader) throws TStreamReadException {
        this.readFrom(reader, this.getSystemId());
    }

    public void readFrom(Reader reader, String string) throws TStreamReadException {
        Precondition.check(this.providesSAXHandler(), "Reading from character input stream not possible. No SAX handler given!");
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            InputSource inputSource = new InputSource(reader);
            if (!TString.isEmpty(string)) {
                inputSource.setSystemId(string);
            }
            sAXParser.parse(inputSource, (DefaultHandler)this.defaultHandler);
            this.document = this.defaultHandler.getDocument();
            if (this.element == null) {
                super.setDocname(null);
                super.setId(null);
            }
            this.element = this.document.getRootElement();
            this.isBuildFromDocument = true;
        }
        catch (Exception exception) {
            throw new TStreamReadException(TSaxMessages.TAJSXE0902, exception);
        }
    }

    public void writeTo(OutputStream outputStream) throws TStreamWriteException {
        Precondition.check(this.element != null || this.document != null, "There is currently no consumable XML resource given! Provide consumable resource first!");
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, TPreference.getInstance().getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Precondition.check(false, "Unsupported encoding!");
        }
        this.writeTo(outputStreamWriter);
    }

    public void writeTo(Writer writer) throws TStreamWriteException {
        Precondition.check(this.element != null || this.document != null, "There is currently no consumable XML resource given! Provide consumable resource first!");
        try {
            if (this.isBuildFromDocument) {
                this.document.writeTo(writer);
            } else {
                this.element.writeTo(writer);
            }
            writer.flush();
        }
        catch (Exception exception) {
            throw new TStreamWriteException(TSaxMessages.TAJSXE0903, exception);
        }
    }

    protected boolean canWriteToOutputStream() {
        return this.element != null || this.document != null;
    }

    protected void setProperty(String string, Object object) {
        if (string.equals(TSAXDocumentDefaultHandler.SPECIFIER) && (class$com$softwareag$tamino$db$api$objectModel$sax$TSAXDocumentDefaultHandler == null ? (class$com$softwareag$tamino$db$api$objectModel$sax$TSAXDocumentDefaultHandler = TSAXAdapter.class$("com.softwareag.tamino.db.api.objectModel.sax.TSAXDocumentDefaultHandler")) : class$com$softwareag$tamino$db$api$objectModel$sax$TSAXDocumentDefaultHandler).isInstance(object)) {
            this.defaultHandler = (TSAXDocumentDefaultHandler)object;
        }
    }

    private boolean providesSAXHandler() {
        return this.defaultHandler != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

