/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.stream;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamMessages;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.xml.sax.InputSource;

public class TStreamAdapter
extends TXMLObject
implements Serializable {
    private TStreamWriter streamWriter = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$stream$TStreamAdapter == null ? (class$com$softwareag$tamino$db$api$objectModel$stream$TStreamAdapter = TStreamAdapter.class$("com.softwareag.tamino.db.api.objectModel.stream.TStreamAdapter")) : class$com$softwareag$tamino$db$api$objectModel$stream$TStreamAdapter);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$objectModel$stream$TStreamAdapter == null ? (class$com$softwareag$tamino$db$api$objectModel$stream$TStreamAdapter = TStreamAdapter.class$("com.softwareag.tamino.db.api.objectModel.stream.TStreamAdapter")) : class$com$softwareag$tamino$db$api$objectModel$stream$TStreamAdapter);
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$objectModel$stream$TStreamAdapter;

    public TStreamAdapter() {
        this((Reader)null);
    }

    public TStreamAdapter(InputSource inputSource) {
        this.initialize(inputSource.getByteStream(), inputSource.getCharacterStream(), null);
    }

    public TStreamAdapter(InputSource inputSource, String string) {
        this.initialize(inputSource.getByteStream(), inputSource.getCharacterStream(), string);
    }

    public TStreamAdapter(Reader reader) {
        this.initialize(null, reader, null);
    }

    public TStreamAdapter(Reader reader, String string) {
        this.initialize(null, reader, string);
    }

    public TStreamAdapter(InputStream inputStream) {
        this.initialize(inputStream, null, null);
    }

    public TStreamAdapter(InputStream inputStream, String string) {
        this.initialize(inputStream, null, string);
    }

    public void setDocname(String string) {
        this.streamWriter.setDocname(string);
    }

    public void setId(String string) {
        this.streamWriter.setId(string);
    }

    public String getDocname() {
        return this.streamWriter.getDocname();
    }

    public String getId() {
        return this.streamWriter.getId();
    }

    public String getDoctype() {
        String string = super.getDoctype();
        if (string.length() == 0) {
            string = this.streamWriter.getStartTag();
        }
        return string;
    }

    public Object getDocument() {
        return this.streamWriter.getInputSource();
    }

    public Object getElement() {
        return this.streamWriter.getInputSource();
    }

    public void readFrom(InputStream inputStream) throws TStreamReadException {
        this.readFrom(inputStream, this.getSystemId());
    }

    public void readFrom(InputStream inputStream, String string) throws TStreamReadException {
        try {
            this.streamWriter.setWritableStream(inputStream, string);
        }
        catch (Exception exception) {
            throw new TStreamReadException(TStreamMessages.TAJSTE1001, exception);
        }
    }

    public void readFrom(Reader reader) throws TStreamReadException {
        this.readFrom(reader, this.getSystemId());
    }

    public void readFrom(Reader reader, String string) throws TStreamReadException {
        try {
            this.streamWriter.setWritableStream(reader, string);
        }
        catch (Exception exception) {
            throw new TStreamReadException(TStreamMessages.TAJSTE1002, exception);
        }
    }

    public void writeTo(OutputStream outputStream, String string) throws TStreamWriteException {
        Precondition.check(this.streamWriter.hasWritableStream(), "There is currently no consumable XML resource given! Provide consumable resource first!");
        try {
            this.streamWriter.writeTo(outputStream, string);
        }
        catch (Exception exception) {
            throw new TStreamWriteException(TStreamMessages.TAJSTE1003, exception);
        }
    }

    public void writeTo(Writer writer, String string) throws TStreamWriteException {
        Precondition.check(this.streamWriter.hasWritableStream(), "There is currently no consumable XML resource given! Provide consumable resource first!");
        try {
            this.streamWriter.writeTo(writer, string);
        }
        catch (Exception exception) {
            throw new TStreamWriteException(TStreamMessages.TAJSTE1004, exception);
        }
    }

    protected boolean canWriteToOutputStream() {
        return this.streamWriter.hasWritableStream();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeStateTo(objectOutputStream);
    }

    protected void writeDocumentStateTo(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            StringWriter stringWriter = new StringWriter();
            this.writeTo(stringWriter);
            objectOutputStream.writeObject(stringWriter.toString());
        }
        catch (TStreamWriteException tStreamWriteException) {
            throw new IOException(tStreamWriteException.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initialize(null, null, null);
        super.readStateFrom(objectInputStream);
    }

    protected void readDocumentStateFrom(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            String string = (String)objectInputStream.readObject();
            StringReader stringReader = new StringReader(string);
            this.readFrom(stringReader);
        }
        catch (TStreamReadException tStreamReadException) {
            throw new IOException(TStreamMessages.TAJSTE1005.getResourceMessage().getMessageContent());
        }
    }

    private void initialize(InputStream inputStream, Reader reader, String string) {
        this.setSystemId(string);
        try {
            this.streamWriter = inputStream != null ? new TStreamWriter(inputStream, string) : (reader != null ? new TStreamWriter(reader, string) : new TStreamWriter());
        }
        catch (Exception exception) {
            Precondition.check(false, "TStreamAdapter could not be intitialized with underlying input stream. Check for XML stream correctness! Cause: " + exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

