/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.stream;

import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamMessages;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWriterHelper;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class TStreamWritingDefaultHandler
extends DefaultHandler
implements LexicalHandler {
    private String encoding = "";
    private TStreamWriterHelper writerHelper = null;
    private boolean documentHasStarted = false;
    private boolean withinCDATA = false;
    private String rootElement = null;

    public TStreamWritingDefaultHandler(Writer writer) {
        this.writerHelper = new TStreamWriterHelper(writer);
    }

    public void setEncodingAttribute(String string) {
        this.encoding = string;
    }

    public String getEncodingAttribute() {
        return this.encoding;
    }

    public void setWriter(Writer writer) {
        this.writerHelper.setWriter(writer);
    }

    public void setRootElement(String string) {
        this.rootElement = string != null && !string.equals("") ? string : null;
    }

    public void startDocument() throws SAXException {
        this.documentHasStarted = true;
        this.writerHelper.write("<?xml version=\"1.0\"");
        if (!TString.isEmpty(this.encoding)) {
            this.writerHelper.write(" encoding=\"" + this.encoding + "\"");
        }
        this.writerHelper.write("?>");
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.writerHelper.write("<?" + string + " " + string2 + "?>");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.documentHasStarted && this.rootElement != null) {
            this.writerHelper.write(this.rootElement);
        } else if (attributes.getLength() > 0) {
            this.writerHelper.write("<" + string3);
            int n = 0;
            while (n < attributes.getLength()) {
                this.writerHelper.write(" " + attributes.getQName(n) + "=\"");
                this.writerHelper.writeWithPredefinedEntities(attributes.getValue(n));
                this.writerHelper.write("\"");
                ++n;
            }
            this.writerHelper.write(">");
        } else {
            this.writerHelper.write("<" + string3 + ">");
        }
        this.documentHasStarted = false;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.writerHelper.write("</" + string3 + ">");
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.withinCDATA) {
            this.writerHelper.write(cArray, n, n2);
        } else {
            this.writerHelper.writeWithPredefinedEntities(cArray, n, n2);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writerHelper.getWriter().flush();
        }
        catch (IOException iOException) {
            throw new SAXException(TStreamMessages.TAJSTE1006.getResourceMessage().getMessageContent(), iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.writerHelper.write(cArray, n, n2);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.withinCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.withinCDATA = false;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }
}

