/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import com.softwareag.tamino.db.api.response.TCursorContentItem;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TNonXMLObjectIteratorImpl;
import com.softwareag.tamino.db.api.response.TQueryContentItem;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseContentFactory;
import com.softwareag.tamino.db.api.response.TResponseMessages;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TXMLObjectFetchingIterator;
import com.softwareag.tamino.db.api.response.TXMLObjectIteratorImpl;
import com.softwareag.tamino.db.api.response.TXQueryContentItem;
import java.io.IOException;
import java.util.Iterator;

public class TResponseBuilderImpl
implements TResponseBuilder {
    private static final int XML_ACCESS = 1;
    private static final int NON_XML_ACCESS = 2;
    private TAbstractAccessor abstractAccessor = null;
    private TResponseContentFactory contentFactory = null;
    private TInputStreamInterpreter inputStreamInterpreter = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$response$TResponseBuilderImpl == null ? (class$com$softwareag$tamino$db$api$response$TResponseBuilderImpl = TResponseBuilderImpl.class$("com.softwareag.tamino.db.api.response.TResponseBuilderImpl")) : class$com$softwareag$tamino$db$api$response$TResponseBuilderImpl);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$response$TResponseBuilderImpl == null ? (class$com$softwareag$tamino$db$api$response$TResponseBuilderImpl = TResponseBuilderImpl.class$("com.softwareag.tamino.db.api.response.TResponseBuilderImpl")) : class$com$softwareag$tamino$db$api$response$TResponseBuilderImpl);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.17 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$response$TResponseBuilderImpl;

    public TResponseBuilderImpl(TXMLObjectModel tXMLObjectModel, TAbstractAccessor tAbstractAccessor) {
        this.abstractAccessor = tAbstractAccessor;
        this.contentFactory = TResponseContentFactory.getInstance();
        this.inputStreamInterpreter = this.newInputStreamInterpreter(tXMLObjectModel);
    }

    public TResponseBuilderImpl(TXMLObjectModel tXMLObjectModel) {
        this.abstractAccessor = null;
        this.contentFactory = TResponseContentFactory.getInstance();
        this.inputStreamInterpreter = this.newInputStreamInterpreter(tXMLObjectModel);
    }

    public TResponse buildForXML(TInputStream tInputStream) throws TResponseBuildException {
        return this.doBuild(1, tInputStream);
    }

    public TResponse buildForNonXML(TInputStream tInputStream) throws TResponseBuildException {
        return this.doBuild(2, tInputStream);
    }

    public void setHelperAccessor(TAbstractAccessor tAbstractAccessor) {
        this.abstractAccessor = tAbstractAccessor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TResponse doBuild(int n, TInputStream tInputStream) throws TResponseBuildException {
        TResponse tResponse = null;
        try {
            try {
                this.inputStreamInterpreter.interpret(tInputStream);
                boolean bl = this.inputStreamInterpreter.getResponseInfoContent().hasItem(TQueryContentItem.SPECIFIER);
                boolean bl2 = this.inputStreamInterpreter.getResponseInfoContent().hasItem(TXQueryContentItem.SPECIFIER);
                boolean bl3 = this.inputStreamInterpreter.getResponseInfoContent().hasItem(TCursorContentItem.SPECIFIER);
                if ((bl2 || bl) && !bl3) {
                    tResponse = n == 1 ? this.contentFactory.newResponse(this.inputStreamInterpreter, this.newXMLObjectIterator(this.inputStreamInterpreter.getResponseQueryContent())) : this.contentFactory.newResponse(this.inputStreamInterpreter, this.newNonXMLObjectIterator(this.inputStreamInterpreter.getResponseQueryContent()));
                } else if ((bl2 || bl) && bl3) {
                    tResponse = this.contentFactory.newResponse(this.inputStreamInterpreter, this.newXMLObjectFetchingIterator());
                } else if (!bl2 && !bl && bl3) {
                    Precondition.check(false, "Cursor command other than open not yet implemented.");
                } else {
                    tResponse = this.contentFactory.newResponse(this.inputStreamInterpreter);
                }
                TResponse tResponse2 = tResponse;
                Object var9_9 = null;
                try {
                    tInputStream.close();
                    return tResponse2;
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.SEVERE)) return tResponse2;
                    logger.severe("Closing response inputStream failed with IOException: " + iOException);
                }
                return tResponse2;
            }
            catch (Exception exception) {
                throw new TResponseBuildException(TResponseMessages.TAJRPE1104, exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {}
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.SEVERE)) throw throwable;
                logger.severe("Closing response inputStream failed with IOException: " + iOException);
                throw throwable;
            }
            tInputStream.close();
            throw throwable;
        }
    }

    private TInputStreamInterpreter newInputStreamInterpreter(TXMLObjectModel tXMLObjectModel) {
        TInputStreamInterpreter tInputStreamInterpreter = null;
        Class clazz = tXMLObjectModel.getInputStreamInterpreterClass();
        try {
            Object t = clazz.newInstance();
            tInputStreamInterpreter = (TInputStreamInterpreter)t;
            Iterator iterator = tXMLObjectModel.getPropertyKeyIterator();
            Iterator iterator2 = tXMLObjectModel.getPropertyIterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                Object e = iterator2.next();
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Key:" + string + " Value:" + e);
                }
                tInputStreamInterpreter.setProperty(string, e);
            }
        }
        catch (Exception exception) {
            Precondition.check(false, "Problem instantiating concrete TInputStreamInterpreter. Check XML object model " + tXMLObjectModel.toString());
        }
        return tInputStreamInterpreter;
    }

    private TXMLObjectIterator newXMLObjectIterator(TResponseQueryContent tResponseQueryContent) {
        return new TXMLObjectIteratorImpl(tResponseQueryContent);
    }

    private TXMLObjectIterator newXMLObjectFetchingIterator() {
        return new TXMLObjectFetchingIterator(this.inputStreamInterpreter, this.abstractAccessor);
    }

    private TNonXMLObjectIterator newNonXMLObjectIterator(TResponseQueryContent tResponseQueryContent) {
        return new TNonXMLObjectIteratorImpl(this.newXMLObjectIterator(tResponseQueryContent), this.abstractAccessor);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

