/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TAccessFailureException;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.message.TResourceId;
import com.softwareag.tamino.db.api.objectModel.TIteratorException;
import com.softwareag.tamino.db.api.objectModel.TNoSuchXMLObjectException;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.response.TCursorContentItem;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TMessageContentItem;
import com.softwareag.tamino.db.api.response.TMessageLineContentItem;
import com.softwareag.tamino.db.api.response.TMessageTextContentItem;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseMessages;
import com.softwareag.tamino.db.api.response.TStreamInterpretException;
import com.softwareag.tamino.db.api.response.TXMLObjectIteratorImpl;

class TXMLObjectFetchingIterator
extends TXMLObjectIteratorImpl {
    private TInputStreamInterpreter inputStreamInterpreter = null;
    private static int TRAVELLING = 1;
    private static int CHECKING = 2;
    private TResponseInfoContent travellingResponseInfoContent = null;
    private TResponseInfoContent checkingResponseInfoContent = null;
    private TCommandStatement commandStatement = null;
    private TAbstractAccessor abstractAccessor = null;
    private String collection = null;
    private int primaryQuantity = 0;
    private int count = -1;
    private String cursorHandle = "";
    private int currentLogicalIndex = 0;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$response$TXMLObjectFetchingIterator == null ? (class$com$softwareag$tamino$db$api$response$TXMLObjectFetchingIterator = TXMLObjectFetchingIterator.class$("com.softwareag.tamino.db.api.response.TXMLObjectFetchingIterator")) : class$com$softwareag$tamino$db$api$response$TXMLObjectFetchingIterator);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$response$TXMLObjectFetchingIterator == null ? (class$com$softwareag$tamino$db$api$response$TXMLObjectFetchingIterator = TXMLObjectFetchingIterator.class$("com.softwareag.tamino.db.api.response.TXMLObjectFetchingIterator")) : class$com$softwareag$tamino$db$api$response$TXMLObjectFetchingIterator);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.34 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$response$TXMLObjectFetchingIterator;

    public TXMLObjectFetchingIterator(TInputStreamInterpreter tInputStreamInterpreter, TAbstractAccessor tAbstractAccessor) {
        super(tInputStreamInterpreter.getResponseQueryContent());
        this.abstractAccessor = tAbstractAccessor;
        this.inputStreamInterpreter = tInputStreamInterpreter;
        this.travellingResponseInfoContent = tInputStreamInterpreter.getResponseInfoContent();
        if (this.getCursorContentItem(TRAVELLING) != null) {
            this.primaryQuantity = Integer.parseInt(this.getCursorContentItem(TRAVELLING).getQuantity());
            this.cursorHandle = this.getCursorContentItem(TRAVELLING).getHandle();
            String string = this.getCursorContentItem(TRAVELLING).getCount();
            if (string != null && string != "") {
                this.count = Integer.parseInt(string);
            }
            if (this.getResponseQueryContent() != null && this.getResponseQueryContent().size() > 0) {
                this.collection = this.getResponseQueryContent().get(0).getCollection();
                Precondition.check(this.collection != null && !this.collection.equals(""), "Illegal state, no collection given!");
            }
        }
    }

    public boolean hasNext() {
        return super.hasNext() || this.hasNextCursorObject();
    }

    protected boolean hasNextCursorObject() {
        if (this.getCursorContentItem(TRAVELLING) != null) {
            return this.getCursorContentItem(TRAVELLING).hasNext();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("No cursor content item in hasNextCursorObject() ");
        }
        return false;
    }

    public TXMLObject next() throws TNoSuchXMLObjectException, TIteratorException {
        TXMLObject tXMLObject = null;
        if (super.hasNext()) {
            tXMLObject = super.next();
        } else if (this.hasNextCursorObject()) {
            this.fetchBlockWith(this.currentLogicalIndex, 0, false);
            tXMLObject = super.next();
        } else {
            throw new TNoSuchXMLObjectException(TResponseMessages.TAJRPE1105);
        }
        ++this.currentLogicalIndex;
        return tXMLObject;
    }

    public boolean hasPrevious() {
        return super.hasPrevious() || this.hasPreviousCursorObject();
    }

    protected boolean hasPreviousCursorObject() {
        if (this.getCursorContentItem(TRAVELLING) != null) {
            return this.getCursorContentItem(TRAVELLING).hasPrevious();
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("No cursor content item in hasPreviousCursorObject() ");
        }
        return false;
    }

    public TXMLObject previous() throws TNoSuchXMLObjectException, TIteratorException {
        TXMLObject tXMLObject = null;
        --this.currentLogicalIndex;
        if (super.hasPrevious()) {
            tXMLObject = super.previous();
        } else if (this.hasPreviousCursorObject()) {
            this.fetchBlockWith(this.currentLogicalIndex, 1, false);
            tXMLObject = super.previous();
        } else {
            throw new TNoSuchXMLObjectException(TResponseMessages.TAJRPE1106);
        }
        return tXMLObject;
    }

    public boolean hasCount() {
        return this.count >= 0;
    }

    public int getCount() {
        if (!this.hasCount()) {
            return -1;
        }
        return this.count;
    }

    public boolean canMoveBy(int n) throws TIteratorException {
        if (super.canMoveBy(n)) {
            return true;
        }
        int n2 = this.currentLogicalIndex + n;
        return this.isCursorPossibleAt(n2 + 1);
    }

    public void moveBy(int n) throws TNoSuchXMLObjectException, TIteratorException {
        this.currentLogicalIndex += n;
        if (super.canMoveBy(n)) {
            super.moveBy(n);
            return;
        }
        int n2 = this.fetchBlockWith(this.currentLogicalIndex, 0, true);
        if (n2 > 0) {
            return;
        }
        n2 = this.fetchBlockWith(this.currentLogicalIndex - 1, 0, true);
        if (n2 <= 0) {
            TResourceId tResourceId = TResponseMessages.TAJRPE1107;
            tResourceId.setParams(new Object[]{new Integer(n)});
            throw new TNoSuchXMLObjectException(TResponseMessages.TAJRPE1107);
        }
        this.setCurrentIndex(this.getCurrentIndex() + 1);
    }

    public void reset() throws TIteratorException {
        if (this.currentLogicalIndex < this.primaryQuantity) {
            super.reset();
        } else {
            this.fetchBlockWith(0, 0, true);
        }
        this.currentLogicalIndex = 0;
    }

    public void close() throws TIteratorException {
        if (this.getCursorContentItem(TRAVELLING) != null) {
            try {
                TInputStream tInputStream = this.invokeCloseCursor(this.cursorHandle);
                this.interpret(tInputStream, TRAVELLING);
                TMessageContentItem tMessageContentItem = this.getMessageContentItem(TRAVELLING);
                if (tMessageContentItem != null && !tMessageContentItem.getReturnValue().equals("0")) {
                    throw this.newIteratorException(tMessageContentItem);
                }
            }
            catch (TException tException) {
                throw new TIteratorException(TResponseMessages.TAJRPE1108, (Exception)tException);
            }
        }
    }

    private int fetchBlockWith(int n, int n2, boolean bl) throws TIteratorException {
        try {
            int n3 = n / this.primaryQuantity;
            int n4 = this.fetchBlockAt(n3 * this.primaryQuantity + 1, this.primaryQuantity, bl);
            this.setCurrentIndex(n % this.primaryQuantity + n2);
            return n4;
        }
        catch (ArithmeticException arithmeticException) {
            if (!bl) {
                throw new TIteratorException(TResponseMessages.TAJRPE1116, (Exception)arithmeticException);
            }
            return 0;
        }
    }

    private int fetchBlockAt(int n, int n2, boolean bl) throws TIteratorException {
        Object object;
        try {
            object = this.invokeFetchCursor(this.cursorHandle, n, n2);
            this.interpret((TInputStream)object, TRAVELLING);
        }
        catch (TException tException) {
            throw new TIteratorException(TResponseMessages.TAJRPE1109, (Exception)tException);
        }
        object = this.getMessageContentItem(TRAVELLING);
        if (object != null && (bl ? !((TMessageContentItem)object).getReturnValue().equals("8306") && !((TMessageContentItem)object).getReturnValue().equals("0") : !((TMessageContentItem)object).getReturnValue().equals("0"))) {
            throw this.newIteratorException((TMessageContentItem)object);
        }
        this.setResponseQueryContent(this.inputStreamInterpreter.getResponseQueryContent().iterator(), 2);
        return this.getResponseQueryContent().size();
    }

    private boolean isCursorPossibleAt(int n) throws TIteratorException {
        return this.isCursorPossibleAt(n, true);
    }

    private boolean isCursorPossibleAt(int n, boolean bl) throws TIteratorException {
        Object object;
        if (n < 1) {
            return false;
        }
        try {
            object = this.invokeFetchCursor(this.cursorHandle, n, 0);
            this.interpret((TInputStream)object, CHECKING);
        }
        catch (TException tException) {
            throw new TIteratorException(TResponseMessages.TAJRPE1110, (Exception)tException);
        }
        object = this.getMessageContentItem(CHECKING);
        if (object != null) {
            if (((TMessageContentItem)object).getReturnValue().equals("8306") && bl) {
                return this.isCursorPossibleAt(n - 1, false);
            }
            if (!((TMessageContentItem)object).getReturnValue().equals("0")) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("isCursorPossibleAt(): returnValue=" + ((TMessageContentItem)object).getReturnValue());
                }
                return false;
            }
            return true;
        }
        if (object == null) {
            return true;
        }
        return ((TMessageContentItem)object).getReturnValue().equals("0");
    }

    private void interpret(TInputStream tInputStream, int n) throws TStreamInterpretException {
        this.inputStreamInterpreter.interpret(tInputStream);
        if (n == TRAVELLING) {
            this.travellingResponseInfoContent = this.inputStreamInterpreter.getResponseInfoContent();
        } else {
            this.checkingResponseInfoContent = this.inputStreamInterpreter.getResponseInfoContent();
        }
    }

    private TInputStream invokeFetchCursor(String string, int n, int n2) throws TInvocationException {
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.FETCH);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        tCommandStatement.addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        tCommandStatement.addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        return this.abstractAccessor.invoke(tCommandStatement, this.collection);
    }

    private TInputStream invokeCloseCursor(String string) throws TInvocationException {
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.CLOSE);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        return this.abstractAccessor.invoke(tCommandStatement, this.collection);
    }

    private TIteratorException newIteratorException(TMessageContentItem tMessageContentItem) {
        Object object;
        Object object2;
        if (tMessageContentItem == null) {
            return new TIteratorException(TResponseMessages.TAJRPE1114);
        }
        String string = tMessageContentItem.getReturnValue();
        String string2 = "";
        if (!string.equals("")) {
            object2 = tMessageContentItem.getMessageText();
            string2 = object2 != null ? ((TMessageTextContentItem)object2).getCode() : "";
        }
        object2 = "";
        if (!string.equals("")) {
            object = tMessageContentItem.getMessageText();
            object2 = object != null ? ((TMessageTextContentItem)object).getText() : "";
        }
        object = "";
        if (!string.equals("")) {
            TMessageLineContentItem tMessageLineContentItem = tMessageContentItem.getMessageLine(0);
            object = tMessageLineContentItem != null ? tMessageLineContentItem.getText() : "";
        }
        return new TIteratorException(TResponseMessages.TAJRPE1115, (Exception)new TAccessFailureException(string, string2, (String)object2, (String)object));
    }

    private TMessageContentItem getMessageContentItem(int n) {
        TMessageContentItem tMessageContentItem;
        TMessageContentItem tMessageContentItem2 = (TMessageContentItem)this.getResponseInfoContent(n).getItem(0, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem2 != null && tMessageContentItem2.getReturnValue().equals("0") && (tMessageContentItem = (TMessageContentItem)this.getResponseInfoContent(n).getItem(1, TMessageContentItem.SPECIFIER)) != null) {
            tMessageContentItem2 = tMessageContentItem;
        }
        return tMessageContentItem2;
    }

    private TResponseInfoContent getResponseInfoContent(int n) {
        return n == TRAVELLING ? this.travellingResponseInfoContent : this.checkingResponseInfoContent;
    }

    private TCursorContentItem getCursorContentItem(int n) {
        return (TCursorContentItem)this.getResponseInfoContent(n).getItem(0, TCursorContentItem.SPECIFIER);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

