/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.dom;

import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.namespace.TXQLNamespace;
import com.softwareag.tamino.db.api.namespace.TXQNamespace;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMReader;
import com.softwareag.tamino.db.api.response.TCursorContentItem;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TMessageContentItem;
import com.softwareag.tamino.db.api.response.TMessageLineContentItem;
import com.softwareag.tamino.db.api.response.TMessageTextContentItem;
import com.softwareag.tamino.db.api.response.TObjectContentItem;
import com.softwareag.tamino.db.api.response.TQueryContentItem;
import com.softwareag.tamino.db.api.response.TResponseContentItem;
import com.softwareag.tamino.db.api.response.TResponseContentItemFactory;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TSessionContentItem;
import com.softwareag.tamino.db.api.response.TStreamInterpretException;
import com.softwareag.tamino.db.api.response.TXQueryContentItem;
import com.softwareag.tamino.db.api.response.dom.TResponseDomMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TDOMInputStreamInterpreter
extends TInputStreamInterpreter {
    private String inoNamespace = null;
    private String xqlNamespace = null;
    private String xqNamespace = null;
    private Document document = null;
    private TResponseContentItemFactory responseContentItemFactory = null;

    public TDOMInputStreamInterpreter() {
        this.initialize();
    }

    public void setProperty(String string, Object object) {
    }

    protected void doInterpret(TInputStream tInputStream) throws TStreamInterpretException {
        try {
            TDOMReader tDOMReader = new TDOMReader();
            this.document = tDOMReader.read(tInputStream);
            TStreamHeader tStreamHeader = tInputStream.getHeader();
            this.setResponseInfoContent(this.document);
            Element element = this.document.getDocumentElement();
            if (element.getElementsByTagNameNS(this.xqlNamespace, TXQLNamespace.RESULT.getName()).getLength() == 1 || element.getElementsByTagNameNS(this.xqNamespace, TXQNamespace.RESULT.getName()).getLength() == 1) {
                this.setResponseQueryContent(this.document, tStreamHeader.getValue("X-API-Collection"), tStreamHeader.getValue("X-API-Doctype"));
            }
        }
        catch (Exception exception) {
            throw new TStreamInterpretException(TResponseDomMessages.TAJRDE1201, exception);
        }
    }

    private void initialize() {
        this.inoNamespace = TInoNamespace.getInstance().getUri();
        this.xqlNamespace = TXQLNamespace.getInstance().getUri();
        this.xqNamespace = TXQNamespace.getInstance().getUri();
        this.responseContentItemFactory = TResponseContentItemFactory.getInstance();
    }

    private void setResponseInfoContent(Document document) {
        TResponseInfoContent tResponseInfoContent = this.getResponseInfoContent();
        this.setMessageContentItem(tResponseInfoContent, document);
        this.setQueryContentItem(tResponseInfoContent, document);
        this.setSessionContentItem(tResponseInfoContent, document);
        this.setObjectContentItem(tResponseInfoContent, document);
        this.setCursorContentItem(tResponseInfoContent, document);
    }

    private void setMessageContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.MESSAGE.getName());
        int n = 0;
        while (n < nodeList.getLength()) {
            String string;
            Object object;
            Node node;
            Element element2 = (Element)nodeList.item(n);
            String string2 = element2.getAttributeNS(this.inoNamespace, TInoNamespace.RETURN_VALUE.getName());
            TMessageLineContentItem[] tMessageLineContentItemArray = null;
            NodeList nodeList2 = element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.MESSAGE_LINE.getName());
            if (nodeList2.getLength() > 0) {
                tMessageLineContentItemArray = new TMessageLineContentItem[nodeList2.getLength()];
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    node = (Element)nodeList2.item(n2);
                    object = node.getAttributeNS(this.inoNamespace, TInoNamespace.SUBJECT.getName());
                    string = node.getAttributeNS(this.inoNamespace, TInoNamespace.UNIT.getName());
                    String string3 = node.getFirstChild() != null ? node.getFirstChild().getNodeValue() : "";
                    TMessageLineContentItem tMessageLineContentItem = this.responseContentItemFactory.newMessageLineContentItem((String)object, string3);
                    if (string != null && !string.equals("")) {
                        tMessageLineContentItem.addAttribute(TInoNamespace.UNIT.getQualifiedName(), string);
                    }
                    tMessageLineContentItemArray[n2] = tMessageLineContentItem;
                    ++n2;
                }
            }
            TMessageTextContentItem tMessageTextContentItem = null;
            node = element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.MESSAGE_TEXT.getName()).item(0);
            if (node != null) {
                object = ((Element)node).getAttributeNS(this.inoNamespace, TInoNamespace.CODE.getName());
                string = node.getFirstChild().getNodeValue();
                tMessageTextContentItem = this.responseContentItemFactory.newMessageTextContentItem((String)object, string);
            }
            object = this.responseContentItemFactory.newMessageContentItem(string2, tMessageLineContentItemArray, tMessageTextContentItem);
            tResponseInfoContent.putItem(TMessageContentItem.SPECIFIER, (TResponseContentItem)object);
            ++n;
        }
    }

    private void setQueryContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagNameNS(this.xqNamespace, TXQNamespace.XQUERY.getName()).item(0);
        if (element2 != null) {
            TXQueryContentItem tXQueryContentItem = this.responseContentItemFactory.newXQueryContentItem(element2.getFirstChild().getNodeValue());
            tResponseInfoContent.putItem(TXQueryContentItem.SPECIFIER, tXQueryContentItem);
        } else {
            Element element3 = (Element)element.getElementsByTagNameNS(this.xqlNamespace, TXQLNamespace.QUERY.getName()).item(0);
            if (element3 != null) {
                TQueryContentItem tQueryContentItem = this.responseContentItemFactory.newQueryContentItem(element3.getFirstChild().getNodeValue());
                tResponseInfoContent.putItem(TQueryContentItem.SPECIFIER, tQueryContentItem);
            }
        }
    }

    private void setSessionContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        String string = element.getAttributeNS(this.inoNamespace, TInoNamespace.SESSION_ID.getName());
        String string2 = element.getAttributeNS(this.inoNamespace, TInoNamespace.SESSION_KEY.getName());
        if (string != null && string2 != null) {
            TSessionContentItem tSessionContentItem = this.responseContentItemFactory.newSessionContentItem(string, string2);
            tResponseInfoContent.putItem(TSessionContentItem.SPECIFIER, tSessionContentItem);
        }
    }

    private void setObjectContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.OBJECT.getName()).item(0);
        if (element2 != null) {
            String string = element2.getAttributeNS(this.inoNamespace, TInoNamespace.COLLECTION.getName());
            String string2 = element2.getAttributeNS(this.inoNamespace, TInoNamespace.DOCTYPE.getName());
            String string3 = element2.getAttributeNS(this.inoNamespace, TInoNamespace.ID.getName());
            TObjectContentItem tObjectContentItem = this.responseContentItemFactory.newObjectContentItem(string, string2, string3);
            tResponseInfoContent.putItem(TObjectContentItem.SPECIFIER, tObjectContentItem);
        }
    }

    private void setCursorContentItem(TResponseInfoContent tResponseInfoContent, Document document) {
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.CURSOR.getName()).item(0);
        if (element2 != null) {
            String string = element2.getAttributeNS(this.inoNamespace, TInoNamespace.HANDLE.getName());
            String string2 = element2.getAttributeNS(this.inoNamespace, TInoNamespace.COUNT.getName());
            Element element3 = (Element)element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.CURRENT.getName()).item(0);
            Element element4 = (Element)element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.NEXT.getName()).item(0);
            Element element5 = (Element)element2.getElementsByTagNameNS(this.inoNamespace, TInoNamespace.PREVIOUS.getName()).item(0);
            String string3 = element3 != null ? element3.getAttributeNS(this.inoNamespace, TInoNamespace.POSITION.getName()) : null;
            String string4 = element3 != null ? element3.getAttributeNS(this.inoNamespace, TInoNamespace.QUANTITY.getName()) : null;
            String string5 = element4 != null ? element4.getAttributeNS(this.inoNamespace, TInoNamespace.POSITION.getName()) : null;
            String string6 = element5 != null ? element5.getAttributeNS(this.inoNamespace, TInoNamespace.POSITION.getName()) : null;
            TCursorContentItem tCursorContentItem = this.responseContentItemFactory.newCursorContentItem(string, string3, string4, string5, string6, string2);
            tResponseInfoContent.putItem(TCursorContentItem.SPECIFIER, tCursorContentItem);
        }
    }

    private void setResponseQueryContent(Document document, String string, String string2) {
        NodeList nodeList;
        Element element = document.getDocumentElement();
        Element element2 = (Element)element.getElementsByTagNameNS(this.xqNamespace, TXQNamespace.RESULT.getName()).item(0);
        if (element2 == null) {
            element2 = (Element)element.getElementsByTagNameNS(this.xqlNamespace, TXQLNamespace.RESULT.getName()).item(0);
        }
        if (element2 != null && (nodeList = element2.getChildNodes()).getLength() != 0) {
            TResponseQueryContent tResponseQueryContent = this.getResponseQueryContent();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                short s = node.getNodeType();
                if (s == 1) {
                    TXMLObject tXMLObject = TXMLObject.newInstance(nodeList.item(n));
                    tXMLObject.setCollection(string);
                    tXMLObject.setDoctype(string2);
                    tResponseQueryContent.add(tXMLObject);
                } else {
                    tResponseQueryContent.setText(node.getNodeValue());
                }
                ++n;
            }
        }
    }
}

