/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.sax;

import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElement;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElementDefaultHandler;
import com.softwareag.tamino.db.api.response.TInputStreamInterpreter;
import com.softwareag.tamino.db.api.response.TResponseInfoContent;
import com.softwareag.tamino.db.api.response.TResponseQueryContent;
import com.softwareag.tamino.db.api.response.TStreamInterpretException;
import com.softwareag.tamino.db.api.response.sax.TXMLReaderDecorator;
import com.softwareag.tamino.db.api.response.sax.TXMLReaderDecoratorListener;
import com.softwareag.tamino.db.api.response.sax.helper.TSaxHelperInputStreamInterpreter;
import java.util.Iterator;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class TSAXInputStreamInterpreter
extends TInputStreamInterpreter {
    private boolean isInitialized = false;
    private TSAXElementDefaultHandler elementDefaultHandler = null;
    private DeclHandler declHandler = null;
    private LexicalHandler lexicalHandler = null;
    private String parserName = "";
    private TXMLReaderDecoratorListener instantiationListener = null;
    private TInputStreamInterpreter inputStreamInterpreter = null;
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.14 $");
    static /* synthetic */ Class class$org$xml$sax$ext$DeclHandler;
    static /* synthetic */ Class class$org$xml$sax$ext$LexicalHandler;
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$response$sax$TXMLReaderDecorator;

    public void setProperty(String string, Object object) {
        if (string.equals(TSAXElementDefaultHandler.SPECIFIER)) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Registrating element default handler...");
            }
            this.elementDefaultHandler = (TSAXElementDefaultHandler)object;
        } else if ((class$org$xml$sax$ext$DeclHandler == null ? (class$org$xml$sax$ext$DeclHandler = TSAXInputStreamInterpreter.class$("org.xml.sax.ext.DeclHandler")) : class$org$xml$sax$ext$DeclHandler).isInstance(object)) {
            this.declHandler = (DeclHandler)object;
        } else if ((class$org$xml$sax$ext$LexicalHandler == null ? (class$org$xml$sax$ext$LexicalHandler = TSAXInputStreamInterpreter.class$("org.xml.sax.ext.LexicalHandler")) : class$org$xml$sax$ext$LexicalHandler).isInstance(object)) {
            this.lexicalHandler = (LexicalHandler)object;
        }
    }

    public TResponseInfoContent getResponseInfoContent() {
        if (this.inputStreamInterpreter == null) {
            return null;
        }
        return this.inputStreamInterpreter.getResponseInfoContent();
    }

    protected void doInterpret(TInputStream tInputStream) throws TStreamInterpretException {
        TResponseQueryContent tResponseQueryContent;
        if (!this.isInitialized) {
            this.initialize();
        }
        TStreamHeader tStreamHeader = tInputStream.getHeader();
        Object object = TXMLReaderDecorator.getLock();
        synchronized (object) {
            TXMLReaderDecorator.registerXMLReaderListener(this.instantiationListener);
            if (this.elementDefaultHandler != null) {
                this.elementDefaultHandler.reset();
            }
            this.inputStreamInterpreter.interpret(tInputStream);
            TXMLReaderDecorator.deregisterXMLReaderListener(this.instantiationListener);
        }
        if (this.elementDefaultHandler != null && this.elementDefaultHandler.getFirstElement() != null) {
            this.setResponseQueryContent(this.elementDefaultHandler.getElementIterator(), tStreamHeader.getValue("X-API-Collection"), tStreamHeader.getValue("X-API-Doctype"));
        }
        if ((tResponseQueryContent = this.inputStreamInterpreter.getResponseQueryContent()) != null && tResponseQueryContent.getText().length() > 0) {
            this.getResponseQueryContent().setText(tResponseQueryContent.getText());
        }
    }

    private void initialize() {
        try {
            this.instantiationListener = new InstantiationListener();
            this.inputStreamInterpreter = new TSaxHelperInputStreamInterpreter((class$com$softwareag$tamino$db$api$response$sax$TXMLReaderDecorator == null ? (class$com$softwareag$tamino$db$api$response$sax$TXMLReaderDecorator = TSAXInputStreamInterpreter.class$("com.softwareag.tamino.db.api.response.sax.TXMLReaderDecorator")) : class$com$softwareag$tamino$db$api$response$sax$TXMLReaderDecorator).getName());
        }
        catch (Exception exception) {
            Precondition.check(false, "Problems finding the TXMLReaderDecorator!");
        }
    }

    private void setResponseQueryContent(Iterator iterator, String string, String string2) {
        TResponseQueryContent tResponseQueryContent = this.getResponseQueryContent();
        if (iterator != null && iterator.hasNext()) {
            while (iterator.hasNext()) {
                TSAXElement tSAXElement = (TSAXElement)iterator.next();
                TXMLObject tXMLObject = TXMLObject.newInstance(tSAXElement);
                tXMLObject.setCollection(string);
                tXMLObject.setDoctype(string2);
                tResponseQueryContent.add(tXMLObject);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class InstantiationListener
    implements TXMLReaderDecoratorListener {
        private InstantiationListener() {
        }

        public void instantiationOccurred(TXMLReaderDecorator tXMLReaderDecorator) {
            if (TSAXInputStreamInterpreter.this.elementDefaultHandler != null) {
                tXMLReaderDecorator.setQueryContentHandler(TSAXInputStreamInterpreter.this.elementDefaultHandler);
            }
            if (TSAXInputStreamInterpreter.this.declHandler != null) {
                tXMLReaderDecorator.setQueryDeclHandler(TSAXInputStreamInterpreter.this.declHandler);
            }
            if (TSAXInputStreamInterpreter.this.lexicalHandler != null) {
                tXMLReaderDecorator.setQueryLexicalHandler(TSAXInputStreamInterpreter.this.lexicalHandler);
            }
        }
    }
}

