/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.sax.helper.sodom;

import com.softwareag.tamino.db.api.response.sax.helper.sodom.Comment;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.ContentList;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.DocType;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Element;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.IllegalAddException;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.ProcessingInstruction;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.filter.Filter;
import java.io.Serializable;
import java.util.List;

public class Document
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Document.java,v $ $Revision: 1.1 $ $Date: 2003/01/28 09:20:03 $ $Name: JavaTaminoAPI_4_1_4_42_1_1 $";
    protected ContentList content = new ContentList(this);
    protected DocType docType;

    public Document() {
    }

    public Document(Element element, DocType docType) {
        if (element != null) {
            this.setRootElement(element);
        }
        this.setDocType(docType);
    }

    public Document(Element element) {
        this(element, null);
    }

    public Document(List list, DocType docType) {
        this.setContent(list);
        this.setDocType(docType);
    }

    public Document(List list) {
        this(list, null);
    }

    public boolean hasRootElement() {
        return this.content.indexOfFirstElement() >= 0;
    }

    public Element getRootElement() {
        int n = this.content.indexOfFirstElement();
        if (n < 0) {
            throw new IllegalStateException("Root element not set");
        }
        return (Element)this.content.get(n);
    }

    public Document setRootElement(Element element) {
        int n = this.content.indexOfFirstElement();
        if (n < 0) {
            this.content.add(element);
        } else {
            this.content.set(n, element);
        }
        return this;
    }

    public Element detachRootElement() {
        int n = this.content.indexOfFirstElement();
        if (n < 0) {
            return null;
        }
        return (Element)this.removeContent(n);
    }

    private Object removeContent(int n) {
        return this.content.remove(n);
    }

    public DocType getDocType() {
        return this.docType;
    }

    public Document setDocType(DocType docType) {
        if (docType != null) {
            if (docType.getDocument() != null) {
                throw new IllegalAddException(this, docType, "The docType already is attached to a document");
            }
            docType.setDocument(this);
        }
        if (this.docType != null) {
            this.docType.setDocument(null);
        }
        this.docType = docType;
        return this;
    }

    public Document addContent(ProcessingInstruction processingInstruction) {
        this.content.add(processingInstruction);
        return this;
    }

    public Document addContent(Comment comment) {
        this.content.add(comment);
        return this;
    }

    public List getContent() {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content;
    }

    public List getContent(Filter filter) {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.content.getView(filter);
    }

    public Document setContent(List list) {
        this.content.clearAndSet(list);
        return this;
    }

    public boolean removeContent(ProcessingInstruction processingInstruction) {
        return this.content.remove(processingInstruction);
    }

    public boolean removeContent(Comment comment) {
        return this.content.remove(comment);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("[Document: ");
        if (this.docType != null) {
            stringBuffer.append(this.docType.toString()).append(", ");
        } else {
            stringBuffer.append(" No DOCTYPE declaration, ");
        }
        Element element = this.getRootElement();
        if (element != null) {
            stringBuffer.append("Root is ").append(element.toString());
        } else {
            stringBuffer.append(" No root element");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Document document = null;
        try {
            document = (Document)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.docType != null) {
            document.docType = (DocType)this.docType.clone();
        }
        document.content = new ContentList(document);
        int n = 0;
        while (n < this.content.size()) {
            Cloneable cloneable;
            Object object = this.content.get(n);
            if (object instanceof Element) {
                cloneable = (Element)((Element)object).clone();
                document.content.add(cloneable);
            } else if (object instanceof Comment) {
                cloneable = (Comment)((Comment)object).clone();
                document.content.add(cloneable);
            } else if (object instanceof ProcessingInstruction) {
                cloneable = (ProcessingInstruction)((ProcessingInstruction)object).clone();
                document.content.add(cloneable);
            }
            ++n;
        }
        return document;
    }
}

