/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.sax.helper.sodom;

import com.softwareag.tamino.db.api.response.sax.helper.sodom.Document;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Element;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.IllegalDataException;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Verifier;
import java.io.Serializable;

public class Text
implements Serializable,
Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Text.java,v $ $Revision: 1.1 $ $Date: 2003/01/28 09:20:02 $ $Name: JavaTaminoAPI_4_1_4_42_1_1 $";
    private static final String EMPTY_STRING = "";
    protected String value;
    protected Object parent;

    protected Text() {
    }

    public Text(String string) {
        this.setText(string);
    }

    public String getText() {
        return this.value;
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public static String normalizeString(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (" \t\n\r".indexOf(cArray[n2]) != -1) {
                if (!bl) {
                    cArray2[n++] = 32;
                    bl = true;
                }
            } else {
                cArray2[n++] = cArray[n2];
                bl = false;
            }
            ++n2;
        }
        if (bl && n > 0) {
            --n;
        }
        return new String(cArray2, 0, n);
    }

    public Text setText(String string) {
        if (string == null) {
            this.value = EMPTY_STRING;
            return this;
        }
        String string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "character content", string2);
        }
        this.value = string;
        return this;
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        String string2 = Verifier.checkCharacterData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, "character content", string2);
        }
        this.value = string == EMPTY_STRING ? string : this.value + string;
    }

    public void append(Text text) {
        if (text == null) {
            return;
        }
        this.value = this.value + text.getText();
    }

    public Element getParent() {
        return (Element)this.parent;
    }

    public Document getDocument() {
        if (this.parent != null) {
            return ((Element)this.parent).getDocument();
        }
        return null;
    }

    protected Text setParent(Element element) {
        this.parent = element;
        return this;
    }

    public Text detach() {
        if (this.parent != null) {
            ((Element)this.parent).removeContent(this);
        }
        this.parent = null;
        return this;
    }

    public String toString() {
        return new StringBuffer(64).append("[Text: ").append(this.getText()).append("]").toString();
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Text text = null;
        try {
            text = (Text)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        text.parent = null;
        text.value = this.value;
        return text;
    }

    public final boolean equals(Object object) {
        return this == object;
    }
}

