/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.sax.helper.sodom.filter;

import com.softwareag.tamino.db.api.response.sax.helper.sodom.CDATA;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Comment;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Document;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Element;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.EntityRef;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.ProcessingInstruction;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.Text;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.filter.Filter;

public class ContentFilter
implements Filter {
    private static final String CVS_ID = "@(#) $RCSfile: ContentFilter.java,v $ $Revision: 1.1 $ $Date: 2003/01/28 09:20:04 $ $Name: JavaTaminoAPI_4_1_4_42_1_1 $";
    public static final int ELEMENT = 1;
    public static final int CDATA = 2;
    public static final int TEXT = 4;
    public static final int COMMENT = 8;
    public static final int PI = 16;
    public static final int ENTITYREF = 32;
    public static final int DOCUMENT = 64;
    protected int filterMask;

    public ContentFilter() {
        this.setDefaultMask();
    }

    public ContentFilter(boolean bl) {
        if (bl) {
            this.setDefaultMask();
        } else {
            this.filterMask &= ~this.filterMask;
        }
    }

    public ContentFilter(int n) {
        this.setFilterMask(n);
    }

    public int getFilterMask() {
        return this.filterMask;
    }

    public void setFilterMask(int n) {
        this.setDefaultMask();
        this.filterMask &= n;
    }

    public void setDefaultMask() {
        this.filterMask = 127;
    }

    public void setDocumentContent() {
        this.filterMask = 25;
    }

    public void setElementContent() {
        this.filterMask = 63;
    }

    public void setElementVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 1) : (this.filterMask &= 0xFFFFFFFE);
    }

    public void setCDATAVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 2) : (this.filterMask &= 0xFFFFFFFD);
    }

    public void setTextVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 4) : (this.filterMask &= 0xFFFFFFFB);
    }

    public void setCommentVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 8) : (this.filterMask &= 0xFFFFFFF7);
    }

    public void setPIVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 0x10) : (this.filterMask &= 0xFFFFFFEF);
    }

    public void setEntityRefVisible(boolean bl) {
        this.filterMask = bl ? (this.filterMask |= 0x20) : (this.filterMask &= 0xFFFFFFDF);
    }

    public boolean canAdd(Object object) {
        return this.matches(object);
    }

    public boolean canRemove(Object object) {
        return this.matches(object);
    }

    public boolean matches(Object object) {
        if (object instanceof Element) {
            return (this.filterMask & 1) != 0;
        }
        if (object instanceof CDATA) {
            return (this.filterMask & 2) != 0;
        }
        if (object instanceof Text) {
            return (this.filterMask & 4) != 0;
        }
        if (object instanceof Comment) {
            return (this.filterMask & 8) != 0;
        }
        if (object instanceof ProcessingInstruction) {
            return (this.filterMask & 0x10) != 0;
        }
        if (object instanceof EntityRef) {
            return (this.filterMask & 0x20) != 0;
        }
        if (object instanceof Document) {
            return (this.filterMask & 0x40) != 0;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof ContentFilter) {
            ContentFilter contentFilter = (ContentFilter)object;
            return this.filterMask == contentFilter.filterMask;
        }
        return false;
    }
}

