/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.sax.helper.sodom.input;

import com.softwareag.tamino.db.api.response.sax.helper.sodom.Document;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.SODOMException;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.input.BuilderErrorHandler;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.input.SAXHandler;
import com.softwareag.tamino.db.api.response.sax.helper.sodom.input.SODOMFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXBuilder {
    private static final String CVS_ID = "@(#) $RCSfile: SAXBuilder.java,v $ $Revision: 1.1 $ $Date: 2003/01/28 09:20:04 $ $Name: JavaTaminoAPI_4_1_4_42_1_1 $";
    private static final String DEFAULT_SAX_DRIVER = "org.apache.xerces.parsers.SAXParser";
    private boolean validate;
    private boolean expand = true;
    private String saxDriverClass;
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;
    private XMLFilter saxXMLFilter = null;
    protected SODOMFactory factory = null;
    private boolean ignoringWhite = false;
    private HashMap features = new HashMap(5);
    private HashMap properties = new HashMap(5);

    public SAXBuilder() {
        this(false);
    }

    public SAXBuilder(boolean bl) {
        this.validate = bl;
    }

    public SAXBuilder(String string) {
        this(string, false);
    }

    public SAXBuilder(String string, boolean bl) {
        this.saxDriverClass = string;
        this.validate = bl;
    }

    public void setFactory(SODOMFactory sODOMFactory) {
        this.factory = sODOMFactory;
    }

    public void setValidation(boolean bl) {
        this.validate = bl;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxErrorHandler = errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.saxDTDHandler = dTDHandler;
    }

    public void setXMLFilter(XMLFilter xMLFilter) {
        this.saxXMLFilter = xMLFilter;
    }

    public void setIgnoringElementContentWhitespace(boolean bl) {
        this.ignoringWhite = bl;
    }

    public void setFeature(String string, boolean bl) {
        this.features.put(string, new Boolean(bl));
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Document build(InputSource inputSource) throws SODOMException {
        SAXHandler sAXHandler = null;
        try {
            try {
                Object object;
                sAXHandler = this.createContentHandler();
                this.configureContentHandler(sAXHandler);
                XMLReader xMLReader = this.createParser();
                if (this.saxXMLFilter != null) {
                    object = this.saxXMLFilter;
                    while (object.getParent() instanceof XMLFilter) {
                        object = (XMLFilter)object.getParent();
                    }
                    object.setParent(xMLReader);
                    xMLReader = this.saxXMLFilter;
                }
                this.configureParser(xMLReader, sAXHandler);
                xMLReader.parse(inputSource);
                object = sAXHandler.getDocument();
                Object var7_7 = null;
                sAXHandler = null;
                return object;
            }
            catch (Exception exception) {
                if (exception instanceof SAXParseException) {
                    SAXParseException sAXParseException = (SAXParseException)exception;
                    String string = sAXParseException.getSystemId();
                    if (string != null) {
                        throw new SODOMException("Error on line " + sAXParseException.getLineNumber() + " of document " + string, exception);
                    }
                    throw new SODOMException("Error on line " + sAXParseException.getLineNumber(), exception);
                }
                if (exception instanceof SODOMException) {
                    throw (SODOMException)exception;
                }
                throw new SODOMException("Error in building", exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            sAXHandler = null;
            throw throwable;
        }
    }

    protected SAXHandler createContentHandler() throws Exception {
        SAXHandler sAXHandler = new SAXHandler(this.factory);
        return sAXHandler;
    }

    protected void configureContentHandler(SAXHandler sAXHandler) throws Exception {
        sAXHandler.setExpandEntities(this.expand);
        sAXHandler.setIgnoringElementContentWhitespace(this.ignoringWhite);
    }

    protected XMLReader createParser() throws Exception {
        XMLReader xMLReader = null;
        if (this.saxDriverClass != null) {
            xMLReader = XMLReaderFactory.createXMLReader(this.saxDriverClass);
        } else {
            try {
                Class<?> clazz = Class.forName("javax.xml.parsers.SAXParserFactory");
                Method method = clazz.getMethod("newInstance", null);
                Object object = method.invoke(null, null);
                Method method2 = clazz.getMethod("setValidating", Boolean.TYPE);
                method2.invoke(object, new Boolean(this.validate));
                Method method3 = clazz.getMethod("newSAXParser", null);
                Object object2 = method3.invoke(object, null);
                Class<?> clazz2 = object2.getClass();
                Method method4 = clazz2.getMethod("getXMLReader", null);
                xMLReader = (XMLReader)method4.invoke(object2, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (xMLReader == null) {
            xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_SAX_DRIVER);
            this.saxDriverClass = xMLReader.getClass().getName();
        }
        return xMLReader;
    }

    protected void configureParser(XMLReader xMLReader, SAXHandler sAXHandler) throws Exception {
        block24: {
            Object object;
            Object object2;
            xMLReader.setContentHandler(sAXHandler);
            if (this.saxEntityResolver != null) {
                xMLReader.setEntityResolver(this.saxEntityResolver);
            }
            if (this.saxDTDHandler != null) {
                xMLReader.setDTDHandler(this.saxDTDHandler);
            } else {
                xMLReader.setDTDHandler(sAXHandler);
            }
            if (this.saxErrorHandler != null) {
                xMLReader.setErrorHandler(this.saxErrorHandler);
            } else {
                xMLReader.setErrorHandler(new BuilderErrorHandler());
            }
            Iterator iterator = this.features.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = (Boolean)this.features.get(object2);
                this.internalSetFeature(xMLReader, (String)object2, (Boolean)object, (String)object2);
            }
            object2 = this.properties.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                Object v = this.properties.get(object);
                this.internalSetProperty(xMLReader, (String)object, v, (String)object);
            }
            boolean bl = false;
            try {
                xMLReader.setProperty("http://xml.org/sax/handlers/LexicalHandler", sAXHandler);
                bl = true;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            if (!bl) {
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sAXHandler);
                    bl = true;
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            if (!this.expand) {
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", sAXHandler);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            try {
                this.internalSetFeature(xMLReader, "http://xml.org/sax/features/validation", this.validate, "Validation");
            }
            catch (SODOMException sODOMException) {
                if (!this.validate) break block24;
                throw sODOMException;
            }
        }
        this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespaces", true, "Namespaces");
        this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespace-prefixes", false, "Namespace prefixes");
        try {
            if (xMLReader.getFeature("http://xml.org/sax/features/external-general-entities") != this.expand) {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", this.expand);
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    private void internalSetFeature(XMLReader xMLReader, String string, boolean bl, String string2) throws SODOMException {
        try {
            xMLReader.setFeature(string, bl);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new SODOMException(string2 + " feature not supported for SAX driver " + xMLReader.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new SODOMException(string2 + " feature not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    private void internalSetProperty(XMLReader xMLReader, String string, Object object, String string2) throws SODOMException {
        try {
            xMLReader.setProperty(string, object);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new SODOMException(string2 + " property not supported for SAX driver " + xMLReader.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new SODOMException(string2 + " property not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    public Document build(InputStream inputStream) throws SODOMException {
        return this.build(new InputSource(inputStream));
    }

    public Document build(File file) throws SODOMException {
        try {
            URL uRL = this.fileToURL(file);
            return this.build(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new SODOMException("Error in building", malformedURLException);
        }
    }

    public Document build(URL uRL) throws SODOMException {
        String string = uRL.toExternalForm();
        return this.build(new InputSource(string));
    }

    public Document build(InputStream inputStream, String string) throws SODOMException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.build(inputSource);
    }

    public Document build(Reader reader) throws SODOMException {
        return this.build(new InputSource(reader));
    }

    public Document build(Reader reader, String string) throws SODOMException {
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        return this.build(inputSource);
    }

    public Document build(String string) throws SODOMException {
        return this.build(new InputSource(string));
    }

    protected URL fileToURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    public void setExpandEntities(boolean bl) {
        this.expand = bl;
    }
}

