/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.response.stream;

import com.softwareag.tamino.db.api.objectModel.sax.TSAXElement;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElementDefaultHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWriterHelper;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingDeclHandler;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWritingLexicalHandler;
import com.softwareag.tamino.db.api.response.stream.TStreamElement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class TStreamElementDefaultHandler
extends TSAXElementDefaultHandler
implements LexicalHandler {
    private StringBuffer startElementBuffer = null;
    private int currentLevel = 0;
    private TStreamElement currentElement = null;
    private ArrayList streamElementList = null;
    private TStreamWritingDeclHandler elementDeclHandler = null;
    private TStreamWritingLexicalHandler elementLexicalHandler = null;
    private boolean withinCDATA = false;

    public TStreamElementDefaultHandler(TStreamWritingDeclHandler tStreamWritingDeclHandler, TStreamWritingLexicalHandler tStreamWritingLexicalHandler) {
        this.elementDeclHandler = tStreamWritingDeclHandler;
        this.elementLexicalHandler = tStreamWritingLexicalHandler;
        this.startElementBuffer = new StringBuffer();
        this.streamElementList = new ArrayList();
        this.withinCDATA = false;
    }

    public TSAXElement getFirstElement() {
        return this.streamElementList.size() > 0 ? (TStreamElement)this.streamElementList.get(0) : null;
    }

    public Iterator getElementIterator() {
        return ((AbstractList)this.streamElementList).iterator();
    }

    public void startDocument() throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.currentElement.getWriterHelper().write("<?" + string + " " + string2 + "?>");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.currentLevel == 0) {
            this.appendStreamElement();
        }
        if (attributes.getLength() > 0) {
            this.startElementBuffer.delete(0, this.startElementBuffer.length());
            this.startElementBuffer.append("<" + string3);
            int n = 0;
            while (n < attributes.getLength()) {
                this.startElementBuffer.append(" " + attributes.getQName(n) + "=\"" + attributes.getValue(n) + "\"");
                ++n;
            }
            this.startElementBuffer.append(">");
            this.currentElement.getWriterHelper().write(this.startElementBuffer.toString());
        } else {
            this.currentElement.getWriterHelper().write("<" + string3 + ">");
        }
        ++this.currentLevel;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.currentElement.getWriterHelper().write("</" + string3 + ">");
        --this.currentLevel;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.withinCDATA) {
            this.currentElement.getWriterHelper().write(cArray, n, n2);
        } else {
            this.currentElement.getWriterHelper().writeWithPredefinedEntities(cArray, n, n2);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.withinCDATA = true;
    }

    public void endCDATA() throws SAXException {
        this.withinCDATA = false;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public void clear() {
        this.startElementBuffer = new StringBuffer();
        this.streamElementList.clear();
    }

    public TStreamWriterHelper getElementWriter() {
        return this.currentElement.getWriterHelper();
    }

    private void appendStreamElement() {
        this.currentElement = new TStreamElement();
        this.elementDeclHandler.setWriter(this.currentElement.getWriterHelper());
        this.elementLexicalHandler.setWriter(this.currentElement.getWriterHelper());
        this.streamElementList.add(this.currentElement);
    }
}

