/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.ElementHandler;
import org.dom4j.io.DispatchHandler;
import org.dom4j.io.SAXContentHandler;
import org.dom4j.io.SAXHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXReader {
    private DocumentFactory factory;
    private XMLReader xmlReader;
    private boolean validating;
    private DispatchHandler dispatchHandler;
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    private boolean stringInternEnabled = true;
    private boolean includeInternalDTDDeclarations = false;
    private boolean includeExternalDTDDeclarations = false;
    private boolean mergeAdjacentText = false;
    private boolean stripWhitespaceText = false;
    private boolean ignoreComments = false;
    private XMLFilter xmlFilter;

    public SAXReader() {
    }

    public SAXReader(boolean validating) {
        this.validating = validating;
    }

    public SAXReader(DocumentFactory factory) {
        this.factory = factory;
    }

    public SAXReader(DocumentFactory factory, boolean validating) {
        this.factory = factory;
        this.validating = validating;
    }

    public SAXReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public SAXReader(XMLReader xmlReader, boolean validating) {
        this.xmlReader = xmlReader;
        this.validating = validating;
    }

    public SAXReader(String xmlReaderClassName) throws SAXException {
        if (xmlReaderClassName != null) {
            this.xmlReader = XMLReaderFactory.createXMLReader(xmlReaderClassName);
        }
    }

    public SAXReader(String xmlReaderClassName, boolean validating) throws SAXException {
        if (xmlReaderClassName != null) {
            this.xmlReader = XMLReaderFactory.createXMLReader(xmlReaderClassName);
        }
        this.validating = validating;
    }

    public void setProperty(String name, Object value) throws SAXException {
        this.getXMLReader().setProperty(name, value);
    }

    public void setFeature(String name, boolean value) throws SAXException {
        this.getXMLReader().setFeature(name, value);
    }

    public Document read(File file) throws DocumentException {
        try {
            InputSource source = new InputSource(new FileInputStream(file));
            String path = file.getAbsolutePath();
            if (path != null) {
                StringBuffer sb = new StringBuffer("file://");
                if (!path.startsWith(File.separator)) {
                    sb.append("/");
                }
                path = path.replace('\\', '/');
                sb.append(path);
                source.setSystemId(sb.toString());
            }
            return this.read(source);
        }
        catch (FileNotFoundException e) {
            throw new DocumentException(e.getMessage(), e);
        }
    }

    public Document read(URL url) throws DocumentException {
        String systemID = url.toExternalForm();
        return this.read(new InputSource(systemID));
    }

    public Document read(String systemId) throws DocumentException {
        return this.read(new InputSource(systemId));
    }

    public Document read(InputStream in) throws DocumentException {
        return this.read(new InputSource(in));
    }

    public Document read(Reader reader) throws DocumentException {
        return this.read(new InputSource(reader));
    }

    public Document read(InputStream in, String systemId) throws DocumentException {
        InputSource source = new InputSource(in);
        source.setSystemId(systemId);
        return this.read(source);
    }

    public Document read(Reader reader, String systemId) throws DocumentException {
        InputSource source = new InputSource(reader);
        source.setSystemId(systemId);
        return this.read(source);
    }

    public Document read(InputSource in) throws DocumentException {
        try {
            XMLReader xmlReader = this.getXMLReader();
            xmlReader = this.installXMLFilter(xmlReader);
            EntityResolver thatEntityResolver = this.entityResolver;
            if (thatEntityResolver == null) {
                this.entityResolver = thatEntityResolver = this.createDefaultEntityResolver(in.getSystemId());
            }
            xmlReader.setEntityResolver(thatEntityResolver);
            SAXContentHandler contentHandler = this.createContentHandler(xmlReader);
            contentHandler.setEntityResolver(thatEntityResolver);
            contentHandler.setInputSource(in);
            contentHandler.setIncludeInternalDTDDeclarations(this.isIncludeInternalDTDDeclarations());
            contentHandler.setIncludeExternalDTDDeclarations(this.isIncludeExternalDTDDeclarations());
            contentHandler.setMergeAdjacentText(this.isMergeAdjacentText());
            contentHandler.setStripWhitespaceText(this.isStripWhitespaceText());
            contentHandler.setIgnoreComments(this.isIgnoreComments());
            xmlReader.setContentHandler(contentHandler);
            this.configureReader(xmlReader, contentHandler);
            xmlReader.parse(in);
            return contentHandler.getDocument();
        }
        catch (Exception e) {
            if (e instanceof SAXParseException) {
                SAXParseException parseException = (SAXParseException)e;
                String systemId = parseException.getSystemId();
                if (systemId == null) {
                    systemId = "";
                }
                String message = "Error on line " + parseException.getLineNumber() + " of document " + systemId + " : " + parseException.getMessage();
                throw new DocumentException(message, e);
            }
            throw new DocumentException(e.getMessage(), e);
        }
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidation(boolean validating) {
        this.validating = validating;
    }

    public boolean isIncludeInternalDTDDeclarations() {
        return this.includeInternalDTDDeclarations;
    }

    public void setIncludeInternalDTDDeclarations(boolean includeInternalDTDDeclarations) {
        this.includeInternalDTDDeclarations = includeInternalDTDDeclarations;
    }

    public boolean isIncludeExternalDTDDeclarations() {
        return this.includeExternalDTDDeclarations;
    }

    public void setIncludeExternalDTDDeclarations(boolean includeExternalDTDDeclarations) {
        this.includeExternalDTDDeclarations = includeExternalDTDDeclarations;
    }

    public boolean isStringInternEnabled() {
        return this.stringInternEnabled;
    }

    public void setStringInternEnabled(boolean stringInternEnabled) {
        this.stringInternEnabled = stringInternEnabled;
    }

    public boolean isMergeAdjacentText() {
        return this.mergeAdjacentText;
    }

    public void setMergeAdjacentText(boolean mergeAdjacentText) {
        this.mergeAdjacentText = mergeAdjacentText;
    }

    public boolean isStripWhitespaceText() {
        return this.stripWhitespaceText;
    }

    public void setStripWhitespaceText(boolean stripWhitespaceText) {
        this.stripWhitespaceText = stripWhitespaceText;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public DocumentFactory getDocumentFactory() {
        if (this.factory == null) {
            this.factory = DocumentFactory.getInstance();
        }
        return this.factory;
    }

    public void setDocumentFactory(DocumentFactory factory) {
        this.factory = factory;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public XMLReader getXMLReader() throws SAXException {
        if (this.xmlReader == null) {
            this.xmlReader = this.createXMLReader();
        }
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public void setXMLReaderClassName(String xmlReaderClassName) throws SAXException {
        this.setXMLReader(XMLReaderFactory.createXMLReader(xmlReaderClassName));
    }

    public void addHandler(String path, ElementHandler handler) {
        this.getDispatchHandler().addHandler(path, handler);
    }

    public void removeHandler(String path) {
        this.getDispatchHandler().removeHandler(path);
    }

    public void setDefaultHandler(ElementHandler handler) {
        this.getDispatchHandler().setDefaultHandler(handler);
    }

    public void resetHandlers() {
        this.getDispatchHandler().resetHandlers();
    }

    public XMLFilter getXMLFilter() {
        return this.xmlFilter;
    }

    public void setXMLFilter(XMLFilter xmlFilter) {
        this.xmlFilter = xmlFilter;
    }

    protected XMLReader installXMLFilter(XMLReader xmlReader) {
        XMLFilter xmlFilter = this.getXMLFilter();
        if (xmlFilter != null) {
            XMLReader parent;
            XMLFilter root = xmlFilter;
            while ((parent = root.getParent()) instanceof XMLFilter) {
                root = (XMLFilter)parent;
            }
            root.setParent(xmlReader);
            return xmlFilter;
        }
        return xmlReader;
    }

    protected DispatchHandler getDispatchHandler() {
        if (this.dispatchHandler == null) {
            this.dispatchHandler = new DispatchHandler();
        }
        return this.dispatchHandler;
    }

    protected void setDispatchHandler(DispatchHandler dispatchHandler) {
        this.dispatchHandler = dispatchHandler;
    }

    protected XMLReader createXMLReader() throws SAXException {
        return SAXHelper.createXMLReader(this.isValidating());
    }

    protected void configureReader(XMLReader reader, DefaultHandler contentHandler) throws DocumentException {
        block5: {
            SAXHelper.setParserProperty(reader, "http://xml.org/sax/handlers/LexicalHandler", contentHandler);
            SAXHelper.setParserProperty(reader, "http://xml.org/sax/properties/lexical-handler", contentHandler);
            if (this.includeInternalDTDDeclarations || this.includeExternalDTDDeclarations) {
                SAXHelper.setParserProperty(reader, "http://xml.org/sax/properties/declaration-handler", contentHandler);
            }
            SAXHelper.setParserFeature(reader, "http://xml.org/sax/features/namespaces", true);
            SAXHelper.setParserFeature(reader, "http://xml.org/sax/features/namespace-prefixes", false);
            SAXHelper.setParserFeature(reader, "http://xml.org/sax/features/string-interning", this.isStringInternEnabled());
            try {
                reader.setFeature("http://xml.org/sax/features/validation", this.isValidating());
                if (this.errorHandler != null) {
                    reader.setErrorHandler(this.errorHandler);
                } else {
                    reader.setErrorHandler(contentHandler);
                }
            }
            catch (Exception e) {
                if (!this.isValidating()) break block5;
                throw new DocumentException("Validation not supported for XMLReader: " + reader, e);
            }
        }
    }

    protected SAXContentHandler createContentHandler(XMLReader reader) {
        return new SAXContentHandler(this.getDocumentFactory(), this.dispatchHandler);
    }

    protected EntityResolver createDefaultEntityResolver(String documentSystemId) {
        int idx;
        String prefix = null;
        if (documentSystemId != null && documentSystemId.length() > 0 && (idx = documentSystemId.lastIndexOf(47)) > 0) {
            prefix = documentSystemId.substring(0, idx + 1);
        }
        return new SAXEntityResolver(prefix);
    }

    protected static class SAXEntityResolver
    implements EntityResolver,
    Serializable {
        String uriPrefix;

        public SAXEntityResolver(String uriPrefix) {
            this.uriPrefix = uriPrefix;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            if (systemId != null && systemId.length() > 0 && this.uriPrefix != null && systemId.indexOf(58) <= 0) {
                systemId = this.uriPrefix + systemId;
            }
            return new InputSource(systemId);
        }
    }
}

