/*
 * Copyright (c) 2003 SOFTWARE AG, All Rights Reserved.
 */


/*
 || Example for the Tamino API for Java
 ||
 || It is assumed that a Tamino database called "mydb" has
 || been created and is running.
 || For storing data the default collection ino:etc is used
 || which should only be used for examples/test code.
 || We do not recommend this for real applications.
 ||
 || The following tasks are performed:
 ||
 || - establish a connection to the Tamino database
 || - obtain an XML accessor
 || - insert a new XML document
 || - query the inserted document
 || - close the connection
 */
package com.softwareag.tamino.db.api.examples.greeting;

import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMObjectModel;
import com.softwareag.tamino.db.api.response.TResponse;
import java.io.StringReader;
import java.io.StringWriter;


public class XMLGreeting {
	
	public static void main(String[] args) throws Exception {
		// Put the XML content into a StringReader
		StringReader stringReader = new StringReader( XML );
		// Instantiate an empty TXMLObject instance using the DOM object model
		TXMLObject xmlObject = TXMLObject.newInstance( TDOMObjectModel.getInstance() );
		// Establish the DOM representation by reading the content from the
		// character input stream
		xmlObject.readFrom( stringReader );
		// Establish the connection to Tamino
		TConnection connection = TConnectionFactory.getInstance().newConnection( DATABASE_URI );
		// Obtain a TXMLObjectAccessor with a DOM object model
		TXMLObjectAccessor xmlObjectAccessor = connection.newXMLObjectAccessor(
			TAccessLocation.newInstance( "ino:etc" ),
			TDOMObjectModel.getInstance() );
		try {
			// Invoke the insert operation
			xmlObjectAccessor.insert( xmlObject );
			// Show the ino:id of the document just inserted
			System.out.println( "Insert succeeded, ino:id=" + xmlObject.getId() );
		}
		catch (TInsertException insertException) {
			// Inform about the reason for the failure
			System.out.println( "Insert failed!" );
			if ( insertException.hasAccessFailureException() )
				System.out.println( "Insert rejected by Tamino. Reason:" +
								   insertException.getAccessFailureException() );
			else
				System.out.println( "Insert failed due to following reason:" +
								   insertException.getRootCause().getMessage() );
		}
		// Prepare to read the instance
		TQuery query = TQuery.newInstance( xmlObject.getDoctype() + "[@ino:id=" +
										  xmlObject.getId() + "]" );
		try {
			// Invoke the query operation
			TResponse response = xmlObjectAccessor.query( query );
			if ( response.hasFirstXMLObject() ) {
				StringWriter stringWriter = new StringWriter();
				response.getFirstXMLObject().writeTo( stringWriter );
				System.out.println( "Retrieved following instance:" + stringWriter );
			}
			else
				System.out.println( "No instance found!" );
		}
		catch (TQueryException queryException) {
			// Inform about the reason for the failure
			System.out.println( "Query failed!" );
			if ( queryException.hasAccessFailureException() )
				System.out.println( "Query rejected by Tamino. Reason:" +
								   queryException.getAccessFailureException() );
			else
				System.out.println( "Insert failed due to following reason:" +
								   queryException.getRootCause().getMessage() );
		}
		// OK, everything is done, close the connection.
		connection.close();
	}
	
	// URI of the Tamino database, please edit accordingly
	public final static String DATABASE_URI = "http://localhost/tamino/mydb";
	
	// XML document to be written to the connected database
	public final static String XML =
	"<Greeting by='XMLGreetingApplication'>Hello World</Greeting>";
	
}

