/*
 * Copyright (c) 2003 SOFTWARE AG, All Rights Reserved.
 */


/*
 * MusicianCollaborationResultDOM4J.java
 */
package com.softwareag.tamino.db.api.examples.jazz;


import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.common.TAccessFailureMessage;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionException;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import com.softwareag.tamino.db.api.objectModel.dom4j.TDOM4JObjectModel;
import com.softwareag.tamino.db.api.response.TResponse;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.XMLWriter;


public class MusicianCollaborationResultDOM4J {
	
	/** Creates new musicianCollaborationResult */
	public MusicianCollaborationResultDOM4J(String databaseURI,
											String collection) throws TConnectionException {
		// Obtain the connection factory
		TConnectionFactory connectionFactory =
		TConnectionFactory.getInstance();
		// Obtain the connection to the database
		connection = connectionFactory.newConnection( databaseURI );
		// Instantiate the specific TDOM4JObjectModel
		TXMLObjectModel dom4jObjectModel = TDOM4JObjectModel.getInstance();
		// Do the object model registration.
		TXMLObjectModel.register( dom4jObjectModel );
		// Obtain the concrete TXMLObjectAccessor
		//  with an underyling DOM4J object model
		
		accessor = connection.newXMLObjectAccessor(
			TAccessLocation.newInstance( collection ) ,
			dom4jObjectModel );
	}
	// process query
	private TResponse processQuery(String s) throws Exception {
		TQuery query = TQuery.newInstance( s );
		try {
			// Invoke the query operation.
			return accessor.query( query );
		}
		catch (TQueryException queryException) {
			// Tell about the reason for the failure.
			showAccessFailure(queryException);
			return null;
		}
	}
	// Show the reason for the access failure.
	private void showAccessFailure(TAccessorException accessorException) throws Exception {
		// Obtain an access failure message telling the exact reason
		//   if Tamino request failed.
		TAccessFailureMessage
		accessFailure = accessorException.getAccessFailureException();
		if ( accessFailure != null )
			throw new Exception( "Access failed:" + accessFailure );
		else
			throw new Exception( "Access failed:" + accessorException.getMessage() );
	}
	// show result
	private void show(String keyValue)  throws Exception {
		try  {
			XMLWriter xmlWriter = new XMLWriter(System.out);
			// Build a query and process it
			TResponse response =
			processQuery( "jazzMusician[@ID"+"='" + keyValue + "']" );
			// Get first (and single) object
			if (!response.hasFirstXMLObject())
				throw new Exception("Nothing found");
			TXMLObject xmlObject = response.getFirstXMLObject();
			// Get top level DOM4J element
			Element jazzMusician = (Element) xmlObject.getElement();
			// Now get collaborations
			response = processQuery(
				"collaboration[jazzMusician"+"='" + keyValue + "']" );
			// Iterate over result documents
			TXMLObjectIterator collabIt = response.getXMLObjectIterator();
			while (collabIt.hasNext()) {
				xmlObject = collabIt.next();
				// Get top level DOM4J element
				Element collab = (Element) xmlObject.getElement();
				// clone to remove context
				collab = (Element) collab.clone();
				// Get a list of all direct children with name "result"
				List resultChildren = collab.elements("result");
				// get iterator over children
				ListIterator resultIt = resultChildren.listIterator();
				// now loop over the "result" children
				while (resultIt.hasNext()) {
					// get a single "result" child
					Element resultElement = (Element) resultIt.next();
					// get the content
					String resultID = resultElement.getText();
					// now read album records with resultID as key
					response = processQuery(
						"album[productNo"+"='" + resultID + "']" );
					// Process the album if we have one
					if (response.hasFirstXMLObject()) {
						// get first (and only) result document
						xmlObject = response.getFirstXMLObject();
						// Get top level DOM4J element
						Element album = (Element) xmlObject.getElement();
						// clone to remove context
						album = (Element) album.clone();
						// remove "tracks" elements
						Iterator iter = album.elementIterator("track");
						while(iter.hasNext()) {
							album.remove((Element) iter.next());
						}
						
						// remove ino:id
						QName qname = new QName("id",INO_NAMESPACE);
						album.remove(album.attribute(qname));
						// add album to collaboration clone
						collab.add(album);
					}
				}
				// remove "result" elements from collaboration
				collab.remove((Element)collab.elementIterator("result").next());
				Iterator iter = collab.elementIterator("result");
				while(iter.hasNext()) {
					collab.remove((Element) iter.next());
				}
				// remove ino:id
				QName qname = new QName("id",INO_NAMESPACE);
				collab.remove(collab.attribute(qname));
				// and add collab to jazzMusician
				jazzMusician.add(collab);
			}
			// Output with DOM4J XMLWriter
			xmlWriter.write(jazzMusician);
		}
		catch (Exception e)  {
			throw e;
		}
		finally  {
			// Close the connection.
			connection.close();
		}
	}
	/**
	 * @param args the command line arguments
	 */
	public static void main(String[] args) throws Exception  {
		long startTime = System.currentTimeMillis();
		MusicianCollaborationResultDOM4J musicianCollaborationResult =
		new MusicianCollaborationResultDOM4J( DATABASE_URI , COLLECTION );
		musicianCollaborationResult.show(args[0]);
		System.out.println("\n\nMusicianCollaborationResultDOM4J needs :"+
							   (System.currentTimeMillis() - startTime)+
						   " milliseconds");
		
	}
	// Constant for the database URI.
	private final static String DATABASE_URI =
	"http://localhost/tamino/jazz";
	// Constant for the collection.
	private final static String COLLECTION = "encyclopedia";
	// Constant for ino namespace.
	private final static Namespace INO_NAMESPACE =
	Namespace.get("ino", "http://namespaces.softwareag.com/tamino/response2");
	// The database connection.
	private TConnection connection = null;
	// The accessor instance, here a high level TXMLObjectAccessor.
	private TXMLObjectAccessor accessor = null;
}

