
(: generates a calendar in HTML for a given year.
   Copyright X. Franc 2003

   NOTE: uses non-standard operators and functions on dates ;-)
 :)

declare variable $year as xs:integer := get-year-from-date(current-date());

declare variable $first-day-of-year := xs:date($year, 1, 1) ;

(: first sunday in 1950 is Jan 1
   FIXME: something wrong when $day-shift < 0 (ie before reference date)
 :)
declare variable $day-shift :=
	($first-day-of-year - xs:date("1950-01-01")) mod 7 ;

declare variable $Months := 
  ( "January", "February", "March", "April", "May", "June",
    "July", "August", "September", "October", "November", "December")
;
  

declare function local:calendar( ) as document-node() {
 document {
 <html><head><title>Calendar for year { $year }</title>
 <style>
     .mod {{ text-decoration: none; color: #909090; border: solid 1px #e0e0e0;
	     font-size: 0.5em;  }}
 </style>
 </head>
 <body style='color: #505050; font-family: Arial, sans-serif; '>
  <h1 align='center'>
    <a href='calendar.xqsp?year={$year - 1}' class='mod'>&#160;&lt;&#160;{$year - 1}&#160;</a>
     &#160;<big>{ $year }</big>&#160;
    <a href='calendar.xqsp?year={$year + 1}' class='mod'>&#160;{$year + 1}&#160;&gt;&#160;</a>
    </h1>
  <table width="100%" cellspacing="6"><tbody valign="top" align="center"> {
   for $row in 0 to 3
     return <tr>{
       for $col in 0 to 2
         return <td bgcolor="#e8f8f8">{ local:generate-month(3 * $row + $col + 1) }</td>
       }</tr>
  }</tbody></table>
  <form><b>Another year: <input name='year' size='4'/></b>
    &#160;&#160;&#160;&#160;<a href="source.xqsp?src=calendar">View source code</a></form>
 </body>
 </html>
 }
};

declare function local:generate-month( $month as xs:integer ) as element() {
 <table border='0'>
  <thead><th colspan="7" bgcolor="#e0e8e8">{ $Months[$month] }</th></thead>
  <tr bgcolor="#f8fff8">
    <th>&#160;Su</th><th>&#160;Mo</th><th>&#160;Tu</th><th>&#160;We</th><th>&#160;Th</th>
    <th>&#160;Fr</th><th>&#160;Sa</th></tr>
 {
   let $month-start := ((xs:date( $year, $month, 1) - $first-day-of-year) idiv 7) * 7
   for $row in 0 to 5
     return <tr align="right">{
       for $col in 0 to 6
         return <td>{ local:generate-day(7 * $row + $col + $month-start, $month) }</td>
       }</tr>
 }
 </table>
};

declare function local:generate-day( $cell as xs:integer, $month as xs:integer ) {

  let $d := $first-day-of-year + ($cell - $day-shift)
  return if(get-month($d) ne $month) then "" else get-day($d)
};

local:calendar()
