/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.dm;

import net.xfra.qizxopen.util.*;
import java.io.*;

/**
 *	
 */
public class FONIDumper
{
    FONIDocument doc;
    StringBuffer sb = new StringBuffer();
    int maxDepth = 1000000;
    boolean tagStyle = true;

    public FONIDumper( FONIDocument doc ) {
	setDocument(doc);
    }

    public void setDocument(FONIDocument doc) {
	this.doc = doc;
    }

    public void setMaxDepth(int value) {
        maxDepth = value;
    }

    public void dump( int depth ) {
	try {
	    BufferedWriter out =
		new BufferedWriter(new OutputStreamWriter(System.out));
	    dump(out, depth);
	    out.flush();
	}
        catch (IOException e) {  e.printStackTrace();  }
    }

    public void dump( BufferedWriter out, int depth ) {
	try {
	    dumpTree(out, doc.getRootNode(), depth);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean dumpNode( BufferedWriter out, int nodeId, boolean dummy )
	throws IOException  {

	int type = doc.getKind(nodeId);
	if (type == Node.ELEMENT || type == Node.DOCUMENT) {
	    int gi = doc.getNameId(nodeId), attC = doc.getAttrCount(nodeId);
	    QName name = doc.getElementName(gi);
	    if (!dummy) {
		out.write("Element "+name+" span "+doc.getNodeSpan(nodeId)+" ");
		if(attC > 0)
		    out.write(attC + " attr:"); 
	    }
	    StringBuffer buf = new StringBuffer();
	    FONIDocument.NodeIterator attrIter = doc.attrIterator(nodeId);
	    while(attrIter.next()) {
		int attrNode = attrIter.currentId();
		name = doc.getOtherName(doc.pnGetNameId(attrNode));
		buf.append(' ').append(name);
		buf.append("='").
		    append(doc.pnGetStringValue(attrNode)).append('\'');
	    }
	    FONIDocument.NodeIterator nsit =
		doc.namespaceIterator(nodeId, false);
	    while(nsit.next()) {
		int nsNode = nsit.currentId();
		
		name = doc.getOtherName(doc.pnGetNameId(nsNode));
		buf.append("xmlns:").append(name).append("='").
		    append(doc.pnGetStringValue(nsNode)).append('\'');
	    }
	    if (!dummy) {
		out.write(buf.toString()); out.newLine();
	    }
	    return true;
	}
	else if (!dummy) {
	    sb.setLength(0);
	    switch(type) {
	    case Node.TEXT:
		out.write("|");
		out.write(doc.getStringValue(nodeId));
		out.write('|');
		break;
	    case Node.PROCESSING_INSTRUCTION:
		out.write("PI ");
		out.write(doc.getName(nodeId).toString());
		out.write(" |");
		out.write(doc.getStringValue(nodeId));
		out.write('|');
		break;
	    case Node.COMMENT:
		out.write("Comment |");
		out.write(doc.getStringValue(nodeId));
		out.write('|');
		break;
	    default:
		Object atval = doc.getValue(nodeId);
		out.write("Atom["+type+"] "+atval.getClass()+" = "+atval);
	    }
	    out.newLine();
	}
	return false;
    }

    public void dumpTree(BufferedWriter out, int nodeId, int depth )
	throws IOException {
	boolean dummy = maxDepth < 0;
	if (!dummy && depth > maxDepth)
	    return;
	if(!dummy) {
	    out.write(Integer.toString(nodeId));
	    for(int d = 0; d < depth; d++) out.write("  ");
	}
	if(dumpNode(out, nodeId, dummy) && (dummy || depth < maxDepth)) {
	    int kid = doc.getFirstChild(nodeId), next;
	    int rank = 0;
	    for( ; kid != 0; kid = next, ++ rank) {
		// anticipating next is more cache-efficient:
		next = doc.getNextSibling(kid);
		//if (next == NULL_ID && rank == 0 && getKind(kid) == Node.TEXT)
		//    ++ nTextSingle;
		dumpTree(out, kid, depth + 1);
	    }
	}
    }

    public int adjust(int nodeId) {
	int container = doc.getRootNode();
	for(int depth = 0; ; depth++) {
	    int span = doc.getNodeSpan(container), kind = doc.getKind(container);
	    if(kind != Node.ELEMENT && kind != Node.DOCUMENT) 
		break;
	    int kid = doc.getFirstChild(container), next;
	    int rank = 0;
	    for( ; kid != 0; kid = next, ++ rank) {
		next = doc.getNextSibling(kid);
		if(kid > nodeId)
		    return container;
		if(kid + doc.getNodeSpan(kid) > nodeId) {
		    container = kid;
		    break;
		}
	    }
	}
	return container;
    }

} // end of class Dumper

