/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */
package net.xfra.qizxopen.dm;

import net.xfra.qizxopen.util.NSTable;
import net.xfra.qizxopen.util.ProgressHandler;

import java.io.IOException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

/**
 *	Interface for the creation of FONIDocuments, SAX2 extension.
 */
public abstract class FONIWriter extends DefaultHandler
       implements LexicalHandler
{
    protected int docId;
    protected ProgressHandler progressHandler;

    /**
     *	A variant of SAX.characters(char[], ...)
     */
    public abstract void  characters (String chars);
    /**
     *	Creates an atom with any object value. This value must be serializable.
     */
    public abstract void  atom( Object value ) throws SAXException;

    /**
     *	Returns an identifier associated with the document. May be null.
     */
    public int  getDocumentId() {
	return docId;
    }

    public void setDocumentId(int value) {
        docId = value;
    }

    public abstract void close() throws IOException, SAXException;

    public void setProgressHandler( ProgressHandler progressHandler ) {
	this.progressHandler = progressHandler;
    }

} // end of interface FONIWriter
