/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.dm;

/**
 *	Abstract Iterator on Nodes.
 *	<p>Nodes are enumerated through nextNode() and currentNode().
 *	<p>The sequence cannot be rewinded, but it can be cloned in its initial
 *	state by reborn().
 */
public interface NodeSequence
{
    /**
     *	Attempts to get the next Node.  
     *  If true is returned, the Node value is available through currentNode().
     */
    boolean  nextNode();
    /**
     *	The last node reached (must be preceded by nextNode(), otherwise
     *	the result is indefined.)
     */
    Node   currentNode();
    /**
     *	New incarnation of this sequence: a clone in initial state.
     */
    NodeSequence reborn();
}
