/*
 *	Qizx/Open version 0.4p2
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.dm;

import net.xfra.qizxopen.util.QName;

/**
 * Test of a node on behalf of path-steps or type matching.
 */
public interface NodeTest {

    /**
     * Optimized test method. Can be used if only the node-kind and its name are
     * necessary. This condition can be tested with method {@link #needsNode}.
     * 
     * @return true if node matched. A null name is always accepted.
     */
    boolean accepts( int kind, QName name );

    /**
     * Generic test method.
     * 
     * @return true if node matched. Used for extended tests like DocumentTest.
     */
    boolean accepts( Node node );

    /**
     * Tells whether more information than the node kind and its name are necessary to
     * perform the test.
     * 
     * @return true if the node itself is necessary for checking (not only the kind and
     * name). Allows optimization (avoids building a Node just for testing). Returns
     * true for extended tests like DocumentTest.
     */
    boolean needsNode();

    /**
     * Returns the node kind (Node.ELEMENT, Node.TEXT etc) specifically matched, or -1
     * if several kinds can be matched.
     */
    int getNodeKind();

    /**
     * Returns true for simple node test (node kind only).
     */
    boolean staticallyCheckable();
}
